
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.axis2.jaxws.sample.nonwrap.sei;

import org.test.sample.nonwrap.OneWay;
import org.test.sample.nonwrap.OneWayVoid;
import org.test.sample.nonwrap.ReturnType;
import org.test.sample.nonwrap.TwoWay;
import org.test.sample.nonwrap.TwoWayHolder;

import jakarta.jws.Oneway;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebParam.Mode;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import jakarta.jws.soap.SOAPBinding;
import jakarta.jws.soap.SOAPBinding.ParameterStyle;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.Response;
import java.util.concurrent.Future;

/**
 * This class was generated by the JAXWS SI.
 * JAX-WS RI 2.0_01-b15-fcs
 * Generated source version: 2.0
 * 
 */
@WebService(name = "DocLitNonWrapPortType", targetNamespace = "http://nonwrap.sample.test.org")
@SOAPBinding(parameterStyle = ParameterStyle.BARE)
public interface DocLitNonWrapPortType {


    /**
     * 
     * @param allByMyself
     */
    @WebMethod(action = "http://nonwrap.sample.test.org/twoWayReturn")
    @Oneway
    public void oneWayVoid(
        @WebParam(name = "oneWayVoid", targetNamespace = "http://nonwrap.sample.test.org", partName = "allByMyself")
        OneWayVoid allByMyself);

    /**
     * 
     * @param allByMyself
     */
    @WebMethod(action = "http://nonwrap.sample.test.org/twoWayReturn")
    @Oneway
    public void oneWay(
        @WebParam(name = "oneWay", targetNamespace = "http://nonwrap.sample.test.org", partName = "allByMyself")
        OneWay allByMyself);

    /**
     * 
     * @param allByMyself
     * @return
     *     returns jakarta.xml.ws.Response<org.test.sample.nonwrap.TwoWayHolder>
     */
    @WebMethod(operationName = "twoWayHolder", action = "http://nonwrap.sample.test.org/twoWayReturn")
    public Response<TwoWayHolder> twoWayHolderAsync(
        @WebParam(name = "twoWayHolder", targetNamespace = "http://nonwrap.sample.test.org", partName = "allByMyself")
        TwoWayHolder allByMyself);

    /**
     * 
     * @param allByMyself
     * @param asyncHandler
     * @return
     *     returns java.util.concurrent.Future<? extends java.lang.Object>
     */
    @WebMethod(operationName = "twoWayHolder", action = "http://nonwrap.sample.test.org/twoWayReturn")
    public Future<?> twoWayHolderAsync(
        @WebParam(name = "twoWayHolder", targetNamespace = "http://nonwrap.sample.test.org", partName = "allByMyself")
        TwoWayHolder allByMyself,
        @WebParam(name = "twoWayHolderResponse", targetNamespace = "", partName = "asyncHandler")
        AsyncHandler<TwoWayHolder> asyncHandler);

    /**
     * 
     * @param allByMyself
     */
    @WebMethod(action = "http://nonwrap.sample.test.org/twoWayReturn")
    public void twoWayHolder(
        @WebParam(name = "twoWayHolder", targetNamespace = "http://nonwrap.sample.test.org", mode = Mode.INOUT, partName = "allByMyself")
        Holder<TwoWayHolder> allByMyself);

    /**
     * 
     * @param allByMyself
     * @return
     *     returns jakarta.xml.ws.Response<org.test.sample.nonwrap.ReturnType>
     */
    @WebMethod(operationName = "twoWay", action = "http://nonwrap.sample.test.org/twoWayReturn")
    public Response<ReturnType> twoWayAsync(
        @WebParam(name = "twoWay", targetNamespace = "http://nonwrap.sample.test.org", partName = "allByMyself")
        TwoWay allByMyself);

    /**
     * 
     * @param allByMyself
     * @param asyncHandler
     * @return
     *     returns java.util.concurrent.Future<? extends java.lang.Object>
     */
    @WebMethod(operationName = "twoWay", action = "http://nonwrap.sample.test.org/twoWayReturn")
    public Future<?> twoWayAsync(
        @WebParam(name = "twoWay", targetNamespace = "http://nonwrap.sample.test.org", partName = "allByMyself")
        TwoWay allByMyself,
        @WebParam(name = "twoWayResponse", targetNamespace = "", partName = "asyncHandler")
        AsyncHandler<ReturnType> asyncHandler);

    /**
     * 
     * @param allByMyself
     * @return
     *     returns org.test.sample.nonwrap.ReturnType
     */
    @WebMethod(action = "http://nonwrap.sample.test.org/twoWayReturn")
    @WebResult(name = "ReturnType", targetNamespace = "http://nonwrap.sample.test.org", partName = "allByMyself")
    public ReturnType twoWay(
        @WebParam(name = "twoWay", targetNamespace = "http://nonwrap.sample.test.org", partName = "allByMyself")
        TwoWay allByMyself);

}
