Apache Axis2 2.0.0 Release Notes
--------------------------------

This release marks the transition to jakarta that has been tested with Tomcat 11
and Wildfly 32, and is expected to support EE 10 and Spring 6 / Spring Boot 3.

The Axis2 project transition to jakarta depends partly on Axiom, which has also been updated to 2.0.0.

HTTPClient has been updated to 5.x, so update your axis2.xml files from httpclient4 to httpclient5. 

Previously generated sources from WSDL2Java with javax references may or may not work in the latest Tomcat / Wildfly. You may have to regenerate your sources or globably replace the required jakarta imports.  

The JSON support has been updated with many bugs fixed, while the examples in the user guide have been updated to use Spring Boot 3. If you want to support native JSON with simple POJO's and no SOAP, axis2 can that. See the new enableJSONOnly flag in axis2.xml. 

For those who want to support both SOAP and JSON, the JSON support docs for the XML Stream API Base Approach have been improved.

Axis2 added two committers recently and after this big jakarta update that changed nearly every file and dependency of the project, the community can once again expect releases several times a year to fix bugs and update dependencies with CVE's.

The main purpose of the release is to upgrade everything possible to the latest,
and have our Jira issues cleaned up. Many issues have been fixed. 

New features that may happen in the future are HTTP/2 support and OpenAPI. Let us
know on the dev list if interested.

The most likely way to get a Jira issue fixed is with a GitHub PR or patch, due to 
the large amount of Axis2 features that are unused by the committers and therefore
difficult to test a fix.

If your Jira issue is unfixed, please reach out and work with the committers on
some type of code contibution and testing as some issues are just too deep in areas that the comitters don't use ourselves.

The 2.0.0 release lacks a few features in previous releases because of a lack of 
adequate GitHub PR's.

These missing features include preemptive basic authentication, though there is a work around explained in the Jira issue https://issues.apache.org/jira/browse/AXIS2-6055 .

OSGI support is also missing. The state of its dependency Felix and jakarta is unclear. This feature has code that is difficult to support and lacks GitHub PR's after several attempts to gain volunteers. We hope to support OSGI again in 2.0.1.

The Eclipse plugins are broken. The docs as well as the code are outdated. If interested in contributing a fix, see Jira issue AXIS2-5955.

For those interested in Rampart - an optional implementation of WS-Sec* standards that depends on Axis2 - they can expect a Rampart 2.0.0 soon that isn't expected to add much to the recently released Rampart 1.8.0, a release that is based on the previous Axis2 version 1.8.2. Mostly, the upcoming Rampart 2.0.0 release will upgrade OpenSAML to 5.x so that it supports jakarta, while the remaining deps that need updates are few.

Apache Axis2 2.0.0 Jira issues fixed
------------------------------------
                
<h2>        Bug
</h2>
<ul>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-5689'>AXIS2-5689</a>] -         A Veracode security scan reports multiple severity 4 security flaws in axis2.jar
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-5900'>AXIS2-5900</a>] -         If and else branches has the same condition
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-5901'>AXIS2-5901</a>] -         Redundant conditions in an if statement
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-5948'>AXIS2-5948</a>] -         Proxy settings ignored if username not specified
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-5964'>AXIS2-5964</a>] -         AbstractJSONMessageFormatter NOT using CharSetEncoding when reding Json string Bytes
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6030'>AXIS2-6030</a>] -         Axis2 connections are not returned to connection pool on 1.8.0 with JAXWS
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6035'>AXIS2-6035</a>] -         Axis2 libraries not compatible with Tomcat 10
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6037'>AXIS2-6037</a>] -         Install axis2-plugin-intelliJ error
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6041'>AXIS2-6041</a>] -         totalDigits Facet of XSD type short incorrectly treated in databinding
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6042'>AXIS2-6042</a>] -         Eclipse Plugin Downloads
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6043'>AXIS2-6043</a>] -         StackOverflowError in  org.apache.axis2.client.Options.getSoapVersionURI()
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6044'>AXIS2-6044</a>] -         HTTPProxyConfigurator system property takes precedence over axis configuration and message context proxy properties
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6045'>AXIS2-6045</a>] -         NPE after upgrade to 1.8.2
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6046'>AXIS2-6046</a>] -         AxisFault after upgrade to 1.8.0
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6050'>AXIS2-6050</a>] -         Latest Axis2 1.8.2 release not compatible with Glassfish6/J2EE9
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6057'>AXIS2-6057</a>] -         Special characters are not allowed in password after upgrade( from 1.7.9 to 1.8.2)
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6062'>AXIS2-6062</a>] -         Is such a flexibility necessary allowing LDAP (and RMI, JRMP, etc.) protocol in `JMSSender`?
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6063'>AXIS2-6063</a>] -         Add enableJSONOnly parameter to axis2.xml
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6064'>AXIS2-6064</a>] -         CVE associtate with dependency jars of axis2
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6065'>AXIS2-6065</a>] -         Small problem with incorrect log output in AxisServlet#processAxisFault
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6066'>AXIS2-6066</a>] -         Site generation/deployment is broken
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6067'>AXIS2-6067</a>] -         CVE with dependency jars of axis2
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6068'>AXIS2-6068</a>] -         ConverterUtilTest is locale-dependent
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6073'>AXIS2-6073</a>] -         Axis2 httpclient5 RequstImpl doesnt initialize version &amp; protocol with https
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6075'>AXIS2-6075</a>] -         axis2-wsdl2code-maven-plugin documentation is stuck on version 1.7.9
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6080'>AXIS2-6080</a>] -         Axis2 1.8.2 Missing Libraries for Apache Tomcat 11.0.2
</li>
</ul>
                
<h2>        Improvement
</h2>
<ul>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-5975'>AXIS2-5975</a>] -         More specific Runtime Exceptions instead of just &quot;Input values do not follow defined XSD restrictions&quot;
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6049'>AXIS2-6049</a>] -         Generated Exceptions differ each generation
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6054'>AXIS2-6054</a>] -         when an inexistent enum value arrives, do not just throw an IllegalArgumentException without any exception
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6059'>AXIS2-6059</a>] -         Improve logging by default
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6069'>AXIS2-6069</a>] -         Disable admin console login by removing default credential values
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6071'>AXIS2-6071</a>] -         Add new class JSONBasedDefaultDispatcher that skips legacy SOAP code 
</li>
</ul>
        
<h2>        Wish
</h2>
<ul>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-5953'>AXIS2-5953</a>] -         Upgrade  javax.mail version
</li>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6051'>AXIS2-6051</a>] -         Axis2 Future Roadmap in keeping up with new Java Versions
</li>
</ul>
    
<h2>        Task
</h2>
<ul>
<li>[<a href='https://issues.apache.org/jira/browse/AXIS2-6078'>AXIS2-6078</a>] -         Remove Google Analytics from 5 Pages on Axis Website
</li>
</ul>
