/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.NodeFactory;
import org.apache.axiom.core.NodeFactory2;
import org.apache.axiom.core.NodeFactoryException;
import org.apache.axiom.core.util.EdgeRelation;
import org.apache.axiom.core.util.TopologicalSort;

public abstract class NodeFactoryImpl
implements NodeFactory {
    private final NodeFactory2 factory2;
    private final Map<Class<?>, Constructor<?>> constructorMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NodeFactoryImpl(ClassLoader cl, String factory2ClassName, String ... packages) {
        super();
        try {
            this.factory2 = (NodeFactory2)cl.loadClass(factory2ClassName).getDeclaredField("INSTANCE").get(null);
        }
        catch (ReflectiveOperationException ex) {
            throw new NodeFactoryException("Failed to instantiate NodeFactory2 implementation", ex);
        }
        implementations = new ArrayList<E>();
        var5_6 = packages;
        var6_7 = var5_6.length;
        var7_9 = 0;
        while (true) {
            if (var7_9 >= var6_7) ** GOTO lbl21
            pkg = var5_6[var7_9];
            try {
                var9_12 = new BufferedReader(new InputStreamReader(cl.getResourceAsStream(pkg.replace('.', '/') + "/nodetypes.index"), StandardCharsets.UTF_8));
                ** try [egrp 2[TRYBLOCK] [2 : 113->187)] { 
lbl17:
                // 1 sources

                ** GOTO lbl-1000
lbl18:
                // 1 sources

                finally {
                    var9_12.close();
lbl21:
                    // 1 sources

                    implementations = TopologicalSort.sort(implementations, new EdgeRelation<Class<?>>(){

                        @Override
                        public boolean isEdge(Class<?> from, Class<?> to) {
                            return to.isAssignableFrom(from);
                        }
                    });
                    interfaceToImplementationMap = new HashMap<Class, Class>();
                    implementationToConstructorMap = new HashMap<Class, Constructor<T>>();
                    ambiguousInterfaces = new HashSet<Class>();
                    var8_11 = implementations.iterator();
                    break;
lbl-1000:
                    // 3 sources

                    {
                        while ((line = var9_12.readLine()) != null) {
                            if (line.startsWith("#")) continue;
                            className = pkg + "." + line;
                            try {
                                implementations.add(cl.loadClass(className));
                            }
                            catch (ClassNotFoundException var12_21) {
                                throw new NodeFactoryException("Failed to load class " + (String)className, var12_21);
                            }
                        }
                    }
                }
            }
            catch (IOException var9_13) {
                throw new NodeFactoryException("Failed to load node type index for package " + pkg, var9_13);
            }
            ++var7_9;
        }
        while (var8_11.hasNext()) {
            var9_15 = (Class)var8_11.next();
            interfaces = new HashSet<Class<?>>();
            NodeFactoryImpl.collectInterfaces(var9_15, interfaces);
            for (Class var12_22 : interfaces) {
                if (ambiguousInterfaces.contains(var12_22)) continue;
                clazz = (Class)interfaceToImplementationMap.get(var12_22);
                if (clazz == null || var9_15.isAssignableFrom(clazz)) {
                    interfaceToImplementationMap.put(var12_22, var9_15);
                    continue;
                }
                if (clazz.isAssignableFrom(var9_15)) continue;
                interfaceToImplementationMap.remove(var12_22);
                ambiguousInterfaces.add(var12_22);
            }
            try {
                implementationToConstructorMap.put(var9_15, var9_15.getConstructor(new Class[0]));
            }
            catch (NoSuchMethodException ex) {
                throw new NodeFactoryException("Failed to get constructor for " + var9_15.getName(), ex);
            }
        }
        this.constructorMap = new HashMap<Class<?>, Constructor<?>>();
        var8_11 = interfaceToImplementationMap.entrySet().iterator();
        while (true) {
            if (!var8_11.hasNext()) {
                this.constructorMap.putAll(implementationToConstructorMap);
                return;
            }
            var9_17 = (Map.Entry)var8_11.next();
            this.constructorMap.put((Class)var9_17.getKey(), (Constructor)implementationToConstructorMap.get(var9_17.getValue()));
        }
    }

    private static void collectInterfaces(Class<?> clazz, Set<Class<?>> interfaces) {
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!interfaces.add(iface)) continue;
            NodeFactoryImpl.collectInterfaces(iface, interfaces);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            NodeFactoryImpl.collectInterfaces(superclass, interfaces);
        }
    }

    @Override
    public NodeFactory2 getFactory2() {
        return this.factory2;
    }

    @Override
    public final <T extends CoreNode> T createNode(Class<T> type) {
        Constructor<?> constructor = this.constructorMap.get(type);
        if (constructor == null) {
            throw new NodeFactoryException("Unknown node type " + type.getName());
        }
        try {
            return (T)((CoreNode)type.cast(constructor.newInstance(new Object[0])));
        }
        catch (InvocationTargetException ex) {
            throw new NodeFactoryException("Caught exception thrown by constructor", ex.getCause());
        }
        catch (InstantiationException ex) {
            throw new NodeFactoryException("Failed to invoke constructor", ex);
        }
        catch (IllegalAccessException ex) {
            throw new NodeFactoryException("Failed to invoke constructor", ex);
        }
    }
}

