/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.Mapper;
import org.apache.axiom.core.Semantics;

public final class AttributeIterator<T extends CoreAttribute, S>
implements Iterator<S> {
    private final Class<T> type;
    private final Mapper<S, ? super T> mapper;
    private final Semantics semantics;
    private CoreAttribute currentAttribute;
    private CoreAttribute nextAttribute;
    private boolean nextAttributeSet;

    private AttributeIterator(CoreAttribute firstAttribute, Class<T> type, Mapper<S, ? super T> mapper, Semantics semantics) {
        this.type = type;
        this.mapper = mapper;
        this.semantics = semantics;
        this.nextAttribute = firstAttribute;
        this.nextAttributeSet = true;
    }

    public static <T extends CoreAttribute, S> Iterator<S> create(CoreElement element, Class<T> type, Mapper<S, ? super T> mapper, Semantics semantics) {
        CoreAttribute attribute;
        for (attribute = element.coreGetFirstAttribute(); attribute != null && !type.isInstance(attribute); attribute = attribute.coreGetNextAttribute()) {
        }
        if (attribute == null) {
            return Collections.emptyList().iterator();
        }
        return new AttributeIterator<T, S>(attribute, type, mapper, semantics);
    }

    @Override
    public final boolean hasNext() {
        if (!this.nextAttributeSet) {
            CoreAttribute attribute = this.currentAttribute;
            while ((attribute = attribute.coreGetNextAttribute()) != null && !this.type.isInstance(attribute)) {
            }
            this.nextAttribute = attribute;
            this.nextAttributeSet = true;
        }
        return this.nextAttribute != null;
    }

    @Override
    public final S next() {
        if (this.hasNext()) {
            CoreAttribute attribute;
            this.currentAttribute = attribute = this.nextAttribute;
            this.nextAttribute = null;
            this.nextAttributeSet = false;
            return this.mapper.map(this.type.cast(attribute));
        }
        throw new NoSuchElementException();
    }

    @Override
    public final void remove() {
        if (this.currentAttribute == null) {
            throw new IllegalStateException();
        }
        this.hasNext();
        this.currentAttribute.coreRemove(this.semantics);
        this.currentAttribute = null;
    }
}

