/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.AbstractIssuerConfig;

public class SCTIssuerConfig
extends AbstractIssuerConfig {
    public static final QName SCT_ISSUER_CONFIG = new QName("sct-issuer-config");
    protected byte[] requesterEntropy;

    private SCTIssuerConfig(OMElement elem) throws TrustException {
        OMElement keyCompElem;
        OMElement proofKeyElem = elem.getFirstChildWithName(PROOF_KEY_TYPE);
        if (proofKeyElem != null) {
            this.proofKeyType = proofKeyElem.getText().trim();
        }
        OMElement cryptoPropertiesElem = elem.getFirstChildWithName(new QName("cryptoProperties"));
        if (!"BinarySecret".equals(this.proofKeyType) && cryptoPropertiesElem == null) {
            throw new TrustException("sctIssuerCryptoPropertiesMissing");
        }
        this.addRequestedAttachedRef = elem.getFirstChildWithName(ADD_REQUESTED_ATTACHED_REF) != null;
        this.addRequestedUnattachedRef = elem.getFirstChildWithName(ADD_REQUESTED_UNATTACHED_REF) != null;
        this.cryptoElement = cryptoPropertiesElem.getFirstChildWithName(CRYPTO);
        if (this.cryptoElement == null) {
            this.cryptoPropertiesFile = cryptoPropertiesElem.getText().trim();
        }
        if ((keyCompElem = elem.getFirstChildWithName(AbstractIssuerConfig.KeyComputation.KEY_COMPUTATION)) != null && keyCompElem.getText() != null && !"".equals(keyCompElem.getText())) {
            this.keyComputation = Integer.parseInt(keyCompElem.getText());
        }
    }

    public static SCTIssuerConfig load(OMElement elem) throws TrustException {
        return new SCTIssuerConfig(elem);
    }

    public static SCTIssuerConfig load(String configFilePath) throws TrustException {
        StAXOMBuilder builder;
        try {
            FileInputStream fis = new FileInputStream(configFilePath);
            builder = new StAXOMBuilder((InputStream)fis);
        }
        catch (Exception e) {
            throw new TrustException("errorLoadingConfigFile", new String[]{configFilePath});
        }
        return SCTIssuerConfig.load(builder.getDocumentElement());
    }
}

