/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.beans;

import org.apache.axis2.addressing.EndpointReference;
import org.apache.sandesha2.storage.beans.RMBean;

public class RMSequenceBean
extends RMBean {
    private static final long serialVersionUID = 1335488724679432728L;
    private String sequenceID;
    private String toEPR;
    private String replyToEPR;
    private String acksToEPR;
    private String rMVersion;
    private String securityTokenData;
    private long lastActivatedTime;
    private boolean closed = false;
    private boolean terminated = false;
    private boolean pollingMode = false;
    private String serviceName = null;
    private int flags = 0;
    private EndpointReference acksToEndpointRef;
    private EndpointReference toEndpointReference;
    private EndpointReference replyToEndpointReference;
    public static final int LAST_ACTIVATED_TIME_FLAG = 1;
    public static final int CLOSED_FLAG = 16;
    public static final int TERMINATED_FLAG = 256;
    public static final int POLLING_MODE_FLAG = 4096;

    public RMSequenceBean() {
    }

    public RMSequenceBean(RMSequenceBean beanToCopy) {
        this.acksToEPR = beanToCopy.getAcksToEPR();
        this.acksToEndpointRef = beanToCopy.getAcksToEndpointReference();
        this.closed = beanToCopy.isClosed();
        this.lastActivatedTime = beanToCopy.getLastActivatedTime();
        this.pollingMode = beanToCopy.isPollingMode();
        this.replyToEPR = beanToCopy.getReplyToEPR();
        this.replyToEndpointReference = beanToCopy.getReplyToEndpointReference();
        this.rMVersion = beanToCopy.getRMVersion();
        this.securityTokenData = beanToCopy.getSecurityTokenData();
        this.sequenceID = beanToCopy.getSequenceID();
        this.terminated = beanToCopy.isTerminated();
        this.toEPR = beanToCopy.getToEPR();
        this.toEndpointReference = beanToCopy.getToEndpointReference();
        this.serviceName = beanToCopy.getServiceName();
    }

    public RMSequenceBean(String sequenceID) {
        this.setSequenceID(sequenceID);
    }

    public String getSequenceID() {
        return this.sequenceID;
    }

    public void setSequenceID(String sequenceID) {
        this.sequenceID = sequenceID;
    }

    public String getAcksToEPR() {
        return this.acksToEPR;
    }

    public EndpointReference getAcksToEndpointReference() {
        if (this.acksToEndpointRef == null && this.acksToEPR != null) {
            this.acksToEndpointRef = new EndpointReference(this.acksToEPR);
        }
        return this.acksToEndpointRef;
    }

    public void setAcksToEPR(String acksToEPR) {
        this.acksToEPR = acksToEPR;
    }

    public void setAcksToEndpointReference(EndpointReference acksToEndpointRef) {
        this.acksToEndpointRef = acksToEndpointRef;
        if (acksToEndpointRef != null) {
            this.acksToEPR = acksToEndpointRef.getAddress();
        }
    }

    public String getReplyToEPR() {
        return this.replyToEPR;
    }

    public EndpointReference getReplyToEndpointReference() {
        if (this.replyToEndpointReference == null && this.replyToEPR != null) {
            this.replyToEndpointReference = new EndpointReference(this.replyToEPR);
        }
        return this.replyToEndpointReference;
    }

    public void setReplyToEPR(String replyToEPR) {
        this.replyToEPR = replyToEPR;
    }

    public void setReplyToEndpointReference(EndpointReference replyToEndpointRef) {
        this.replyToEndpointReference = replyToEndpointRef;
        this.replyToEPR = replyToEndpointRef.getAddress();
    }

    public String getToEPR() {
        return this.toEPR;
    }

    public EndpointReference getToEndpointReference() {
        if (this.toEndpointReference == null && this.toEPR != null) {
            this.toEndpointReference = new EndpointReference(this.toEPR);
        }
        return this.toEndpointReference;
    }

    public void setToEPR(String toEPR) {
        this.toEPR = toEPR;
    }

    public void setToEndpointReference(EndpointReference toEndpointRef) {
        this.toEndpointReference = toEndpointRef;
        this.toEPR = this.toEndpointReference.getAddress();
    }

    public boolean isPollingMode() {
        return this.pollingMode;
    }

    public void setPollingMode(boolean pollingMode) {
        this.pollingMode = pollingMode;
        this.flags |= 0x1000;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
        this.flags |= 0x10;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
        this.flags |= 0x100;
    }

    public long getLastActivatedTime() {
        return this.lastActivatedTime;
    }

    public void setLastActivatedTime(long lastActivatedTime) {
        this.lastActivatedTime = lastActivatedTime;
        this.flags |= 1;
    }

    public String getRMVersion() {
        return this.rMVersion;
    }

    public void setRMVersion(String version) {
        this.rMVersion = version;
    }

    public String getSecurityTokenData() {
        return this.securityTokenData;
    }

    public void setSecurityTokenData(String securityTokenData) {
        this.securityTokenData = securityTokenData;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("\nSequence Id  : ");
        result.append(this.sequenceID);
        result.append("\ntoEPR        : ");
        result.append(this.toEPR);
        result.append("\nreplyToEPR   : ");
        result.append(this.replyToEPR);
        result.append("\nacksToEPR    : ");
        result.append(this.acksToEPR);
        result.append("\nPolling    : ");
        result.append(this.pollingMode);
        result.append("\nClosed       : ");
        result.append(this.closed);
        result.append("\nTerminated       : ");
        result.append(this.terminated);
        result.append("\nLastActivatedTime: ");
        result.append(this.lastActivatedTime);
        result.append("\nRMVersion        : ");
        result.append(this.rMVersion);
        result.append("\nServiceName        : ");
        result.append(this.serviceName);
        result.append("\nHas SecurityToken: ");
        result.append(this.securityTokenData != null && this.securityTokenData.length() > 0);
        return result.toString();
    }

    public boolean match(RMBean matchInfo) {
        RMSequenceBean bean = (RMSequenceBean)matchInfo;
        boolean match = true;
        if (bean.getSequenceID() != null && !bean.getSequenceID().equals(this.getSequenceID())) {
            match = false;
        } else if (bean.getToEndpointReference() != null && this.getToEndpointReference() != null && !bean.getToEndpointReference().getAddress().equals(this.getToEndpointReference().getAddress()) || bean.getToEPR() != null && !bean.getToEPR().equals(this.getToEPR())) {
            match = false;
        } else if (bean.getReplyToEndpointReference() != null && this.getReplyToEndpointReference() != null && !bean.getReplyToEndpointReference().getAddress().equals(this.getReplyToEndpointReference().getAddress()) || bean.getReplyToEPR() != null && !bean.getReplyToEPR().equals(this.getReplyToEPR())) {
            match = false;
        } else if (bean.getAcksToEndpointReference() != null && this.getAcksToEndpointReference() != null && !bean.getAcksToEndpointReference().getAddress().equals(this.getAcksToEndpointReference().getAddress()) || bean.getAcksToEPR() != null && !bean.getAcksToEPR().equals(this.getAcksToEPR())) {
            match = false;
        } else if (bean.getRMVersion() != null && !bean.getRMVersion().equals(this.getRMVersion())) {
            match = false;
        } else if (bean.getSecurityTokenData() != null && !bean.getSecurityTokenData().equals(this.getSecurityTokenData())) {
            match = false;
        } else if ((bean.flags & 0x10) != 0 && bean.isClosed() != this.isClosed()) {
            match = false;
        } else if ((bean.flags & 0x100) != 0 && bean.isTerminated() != this.isTerminated()) {
            match = false;
        } else if ((bean.flags & 0x1000) != 0 && bean.isPollingMode() != this.isPollingMode()) {
            match = false;
        }
        return match;
    }
}

