---
title: "Built-in I/O Transforms"
---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Built-in I/O Transforms

This table contains the currently available I/O transforms.

Consult the [Programming Guide I/O section](/documentation/programming-guide#pipeline-io) for general usage instructions.

{{< language-switcher java py go >}}

{{< io-matrix >}}

# In-Progress I/O Transforms

This table contains I/O transforms that are currently planned or in-progress. Status information can be found on the JIRA issue, or on the GitHub PR linked to by the JIRA issue (if there is one).

<table class="table table-bordered">
  <tr>
    <th>Name</th><th>Language</th><th>JIRA</th>
  </tr>
  <tr>
    <td>Apache DistributedLog</td><td>Java</td>
    <td><a href="https://issues.apache.org/jira/browse/BEAM-607">BEAM-607</a></td>
  </tr>
  <tr>
    <td>Apache Sqoop</td><td>Java</td>
    <td><a href="https://issues.apache.org/jira/browse/BEAM-67">BEAM-67</a></td>
  </tr>
  <tr>
    <td>Couchbase</td><td>Java</td>
    <td><a href="https://issues.apache.org/jira/browse/BEAM-1893">BEAM-1893</a></td>
  </tr>
  <tr>
    <td>InfluxDB</td><td>Java</td>
    <td><a href="https://issues.apache.org/jira/browse/BEAM-2546">BEAM-2546</a></td>
  </tr>
  <tr>
    <td>Memcached</td><td>Java</td>
    <td><a href="https://issues.apache.org/jira/browse/BEAM-1678">BEAM-1678</a></td>
  </tr>
  <tr>
    <td>Neo4j</td><td>Java</td>
    <td><a href="https://issues.apache.org/jira/browse/BEAM-1857">BEAM-1857</a></td>
  </tr>
  <tr>
    <td>Pub/Sub Lite</td><td>Java</td>
    <td><a href="https://issues.apache.org/jira/browse/BEAM-10114">BEAM-10114</a></td>
  </tr>
  <tr>
    <td>RestIO</td><td>Java</td>
    <td><a href="https://issues.apache.org/jira/browse/BEAM-1946">BEAM-1946</a></td>
  </tr>
</table>
