/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang;

import com.google.common.annotations.Beta;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.text.Strings;

@Beta
public class MemoryUsageTracker {
    public static final MemoryUsageTracker SOFT_REFERENCES = new MemoryUsageTracker();
    AtomicLong bytesUsed = new AtomicLong(0L);
    Cache<Object, Long> memoryTrackedReferences = CacheBuilder.newBuilder().weakKeys().removalListener((RemovalListener)new RemovalListener<Object, Long>(){

        public void onRemoval(RemovalNotification<Object, Long> notification) {
            MemoryUsageTracker.this.bytesUsed.addAndGet(-((Long)notification.getValue()).longValue());
        }
    }).build();

    public void track(Object instance, long bytesUsedByInstance) {
        this.bytesUsed.addAndGet(bytesUsedByInstance);
        this.memoryTrackedReferences.put(instance, (Object)bytesUsedByInstance);
    }

    public long getBytesUsed() {
        this.memoryTrackedReferences.cleanUp();
        return this.bytesUsed.get();
    }

    public static String forceClearSoftReferences() {
        return MemoryUsageTracker.forceClearSoftReferences(1000000L, Integer.MAX_VALUE);
    }

    public static String forceClearSoftReferences(long headroom, int maxChunk) {
        long HEADROOM = 1000000L;
        long lastAmount = 0L;
        long nextAmount = 0L;
        long oldUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        try {
            MutableList dd = MutableList.of();
            while (true) {
                int size;
                if ((long)(size = (int)Math.min(Runtime.getRuntime().freeMemory() - 1000000L, (long)maxChunk)) < 1000000L) {
                    size = (int)Math.min((long)size + 2000000L, (long)maxChunk);
                }
                dd.add(new byte[size]);
                lastAmount = nextAmount += (long)size;
            }
        }
        catch (OutOfMemoryError dd) {
            System.gc();
            System.gc();
            long newUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            return "allocated " + Strings.makeSizeString((lastAmount + nextAmount) / 2L) + (lastAmount < nextAmount ? " +- " + Strings.makeSizeString((nextAmount - lastAmount) / 2L) : "") + " really free memory in " + Strings.makeSizeString(maxChunk) + " chunks; memory used from " + Strings.makeSizeString(oldUsed) + " -> " + Strings.makeSizeString(newUsed) + " / " + Strings.makeSizeString(Runtime.getRuntime().totalMemory());
        }
    }

    public static class SoftUsageTracker {
        private Cache<Object, SoftReference<?>> cache = null;

        public synchronized void enable() {
            this.cache = CacheBuilder.newBuilder().weakKeys().build();
        }

        public synchronized void disable() {
            this.cache = null;
        }

        public synchronized long getTotalEntries() {
            return this.cache == null ? -1L : this.cache.size();
        }

        public synchronized double getPercentagePresent() {
            if (this.cache == null) {
                return -1.0;
            }
            int present = 0;
            int total = 0;
            for (SoftReference sr : this.cache.asMap().values()) {
                ++total;
                if (sr.get() == null) continue;
                ++present;
            }
            if (total == 0) {
                return -1.0;
            }
            return 1.0 * (double)present / (double)total;
        }

        public synchronized void track(Object key, SoftReference<?> ref) {
            if (this.cache != null) {
                this.cache.put(key, ref);
            }
        }

        public synchronized void untrack(Object key) {
            if (this.cache != null) {
                this.cache.invalidate(key);
            }
        }
    }
}

