/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.maven;

import com.google.common.base.Function;
import java.io.File;
import org.apache.brooklyn.util.maven.MavenArtifact;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.text.Strings;

public class MavenRetriever {
    public static final Function<MavenArtifact, String> CONDITIONAL_SNAPSHOT_URL_GENERATOR = new Function<MavenArtifact, String>(){

        public String apply(MavenArtifact artifact) {
            if (artifact.groupId.startsWith("org.apache")) {
                return (String)APACHE_SNAPSHOT_URL_GENERATOR.apply((Object)artifact);
            }
            return (String)SONATYPE_SNAPSHOT_URL_GENERATOR.apply((Object)artifact);
        }
    };
    public static final Function<MavenArtifact, String> SONATYPE_SNAPSHOT_URL_GENERATOR = MavenRetriever.nexusSnapshotUrlGenerator("https://oss.sonatype.org");
    public static final Function<MavenArtifact, String> APACHE_SNAPSHOT_URL_GENERATOR = MavenRetriever.nexusSnapshotUrlGenerator("https://repository.apache.org");
    public static final Function<MavenArtifact, String> MAVEN_CENTRAL_URL_GENERATOR = new Function<MavenArtifact, String>(){

        public String apply(MavenArtifact artifact) {
            return "http://search.maven.org/remotecontent?filepath=" + Urls.encode(Strings.replaceAllNonRegex(artifact.groupId, ".", "/") + "/" + artifact.artifactId + "/" + artifact.version + "/" + artifact.getFilename());
        }
    };
    public static final Function<MavenArtifact, String> LOCAL_REPO_PATH_GENERATOR = new Function<MavenArtifact, String>(){

        public String apply(MavenArtifact artifact) {
            return System.getProperty("user.home") + "/.m2/repository/" + Strings.replaceAllNonRegex(artifact.groupId, ".", "/") + "/" + artifact.artifactId + "/" + artifact.version + "/" + artifact.getFilename();
        }
    };
    protected Function<MavenArtifact, String> snapshotUrlGenerator = CONDITIONAL_SNAPSHOT_URL_GENERATOR;
    protected Function<MavenArtifact, String> releaseUrlGenerator = MAVEN_CENTRAL_URL_GENERATOR;

    public static Function<MavenArtifact, String> nexusSnapshotUrlGenerator(final String baseUrl) {
        return new Function<MavenArtifact, String>(){

            public String apply(MavenArtifact artifact) {
                return baseUrl + "/service/local/artifact/maven/redirect?r=snapshots&v=" + Urls.encode(artifact.version) + "&g=" + Urls.encode(artifact.groupId) + "&a=" + Urls.encode(artifact.artifactId) + "&" + (artifact.classifier != null ? "c=" + Urls.encode(artifact.classifier) + "&" : "") + "e=" + Urls.encode(artifact.packaging);
            }
        };
    }

    public void setSnapshotUrlGenerator(Function<MavenArtifact, String> snapshotUrlGenerator) {
        this.snapshotUrlGenerator = snapshotUrlGenerator;
    }

    public void setReleaseUrlGenerator(Function<MavenArtifact, String> releaseUrlGenerator) {
        this.releaseUrlGenerator = releaseUrlGenerator;
    }

    public String getHostedUrl(MavenArtifact artifact) {
        if (artifact.isSnapshot()) {
            return (String)this.snapshotUrlGenerator.apply((Object)artifact);
        }
        return (String)this.releaseUrlGenerator.apply((Object)artifact);
    }

    public String getLocalPath(MavenArtifact artifact) {
        return (String)LOCAL_REPO_PATH_GENERATOR.apply((Object)artifact);
    }

    public boolean isInstalledLocally(MavenArtifact artifact) {
        return new File(this.getLocalPath(artifact)).exists();
    }

    public String getLocalUrl(MavenArtifact artifact) {
        if (this.isInstalledLocally(artifact)) {
            return new File(this.getLocalPath(artifact)).toURI().toString();
        }
        if (artifact.isSnapshot()) {
            return (String)this.snapshotUrlGenerator.apply((Object)artifact);
        }
        return (String)this.releaseUrlGenerator.apply((Object)artifact);
    }

    public static String localUrl(MavenArtifact artifact) {
        return new MavenRetriever().getLocalUrl(artifact);
    }

    public static String hostedUrl(MavenArtifact artifact) {
        return new MavenRetriever().getHostedUrl(artifact);
    }
}

