/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.activemq;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.entity.messaging.activemq.ActiveMQDestinationImpl;
import org.apache.brooklyn.entity.messaging.activemq.ActiveMQQueue;
import org.apache.brooklyn.feed.jmx.JmxAttributePollConfig;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQQueueImpl
extends ActiveMQDestinationImpl
implements ActiveMQQueue {
    public static final Logger log = LoggerFactory.getLogger(ActiveMQQueue.class);

    @Override
    public void onManagementStarting() {
        super.onManagementStarting();
        this.sensors().set((AttributeSensor)QUEUE_NAME, (Object)this.getName());
    }

    @Override
    public String getQueueName() {
        return this.getName();
    }

    @Override
    public void create() {
        log.debug("{} adding queue {} to broker {}", new Object[]{this, this.getName(), this.jmxHelper.getAttribute(this.brokerMBeanName, "BrokerName")});
        this.jmxHelper.operation(this.brokerMBeanName, "addQueue", new Object[]{this.getName()});
        this.connectSensors();
    }

    @Override
    public void delete() {
        this.jmxHelper.operation(this.brokerMBeanName, "removeQueue", new Object[]{this.getName()});
        this.disconnectSensors();
    }

    @Override
    protected void connectSensors() {
        String queue = String.format("org.apache.activemq:type=Broker,brokerName=%s,destinationType=Queue,destinationName=%s", this.getBrokerName(), this.getName());
        this.jmxFeed = JmxFeed.builder().entity((Entity)this).helper(this.jmxHelper).pollAttribute(new JmxAttributePollConfig(QUEUE_DEPTH_MESSAGES).objectName(queue).attributeName("QueueSize")).build();
    }
}

