/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.google.common.annotations.Beta;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.relations.RelationshipType;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.relations.RelationshipTypes;
import org.apache.brooklyn.util.collections.MutableMap;

@Beta
public class EntityRelations<T extends BrooklynObject> {
    public static final RelationshipType<Entity, Entity> MANAGER_OF = RelationshipTypes.newRelationshipPair("manager", "managers", Entity.class, "manager_of", "managed child", "managed children", Entity.class, "managed_by");
    public static final RelationshipType<Entity, Entity> MANAGED_BY = MANAGER_OF.getInverseRelationshipType();
    public static final RelationshipType<Entity, Entity> GROUP_CONTAINS = RelationshipTypes.newRelationshipPair("group", "groups", Entity.class, "group_contains", "member", "members", Entity.class, "in_group");
    public static final RelationshipType<Entity, Entity> IN_GROUP = GROUP_CONTAINS.getInverseRelationshipType();
    public static final RelationshipType<Entity, Entity> HAS_TARGET = RelationshipTypes.newRelationshipPair("targetter", "targetters", Entity.class, "has_target", "target", "targets", Entity.class, "targetted_by");
    public static final RelationshipType<Entity, Entity> TARGETTED_BY = HAS_TARGET.getInverseRelationshipType();
    public static final RelationshipType<Entity, Entity> ACTIVE_PARENT_OF = RelationshipTypes.newRelationshipPair("parent", "parents", Entity.class, "parent_of_active", "active child", "active children", Entity.class, "active_child_of");
    public static final RelationshipType<Entity, Entity> ACTIVE_CHILD_OF = ACTIVE_PARENT_OF.getInverseRelationshipType();
    public static final RelationshipType<Entity, Policy> HAS_POLICY = RelationshipTypes.newRelationshipPair("entity", "entities", Entity.class, "has_policy", "policy", "policies", Policy.class, "policy_for");
    public static final RelationshipType<Policy, Entity> POLICY_FOR = HAS_POLICY.getInverseRelationshipType();
    private static Map<String, RelationshipType<? extends BrooklynObject, ? extends BrooklynObject>> KNOWN_RELATIONSHIPS = MutableMap.of();

    private static void addRelationship(RelationshipType<? extends BrooklynObject, ? extends BrooklynObject> r) {
        KNOWN_RELATIONSHIPS.put(r.getRelationshipTypeName(), r);
        if (r.getInverseRelationshipType() != null) {
            KNOWN_RELATIONSHIPS.put(r.getInverseRelationshipType().getRelationshipTypeName(), (RelationshipType<? extends BrooklynObject, ? extends BrooklynObject>)r.getInverseRelationshipType());
        }
    }

    @Beta
    public static RelationshipType<? extends BrooklynObject, ? extends BrooklynObject> lookup(ManagementContext mgmt, String relationshipTypeName) {
        if (relationshipTypeName == null) {
            return null;
        }
        RelationshipType<? extends BrooklynObject, ? extends BrooklynObject> result = KNOWN_RELATIONSHIPS.get(relationshipTypeName);
        if (result != null) {
            return result;
        }
        return RelationshipTypes.newRelationshipOneway("source", "sources", BrooklynObject.class, relationshipTypeName, "target", "targets", BrooklynObject.class);
    }

    public static <T extends BrooklynObject> Set<RelationshipType<? super T, ? extends BrooklynObject>> getRelationshipTypes(T source) {
        return ((BrooklynObjectInternal)source).relations().getLocalBackingStore().getRelationshipTypes();
    }

    public static <T extends BrooklynObject, U extends BrooklynObject> Set<U> getRelations(RelationshipType<? super T, U> relationship, T source) {
        return ((BrooklynObjectInternal)source).relations().getLocalBackingStore().getRelations(relationship);
    }

    public static <T extends BrooklynObject, U extends BrooklynObject> void add(T source, RelationshipType<? super T, ? super U> relationship, U target) {
        ((BrooklynObjectInternal)source).relations().getLocalBackingStore().add(relationship, target);
        if (relationship.getInverseRelationshipType() != null) {
            ((BrooklynObjectInternal)target).relations().getLocalBackingStore().add(relationship.getInverseRelationshipType(), source);
        }
    }

    public static <T extends BrooklynObject, U extends BrooklynObject> void remove(T source, RelationshipType<? super T, ? super U> relationship, U target) {
        ((BrooklynObjectInternal)source).relations().getLocalBackingStore().remove(relationship, target);
        if (relationship.getInverseRelationshipType() != null) {
            ((BrooklynObjectInternal)target).relations().getLocalBackingStore().remove(relationship.getInverseRelationshipType(), source);
        }
    }

    static {
        EntityRelations.addRelationship(MANAGER_OF);
        EntityRelations.addRelationship(GROUP_CONTAINS);
        EntityRelations.addRelationship(HAS_TARGET);
        EntityRelations.addRelationship(HAS_POLICY);
    }
}

