/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.EntityType;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.objs.BrooklynTypeSnapshot;
import org.apache.brooklyn.util.guava.Maybe;

public class EntityTypeSnapshot
extends BrooklynTypeSnapshot
implements EntityType {
    private static final long serialVersionUID = 4670930188951106009L;
    private final Map<String, Sensor<?>> sensors;
    private final Set<Effector<?>> effectors;
    private final Set<Sensor<?>> sensorsSet;

    EntityTypeSnapshot(String name, Map<String, ConfigKey<?>> configKeys, Map<String, Sensor<?>> sensors, Collection<Effector<?>> effectors) {
        super(name, configKeys);
        this.sensors = ImmutableMap.copyOf(sensors);
        this.effectors = ImmutableSet.copyOf(effectors);
        this.sensorsSet = ImmutableSet.copyOf(this.sensors.values());
    }

    public Set<Sensor<?>> getSensors() {
        return this.sensorsSet;
    }

    public Set<Effector<?>> getEffectors() {
        return this.effectors;
    }

    public Maybe<Effector<?>> getEffectorByName(String name) {
        if (name != null) {
            for (Effector<?> contender : this.effectors) {
                if (!name.equals(contender.getName())) continue;
                return Maybe.of(contender);
            }
        }
        return Maybe.absent((String)("No effector matching '" + name + "'"));
    }

    public Sensor<?> getSensor(String name) {
        return this.sensors.get(name);
    }

    public boolean hasSensor(String name) {
        return this.sensors.containsKey(name);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.sensors, this.effectors});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityTypeSnapshot)) {
            return false;
        }
        EntityTypeSnapshot o = (EntityTypeSnapshot)obj;
        return super.equals(obj) && Objects.equal(this.sensors, o.sensors) && Objects.equal(this.effectors, o.effectors);
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("sensors", this.sensors).add("effectors", this.effectors);
    }
}

