/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import com.google.common.base.Function;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ReleaseableLatch {
    public static final ReleaseableLatch NOP = new Factory.NopLatch();

    public void acquire(Entity var1);

    public void release(Entity var1);

    public static class Factory {
        public static ReleaseableLatch newMaxConcurrencyLatch(int maxThreadsNum) {
            return new MaxConcurrencyLatch(maxThreadsNum);
        }

        static {
            TypeCoercions.registerAdapter(ReleaseableLatch.class, Boolean.class, new Function<ReleaseableLatch, Boolean>(){

                public Boolean apply(ReleaseableLatch input) {
                    return Boolean.TRUE;
                }
            });
        }

        private static class MaxConcurrencyLatch
        implements ReleaseableLatch {
            private static final Logger LOG = LoggerFactory.getLogger(MaxConcurrencyLatch.class);
            private int permits;
            private final transient Semaphore sem;
            private final transient Set<Entity> ownerEntities = Collections.newSetFromMap(new ConcurrentHashMap());

            public MaxConcurrencyLatch(int permits) {
                this.permits = permits;
                this.sem = new Semaphore(permits);
            }

            @Override
            public void acquire(Entity caller) {
                if (!this.ownerEntities.add(caller)) {
                    LOG.warn("Entity {} acquiring permit multiple times with ~{} permits available and ~{} threads waiting in queue", new Object[]{caller, this.sem.availablePermits(), this.sem.getQueueLength()});
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Entity " + caller + " double-acquire call stack:", (Throwable)new RuntimeException("Call stack for permit double-acquire"));
                    }
                }
                try {
                    this.sem.acquire();
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }

            @Override
            public void release(Entity caller) {
                try {
                    this.sem.release();
                }
                finally {
                    this.ownerEntities.remove(caller);
                }
            }

            private Object readResolve() {
                return Factory.newMaxConcurrencyLatch(this.permits);
            }

            public String toString() {
                return this.getClass().getSimpleName() + "[permits=" + this.sem.availablePermits() + "/" + this.permits + "]";
            }
        }

        private static class NopLatch
        implements ReleaseableLatch {
            private NopLatch() {
            }

            @Override
            public void acquire(Entity caller) {
            }

            @Override
            public void release(Entity caller) {
            }
        }
    }
}

