/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Callables;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import groovy.lang.Closure;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.HasTaskChildren;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.core.BrooklynFeatureEnablement;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;
import org.apache.brooklyn.util.core.task.BasicTask;
import org.apache.brooklyn.util.core.task.CanSetName;
import org.apache.brooklyn.util.core.task.ExecutionListener;
import org.apache.brooklyn.util.core.task.ScheduledTask;
import org.apache.brooklyn.util.core.task.TaskInternal;
import org.apache.brooklyn.util.core.task.TaskInternalCancellableWithMode;
import org.apache.brooklyn.util.core.task.TaskScheduler;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicExecutionManager
implements ExecutionManager {
    private static final Logger log = LoggerFactory.getLogger(BasicExecutionManager.class);
    private static final boolean RENAME_THREADS = BrooklynFeatureEnablement.isEnabled("brooklyn.executionManager.renameThreads");
    private static final String JITTER_THREADS_MAX_DELAY_PROPERTY = "brooklyn.executionManager.jitterThreads.maxDelay";
    private boolean jitterThreads = BrooklynFeatureEnablement.isEnabled("brooklyn.executionManager.jitterThreads");
    private int jitterThreadsMaxDelay = Integer.getInteger("brooklyn.executionManager.jitterThreads.maxDelay", 200);
    private final ThreadFactory threadFactory;
    private final ThreadFactory daemonThreadFactory;
    private final ExecutorService runner;
    private final ScheduledExecutorService delayedRunner;
    private Map<Object, Set<Task<?>>> tasksByTag = new HashMap();
    private ConcurrentMap<String, Task<?>> tasksById = new ConcurrentHashMap();
    private ConcurrentMap<Object, TaskScheduler> schedulerByTag = new ConcurrentHashMap<Object, TaskScheduler>();
    private final AtomicLong totalTaskCount = new AtomicLong();
    private Set<String> incompleteTaskIds = Sets.newConcurrentHashSet();
    private final AtomicInteger activeTaskCount = new AtomicInteger();
    private final List<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private static final ThreadLocal<String> threadOriginalName = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            log.warn("No original name recorded for thread " + Thread.currentThread().getName() + "; task " + Tasks.current());
            return "brooklyn-thread-pool-" + Identifiers.makeRandomId((int)8);
        }
    };
    private static boolean loggedClosureDeprecatedInInvokeCallback;

    public static ThreadLocal<Task<?>> getPerThreadCurrentTask() {
        return PerThreadCurrentTaskHolder.perThreadCurrentTask;
    }

    public BasicExecutionManager(String contextid) {
        this.threadFactory = this.newThreadFactory(contextid);
        this.daemonThreadFactory = new ThreadFactoryBuilder().setThreadFactory(this.threadFactory).setDaemon(true).build();
        this.runner = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.daemonThreadFactory);
        this.delayedRunner = new ScheduledThreadPoolExecutor(1, this.daemonThreadFactory);
        if (this.jitterThreads) {
            log.info("Task startup jittering enabled with a maximum of " + this.jitterThreadsMaxDelay + " delay.");
        }
    }

    protected ThreadFactory newThreadFactory(String contextid) {
        return new ThreadFactoryBuilder().setNameFormat("brooklyn-execmanager-" + contextid + "-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtExceptionHandlerImplementation()).build();
    }

    public void shutdownNow() {
        this.shutdownNow(null);
    }

    @Beta
    public boolean shutdownNow(Duration howLongToWaitForTermination) {
        this.runner.shutdownNow();
        this.delayedRunner.shutdownNow();
        if (howLongToWaitForTermination != null) {
            CountdownTimer timer = howLongToWaitForTermination.countdownTimer();
            try {
                this.runner.awaitTermination(timer.getDurationRemaining().toMilliseconds(), TimeUnit.MILLISECONDS);
                if (timer.isLive()) {
                    this.delayedRunner.awaitTermination(timer.getDurationRemaining().toMilliseconds(), TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        return this.runner.isTerminated() && this.delayedRunner.isTerminated();
    }

    public void addListener(ExecutionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ExecutionListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTag(Object tag) {
        Set<Task<?>> tasks;
        Map<Object, Set<Task<?>>> map = this.tasksByTag;
        synchronized (map) {
            tasks = this.tasksByTag.remove(tag);
        }
        if (tasks != null) {
            for (Task task : tasks) {
                this.deleteTask(task);
            }
        }
    }

    public void deleteTask(Task<?> task) {
        boolean removed = this.deleteTaskNonRecursive(task);
        if (!removed) {
            return;
        }
        if (task instanceof HasTaskChildren) {
            ImmutableList children = ImmutableList.copyOf((Iterable)((HasTaskChildren)task).getChildren());
            for (Task child : children) {
                this.deleteTask(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteTaskNonRecursive(Task<?> task) {
        Set<Object> tags = TaskTags.getTagsFast((Task)Preconditions.checkNotNull(task, (Object)"task"));
        for (Object tag : tags) {
            Map<Object, Set<Task<?>>> map = this.tasksByTag;
            synchronized (map) {
                Set<Task<?>> tasks = this.tasksWithTagLiveOrNull(tag);
                if (tasks != null) {
                    tasks.remove(task);
                    if (tasks.isEmpty()) {
                        this.tasksByTag.remove(tag);
                    }
                }
            }
        }
        Task removed = (Task)this.tasksById.remove(task.getId());
        this.incompleteTaskIds.remove(task.getId());
        if (removed != null && removed.isSubmitted() && !removed.isDone(true)) {
            Entity context = BrooklynTaskTags.getContextEntity(removed);
            if (context != null && !Entities.isManaged(context)) {
                log.debug("Forgetting about active task on unmanagement of " + context + ": " + removed);
            } else {
                log.warn("Deleting submitted task before completion: " + removed + "; this task will continue to run in the background outwith " + this + ", but perhaps it should have been cancelled?");
            }
        }
        return removed != null;
    }

    public boolean isShutdown() {
        return this.runner.isShutdown();
    }

    public long getTotalTasksSubmitted() {
        return this.totalTaskCount.get();
    }

    public long getNumIncompleteTasks() {
        return this.incompleteTaskIds.size();
    }

    public long getNumActiveTasks() {
        return this.activeTaskCount.get();
    }

    public long getNumInMemoryTasks() {
        return this.tasksById.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Task<?>> tasksWithTagCreating(Object tag) {
        Preconditions.checkNotNull((Object)tag);
        Map<Object, Set<Task<?>>> map = this.tasksByTag;
        synchronized (map) {
            Set<Object> result = this.tasksWithTagLiveOrNull(tag);
            if (result == null) {
                result = Collections.synchronizedSet(new LinkedHashSet());
                this.tasksByTag.put(tag, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public Set<Task<?>> tasksWithTagLiveOrNull(Object tag) {
        Map<Object, Set<Task<?>>> map = this.tasksByTag;
        synchronized (map) {
            return this.tasksByTag.get(tag);
        }
    }

    public Task<?> getTask(String id) {
        return (Task)this.tasksById.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Task<?>> getAllTasks() {
        ConcurrentMap<String, Task<?>> concurrentMap = this.tasksById;
        synchronized (concurrentMap) {
            return MutableList.copyOf(this.tasksById.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Task<?>> getTasksWithTag(Object tag) {
        Set<Task<?>> result = this.tasksWithTagLiveOrNull(tag);
        if (result == null) {
            return Collections.emptySet();
        }
        Set<Task<?>> set = result;
        synchronized (set) {
            return Collections.unmodifiableSet(new LinkedHashSet(result));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Task<?>> getTasksWithAnyTag(Iterable<?> tags) {
        LinkedHashSet result = new LinkedHashSet();
        Iterator<?> ti = tags.iterator();
        while (ti.hasNext()) {
            Set<Task<?>> tasksForTag = this.tasksWithTagLiveOrNull(ti.next());
            if (tasksForTag == null) continue;
            Set<Task<?>> set = tasksForTag;
            synchronized (set) {
                result.addAll(tasksForTag);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<Task<?>> getTasksWithAllTags(Iterable<?> tags) {
        LinkedHashSet result = new LinkedHashSet();
        boolean first = true;
        for (Object tag : tags) {
            if (first) {
                first = false;
                result.addAll(this.getTasksWithTag(tag));
                continue;
            }
            result.retainAll(this.getTasksWithTag(tag));
        }
        return Collections.unmodifiableSet(result);
    }

    @Beta
    public Collection<Task<?>> allTasksLive() {
        return this.tasksById.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Object> getTaskTags() {
        Map<Object, Set<Task<?>>> map = this.tasksByTag;
        synchronized (map) {
            return Collections.unmodifiableSet(Sets.newLinkedHashSet(this.tasksByTag.keySet()));
        }
    }

    @Deprecated
    public Task<?> submit(Runnable r) {
        return this.submit(new LinkedHashMap(1), r);
    }

    public Task<?> submit(String displayName, Runnable r) {
        return this.submit((Map<?, ?>)MutableMap.of((Object)"displayName", (Object)displayName), r);
    }

    public Task<?> submit(Map<?, ?> flags, Runnable r) {
        return this.submit(flags, (TaskAdaptable)new BasicTask(flags, r));
    }

    @Deprecated
    public <T> Task<T> submit(Callable<T> c) {
        return this.submit(new LinkedHashMap(1), c);
    }

    public <T> Task<T> submit(String displayName, Callable<T> c) {
        return this.submit((Map<?, ?>)MutableMap.of((Object)"displayName", (Object)displayName), c);
    }

    public <T> Task<T> submit(Map<?, ?> flags, Callable<T> c) {
        return this.submit(flags, (TaskAdaptable<T>)new BasicTask<T>(flags, c));
    }

    public <T> Task<T> submit(TaskAdaptable<T> t) {
        return this.submit(new LinkedHashMap(1), t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Task<T> submit(Map<?, ?> flags, TaskAdaptable<T> task) {
        if (!(task instanceof Task)) {
            task = task.asTask();
        }
        Task task2 = task;
        synchronized (task2) {
            if (((TaskInternal)task).getInternalFuture() != null) {
                return task;
            }
            return this.submitNewTask(flags, task);
        }
    }

    public <T> Task<T> scheduleWith(Task<T> task) {
        return this.scheduleWith(Collections.emptyMap(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Task<T> scheduleWith(Map<?, ?> flags, Task<T> task) {
        Task<T> task2 = task;
        synchronized (task2) {
            if (((TaskInternal)task).getInternalFuture() != null) {
                return task;
            }
            return this.submitNewTask(flags, task);
        }
    }

    protected Task<?> submitNewScheduledTask(Map<?, ?> flags, ScheduledTask task) {
        this.beforeSubmitScheduledTaskAllIterations(flags, task);
        if (!this.submitSubsequentScheduledTask(flags, task)) {
            this.afterEndScheduledTaskAllIterations(flags, task, null);
        }
        return task;
    }

    private boolean submitSubsequentScheduledTask(Map<?, ?> flags, ScheduledTask task) {
        if (!task.isDone()) {
            task.internalFuture = this.delayedRunner.schedule(new ScheduledTaskCallable(task, flags), task.delay.toNanoseconds(), TimeUnit.NANOSECONDS);
            return true;
        }
        return false;
    }

    protected <T> Task<T> submitNewTask(Map<?, ?> flags, Task<T> task) {
        Future future;
        if (log.isTraceEnabled()) {
            log.trace("Submitting task {} ({}), with flags {}, and tags {}, job {}; caller {}", new Object[]{task.getId(), task, Sanitizer.sanitize(flags), BrooklynTaskTags.getTagsFast(task), task instanceof TaskInternal ? ((TaskInternal)task).getJob() : "<unavailable>", Tasks.current()});
            if (Tasks.current() == null && BrooklynTaskTags.isTransient(task)) {
                log.trace("Stack trace for unparented submission of transient " + task, new Throwable("trace only (not an error)"));
            }
        }
        if (task instanceof ScheduledTask) {
            return this.submitNewScheduledTask(flags, (ScheduledTask)task);
        }
        this.beforeSubmitAtomicTask(flags, task);
        if (((TaskInternal)task).getJob() == null) {
            throw new NullPointerException("Task " + task + " submitted with with null job: job must be supplied.");
        }
        SubmissionCallable job = new SubmissionCallable(flags, task);
        LinkedHashSet<TaskScheduler> schedulers = null;
        for (Object tago : BrooklynTaskTags.getTagsFast(task)) {
            TaskScheduler scheduler = this.getTaskSchedulerForTag(tago);
            if (scheduler == null) continue;
            if (schedulers == null) {
                schedulers = new LinkedHashSet<TaskScheduler>(2);
            }
            schedulers.add(scheduler);
        }
        if (schedulers != null && !schedulers.isEmpty()) {
            if (schedulers.size() > 1) {
                log.warn("multiple schedulers detected, using only the first, for " + task + ": " + schedulers);
            }
            future = ((TaskScheduler)schedulers.iterator().next()).submit(job);
        } else {
            future = this.runner.submit(job);
        }
        this.afterSubmitRecordFuture(task, future);
        return task;
    }

    protected <T> void afterSubmitRecordFuture(Task<T> task, Future<T> future) {
        CancellingListenableForwardingFutureForTask listenableFuture = new CancellingListenableForwardingFutureForTask(this, future, ((TaskInternal)task).getListeners(), task);
        ((TaskInternal)task).addListener(new SubmissionListenerToCallManagerListeners<T>(task, listenableFuture), this.runner);
        ((TaskInternal)task).initInternalFuture(listenableFuture);
    }

    protected void beforeSubmitScheduledTaskAllIterations(Map<?, ?> flags, Task<?> task) {
        this.internalBeforeSubmit(flags, task);
    }

    protected void beforeSubmitAtomicTask(Map<?, ?> flags, Task<?> task) {
        this.internalBeforeSubmit(flags, task);
    }

    protected void beforeSubmitInSameThreadTask(Map<?, ?> flags, Task<?> task) {
        this.internalBeforeSubmit(flags, task);
    }

    protected void internalBeforeSubmit(Map<?, ?> flags, Task<?> task) {
        Task currentTask;
        this.incompleteTaskIds.add(task.getId());
        if (task.getSubmittedByTaskId() == null && (currentTask = Tasks.current()) != null) {
            ((TaskInternal)task).setSubmittedByTask(Maybe.of((Supplier)new TaskLookup(this, currentTask)), currentTask.getId());
        }
        ((TaskInternal)task).setSubmitTimeUtc(System.currentTimeMillis());
        if (flags != null && flags.get("tag") != null) {
            ((TaskInternal)task).getMutableTags().add(flags.remove("tag"));
        }
        if (flags != null && flags.get("tags") != null) {
            ((TaskInternal)task).getMutableTags().addAll((Collection)flags.remove("tags"));
        }
        for (Object tag : BrooklynTaskTags.getTagsFast(task)) {
            this.tasksWithTagCreating(tag).add(task);
        }
        this.tasksById.put(task.getId(), task);
        this.totalTaskCount.incrementAndGet();
    }

    protected void beforeStartScheduledTaskSubmissionIteration(Map<?, ?> flags, Task<?> taskRepeatedlyScheduling, Task<?> taskIteration) {
        this.internalBeforeStart(flags, taskRepeatedlyScheduling, true);
    }

    protected void beforeStartAtomicTask(Map<?, ?> flags, Task<?> task) {
        this.internalBeforeStart(flags, task, true);
    }

    protected void beforeStartInSameThreadTask(Map<?, ?> flags, Task<?> task) {
        this.internalBeforeStart(flags, task, false);
    }

    protected void internalBeforeStart(Map<?, ?> flags, Task<?> task, boolean allowJitter) {
        int count = this.activeTaskCount.incrementAndGet();
        if (count % 1000 == 0) {
            log.warn("High number of active tasks: task #" + count + " is " + task);
        }
        if (log.isTraceEnabled()) {
            log.trace("" + this + " beforeStart, task: " + task + " running on thread " + Thread.currentThread().getName());
        }
        if (!task.isCancelled()) {
            Thread thread = Thread.currentThread();
            ((TaskInternal)task).setThread(thread);
            if (RENAME_THREADS) {
                threadOriginalName.set(thread.getName());
                String newThreadName = "brooklyn-" + CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, task.getDisplayName().replace(" ", "")) + "-" + task.getId().substring(0, 8);
                thread.setName(newThreadName);
            }
            PerThreadCurrentTaskHolder.perThreadCurrentTask.set(task);
            ((TaskInternal)task).setStartTimeUtc(System.currentTimeMillis());
        }
        if (allowJitter) {
            this.jitterThreadStart(task);
        }
        if (flags != null) {
            BasicExecutionManager.invokeCallback(flags.get("newTaskStartCallback"), task);
        }
    }

    private void jitterThreadStart(Task<?> task) {
        if (this.jitterThreads) {
            try {
                Thread.sleep(ThreadLocalRandom.current().nextInt(this.jitterThreadsMaxDelay));
            }
            catch (InterruptedException e) {
                log.warn("Task " + task + " got cancelled before starting because of jitter.");
                throw Exceptions.propagate((Throwable)e);
            }
        }
    }

    static Object invokeCallback(Object callable, Task<?> task) {
        if (callable instanceof Closure) {
            if (!loggedClosureDeprecatedInInvokeCallback) {
                log.warn("Use of groovy.lang.Closure is deprecated, in ExecutionManager.invokeCallback");
                loggedClosureDeprecatedInInvokeCallback = true;
            }
            return ((Closure)callable).call(task);
        }
        if (callable instanceof Callable) {
            try {
                return ((Callable)callable).call();
            }
            catch (Throwable t) {
                throw Exceptions.propagate((Throwable)t);
            }
        }
        if (callable instanceof Runnable) {
            ((Runnable)callable).run();
            return null;
        }
        if (callable instanceof Function) {
            return ((Function)callable).apply(task);
        }
        if (callable == null) {
            return null;
        }
        throw new IllegalArgumentException("Cannot invoke unexpected callback object " + callable + " of type " + callable.getClass() + " on " + task);
    }

    protected void afterEndScheduledTaskAllIterations(Map<?, ?> flags, Task<?> taskRepeatedlyScheduling, Throwable error) {
        this.internalAfterEnd(flags, taskRepeatedlyScheduling, false, true, error);
    }

    protected void afterEndScheduledTaskSubmissionIteration(Map<?, ?> flags, Task<?> taskRepeatedlyScheduling, Task<?> taskIteration, Throwable error) {
        this.internalAfterEnd(flags, taskRepeatedlyScheduling, true, false, error);
    }

    protected void afterEndAtomicTask(Map<?, ?> flags, Task<?> task, Throwable error) {
        this.internalAfterEnd(flags, task, true, true, error);
    }

    protected void afterEndInSameThreadTask(Map<?, ?> flags, Task<?> task, Throwable error) {
        this.internalAfterEnd(flags, task, true, true, error);
    }

    protected void afterEndForCancelBeforeStart(Map<?, ?> flags, Task<?> task, boolean calledFromCanceller) {
        if (calledFromCanceller && task.isBegun()) {
            return;
        }
        this.internalAfterEnd(flags, task, !calledFromCanceller, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalAfterEnd(Map<?, ?> flags, Task<?> task, boolean startedInThisThread, boolean isEndingAllIterations, Throwable error) {
        boolean taskWasSubmittedAndNotYetEnded;
        block43: {
            taskWasSubmittedAndNotYetEnded = true;
            try {
                if (log.isTraceEnabled()) {
                    log.trace(this + " afterEnd, task: " + task);
                }
                if (startedInThisThread) {
                    this.activeTaskCount.decrementAndGet();
                }
                if (isEndingAllIterations) {
                    taskWasSubmittedAndNotYetEnded = this.incompleteTaskIds.remove(task.getId());
                    if (flags != null && taskWasSubmittedAndNotYetEnded) {
                        BasicExecutionManager.invokeCallback(flags.get("newTaskEndCallback"), task);
                    }
                    ((TaskInternal)task).setEndTimeUtc(System.currentTimeMillis());
                }
                if (!startedInThisThread) break block43;
                PerThreadCurrentTaskHolder.perThreadCurrentTask.remove();
                if (RENAME_THREADS) {
                    Thread thread = task.getThread();
                    if (thread == null) {
                        log.warn("BasicTask.afterEnd invoked without corresponding beforeStart");
                    } else {
                        thread.setName(threadOriginalName.get());
                        threadOriginalName.remove();
                    }
                }
                ((TaskInternal)task).setThread(null);
            }
            catch (Throwable throwable) {
                try {
                    if (error != null) {
                        if (log.isDebugEnabled()) {
                            if (error instanceof InterruptedException || error instanceof RuntimeInterruptedException) {
                                log.debug("Detected interruption on task " + task + " (rethrowing)" + (Strings.isNonBlank((CharSequence)error.getMessage()) ? ": " + error.getMessage() : ""));
                            } else if (error instanceof NullPointerException || error instanceof IndexOutOfBoundsException || error instanceof ClassCastException) {
                                log.debug("Exception running task " + task + " (rethrowing): " + error, error);
                            } else {
                                log.debug("Exception running task " + task + " (rethrowing): " + error);
                            }
                            if (log.isTraceEnabled()) {
                                log.trace("Trace for exception running task " + task + " (rethrowing): " + error, error);
                            }
                        }
                        throw Exceptions.propagate((Throwable)error);
                    }
                }
                finally {
                    Task<?> task2 = task;
                    synchronized (task2) {
                        task.notifyAll();
                    }
                    if (isEndingAllIterations && taskWasSubmittedAndNotYetEnded) {
                        ((TaskInternal)task).runListeners();
                    }
                }
                throw throwable;
            }
        }
        try {
            if (error != null) {
                if (log.isDebugEnabled()) {
                    if (error instanceof InterruptedException || error instanceof RuntimeInterruptedException) {
                        log.debug("Detected interruption on task " + task + " (rethrowing)" + (Strings.isNonBlank((CharSequence)error.getMessage()) ? ": " + error.getMessage() : ""));
                    } else if (error instanceof NullPointerException || error instanceof IndexOutOfBoundsException || error instanceof ClassCastException) {
                        log.debug("Exception running task " + task + " (rethrowing): " + error, error);
                    } else {
                        log.debug("Exception running task " + task + " (rethrowing): " + error);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Trace for exception running task " + task + " (rethrowing): " + error, error);
                    }
                }
                throw Exceptions.propagate((Throwable)error);
            }
        }
        finally {
            Task<?> task3 = task;
            synchronized (task3) {
                task.notifyAll();
            }
            if (isEndingAllIterations && taskWasSubmittedAndNotYetEnded) {
                ((TaskInternal)task).runListeners();
            }
        }
    }

    public TaskScheduler getTaskSchedulerForTag(Object tag) {
        return (TaskScheduler)this.schedulerByTag.get(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskSchedulerForTag(Object tag, Class<? extends TaskScheduler> scheduler) {
        ConcurrentMap<Object, TaskScheduler> concurrentMap = this.schedulerByTag;
        synchronized (concurrentMap) {
            TaskScheduler old = this.getTaskSchedulerForTag(tag);
            if (old != null) {
                if (scheduler.isAssignableFrom(old.getClass())) {
                    return;
                }
                throw new IllegalStateException("Not allowed to set multiple TaskSchedulers on ExecutionManager tag (tag " + tag + ", has " + old + ", setting new " + scheduler + ")");
            }
            try {
                TaskScheduler schedulerI = scheduler.newInstance();
                if (schedulerI instanceof CanSetName) {
                    ((CanSetName)((Object)schedulerI)).setName("" + tag);
                }
                this.setTaskSchedulerForTag(tag, schedulerI);
            }
            catch (InstantiationException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskSchedulerForTag(Object tag, TaskScheduler scheduler) {
        ConcurrentMap<Object, TaskScheduler> concurrentMap = this.schedulerByTag;
        synchronized (concurrentMap) {
            scheduler.injectExecutor(this.runner);
            TaskScheduler old = this.schedulerByTag.put(tag, scheduler);
            if (old != null && old != scheduler) {
                throw new IllegalStateException("Not allowed to set multiple TaskSchedulers on ExecutionManager tag (tag " + tag + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearTaskSchedulerForTag(Object tag) {
        ConcurrentMap<Object, TaskScheduler> concurrentMap = this.schedulerByTag;
        synchronized (concurrentMap) {
            Object old = this.schedulerByTag.remove(tag);
            return old != null;
        }
    }

    @VisibleForTesting
    public ConcurrentMap<Object, TaskScheduler> getSchedulerByTag() {
        return this.schedulerByTag;
    }

    public void setJitterThreads(boolean jitterThreads) {
        this.jitterThreads = jitterThreads;
        if (jitterThreads) {
            log.info("Task startup jittering enabled with a maximum of " + this.jitterThreadsMaxDelay + " delay.");
        } else {
            log.info("Disabled task startup jittering");
        }
    }

    public void setJitterThreadsMaxDelay(int jitterThreadsMaxDelay) {
        this.jitterThreadsMaxDelay = jitterThreadsMaxDelay;
        log.info("Setting task startup jittering maximum delay to " + jitterThreadsMaxDelay);
    }

    private static class TaskLookup
    implements Supplier<Task<?>> {
        transient BasicExecutionManager mgr;
        String id;
        String displayName;

        public TaskLookup(BasicExecutionManager mgr, Task<?> t) {
            this.mgr = mgr;
            this.id = t.getId();
            if (mgr.getTask(this.id) == null) {
                log.warn("Created task lookup for task which is not registered: " + t);
            }
            this.displayName = t.getDisplayName();
        }

        public Task<?> get() {
            if (this.mgr == null) {
                return this.gone();
            }
            Task<?> result = this.mgr.getTask(this.id);
            if (result != null) {
                return result;
            }
            return this.gone();
        }

        private <T> Task<T> gone() {
            Task t = Tasks.builder().dynamic(false).displayName(this.displayName + " (placeholder for " + this.id + ")").description("Details of the original task have been forgotten.").body(Callables.returning(null)).build();
            ((BasicTask)t).cancelled = true;
            return t;
        }
    }

    private final class SubmissionListenerToCallManagerListeners<T>
    implements Runnable {
        private final Task<T> task;
        private final CancellingListenableForwardingFutureForTask<T> listenerSource;

        public SubmissionListenerToCallManagerListeners(Task<T> task, CancellingListenableForwardingFutureForTask<T> listenableFuture) {
            this.task = task;
            this.listenerSource = listenableFuture;
        }

        @Override
        public void run() {
            for (ExecutionListener listener : BasicExecutionManager.this.listeners) {
                try {
                    listener.onTaskDone(this.task);
                }
                catch (Exception e) {
                    log.warn("Error running execution listener " + listener + " of task " + this.task + " done", (Throwable)e);
                }
            }
            this.listenerSource.getListeners().execute();
        }
    }

    static final class CancellingListenableForwardingFutureForTask<T>
    extends ForwardingFuture.SimpleForwardingFuture<T>
    implements ListenableFuture<T>,
    TaskInternalCancellableWithMode {
        private final Task<T> task;
        private BasicExecutionManager execMgmt;
        private final ExecutionList listeners;

        private CancellingListenableForwardingFutureForTask(BasicExecutionManager execMgmt, Future<T> delegate, ExecutionList list, Task<T> task) {
            super(delegate);
            this.listeners = list;
            this.execMgmt = execMgmt;
            this.task = task;
        }

        public final boolean cancel(boolean mayInterrupt) {
            return this.cancel(TaskInternal.TaskCancellationMode.INTERRUPT_TASK_AND_DEPENDENT_SUBMITTED_TASKS);
        }

        public void addListener(Runnable listener, Executor executor) {
            this.listeners.add(listener, executor);
        }

        public ExecutionList getListeners() {
            return this.listeners;
        }

        @Override
        public boolean cancel(TaskInternal.TaskCancellationMode mode) {
            boolean result = false;
            if (log.isTraceEnabled()) {
                log.trace("CLFFT cancelling " + this.task + " mode " + mode);
            }
            if (!this.task.isCancelled()) {
                result |= ((TaskInternal)this.task).cancel(mode);
            }
            result |= this.delegate().cancel(mode.isAllowedToInterruptTask());
            if (mode.isAllowedToInterruptDependentSubmittedTasks()) {
                int subtasksFound = 0;
                int subtasksReallyCancelled = 0;
                if (this.task instanceof HasTaskChildren) {
                    MutableList childrenReversed = MutableList.copyOf((Iterable)((HasTaskChildren)this.task).getChildren());
                    Collections.reverse(childrenReversed);
                    for (Task child : childrenReversed) {
                        if (log.isTraceEnabled()) {
                            log.trace("Cancelling " + child + " on recursive cancellation of " + this.task);
                        }
                        ++subtasksFound;
                        if (!((TaskInternal)child).cancel(mode)) continue;
                        result = true;
                        ++subtasksReallyCancelled;
                    }
                }
                for (Task<?> t : this.execMgmt.getAllTasks()) {
                    if (!this.task.equals((Object)t.getSubmittedByTask()) || !mode.isAllowedToInterruptAllSubmittedTasks() && !BrooklynTaskTags.isTransient(t)) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("Cancelling " + t + " on recursive cancellation of " + this.task);
                    }
                    ++subtasksFound;
                    if (!((TaskInternal)t).cancel(mode)) continue;
                    result = true;
                    ++subtasksReallyCancelled;
                }
                if (log.isTraceEnabled()) {
                    log.trace("On cancel of " + this.task + ", applicable subtask count " + subtasksFound + ", of which " + subtasksReallyCancelled + " were actively cancelled");
                }
            }
            this.execMgmt.afterEndForCancelBeforeStart(null, this.task, true);
            return result;
        }
    }

    private final class SubmissionCallable<T>
    implements Callable<T> {
        private final Map<?, ?> flags;
        private final Task<T> task;

        private SubmissionCallable(Map<?, ?> flags, Task<T> task) {
            this.flags = flags;
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() {
            T result = null;
            Throwable error = null;
            try {
                BasicExecutionManager.this.beforeStartAtomicTask(this.flags, this.task);
                if (this.task.isCancelled()) {
                    BasicExecutionManager.this.afterEndForCancelBeforeStart(this.flags, this.task, false);
                    throw new CancellationException();
                }
                result = ((TaskInternal)this.task).getJob().call();
            }
            catch (Throwable e) {
                error = e;
            }
            finally {
                BasicExecutionManager.this.afterEndAtomicTask(this.flags, this.task, error);
            }
            return result;
        }

        public String toString() {
            return "BEM.call(" + this.task + "," + this.flags + ")";
        }
    }

    protected class ScheduledTaskCallable
    implements Callable<Object> {
        public ScheduledTask task;
        public Map<?, ?> flags;

        public ScheduledTaskCallable(ScheduledTask task, Map<?, ?> flags) {
            this.task = task;
            this.flags = flags;
        }

        @Override
        public Object call() {
            if (this.task.startTimeUtc == -1L) {
                this.task.startTimeUtc = System.currentTimeMillis();
            }
            TaskInternal taskScheduled = null;
            Exception error = null;
            try {
                taskScheduled = (TaskInternal)this.task.newTask();
                taskScheduled.setSubmittedByTask(this.task);
                BasicExecutionManager.this.beforeStartScheduledTaskSubmissionIteration(this.flags, this.task, taskScheduled);
                final Callable oldJob = taskScheduled.getJob();
                final TaskInternal taskScheduledF = taskScheduled;
                taskScheduled.setJob(new Callable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object call() {
                        Object v;
                        if (ScheduledTaskCallable.this.task.isCancelled()) {
                            BasicExecutionManager.this.afterEndScheduledTaskAllIterations(ScheduledTaskCallable.this.flags, ScheduledTaskCallable.this.task, new CancellationException("cancel detected"));
                            throw new CancellationException("cancel detected");
                        }
                        Exception lastError = null;
                        boolean shouldResubmit = true;
                        ScheduledTaskCallable.this.task.recentRun = taskScheduledF;
                        try {
                            Object result;
                            ScheduledTask scheduledTask = ScheduledTaskCallable.this.task;
                            synchronized (scheduledTask) {
                                ScheduledTaskCallable.this.task.notifyAll();
                            }
                            try {
                                result = oldJob.call();
                                ScheduledTaskCallable.this.task.lastThrownType = null;
                            }
                            catch (Exception e) {
                                lastError = e;
                                shouldResubmit = ScheduledTaskCallable.this.shouldResubmitOnException(oldJob, e);
                                throw Exceptions.propagate((Throwable)e);
                            }
                            v = result;
                        }
                        catch (Throwable throwable) {
                            if (!shouldResubmit || !ScheduledTaskCallable.this.resubmit()) {
                                BasicExecutionManager.this.afterEndScheduledTaskAllIterations(ScheduledTaskCallable.this.flags, ScheduledTaskCallable.this.task, lastError);
                            }
                            throw throwable;
                        }
                        if (!shouldResubmit || !ScheduledTaskCallable.this.resubmit()) {
                            BasicExecutionManager.this.afterEndScheduledTaskAllIterations(ScheduledTaskCallable.this.flags, ScheduledTaskCallable.this.task, lastError);
                        }
                        return v;
                    }
                });
                this.task.nextRun = taskScheduled;
                BasicExecutionContext ec = BasicExecutionContext.getCurrentExecutionContext();
                if (ec != null) {
                    Task task = ec.submit(taskScheduled);
                    return task;
                }
                Task task = BasicExecutionManager.this.submit(taskScheduled);
                return task;
            }
            catch (Exception e) {
                error = e;
                throw Exceptions.propagate((Throwable)e);
            }
            finally {
                BasicExecutionManager.this.afterEndScheduledTaskSubmissionIteration(this.flags, this.task, taskScheduled, error);
            }
        }

        private boolean resubmit() {
            ++this.task.runCount;
            if (this.task.period != null && !this.task.isCancelled()) {
                this.task.delay = this.task.period;
                return BasicExecutionManager.this.submitSubsequentScheduledTask(this.flags, this.task);
            }
            return false;
        }

        private boolean shouldResubmitOnException(Callable<?> oldJob, Exception e) {
            String message = "Error executing " + oldJob + " (scheduled job of " + this.task + " - " + this.task.getDescription() + ")";
            if (Tasks.isInterrupted()) {
                log.debug(message + "; cancelling scheduled execution: " + e);
                return false;
            }
            if (this.task.cancelOnException) {
                log.warn(message + "; cancelling scheduled execution.", (Throwable)e);
                return false;
            }
            message = message + "; resubmitting task and throwing: " + e;
            if (!e.getClass().equals(this.task.lastThrownType)) {
                this.task.lastThrownType = e.getClass();
                message = message + " (logging subsequent exceptions at trace)";
                log.debug(message);
            } else {
                message = message + " (repeat exception)";
                log.trace(message);
            }
            return true;
        }

        public String toString() {
            return "ScheduledTaskCallable[" + this.task + "," + this.flags + "]";
        }
    }

    private static final class UncaughtExceptionHandlerImplementation
    implements Thread.UncaughtExceptionHandler {
        private UncaughtExceptionHandlerImplementation() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("Uncaught exception in thread " + t.getName(), e);
        }
    }

    private static class PerThreadCurrentTaskHolder {
        public static final ThreadLocal<Task<?>> perThreadCurrentTask = new ThreadLocal();

        private PerThreadCurrentTaskHolder() {
        }
    }
}

