/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;

public class KeyPairPredicates {
    public static Predicate<KeyPair> nameMatches(final Predicate<String> name) {
        Preconditions.checkNotNull(name, (Object)"name must be defined");
        return new Predicate<KeyPair>(){

            public boolean apply(KeyPair ext) {
                return name.apply((Object)ext.getName());
            }

            public String toString() {
                return "nameMatches(" + name + ")";
            }
        };
    }

    public static Predicate<KeyPair> nameEquals(final String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name must be defined");
        return new Predicate<KeyPair>(){

            public boolean apply(KeyPair ext) {
                return ext.getName() != null && ext.getName().equals(name);
            }

            public String toString() {
                return "nameEquals(" + name + ")";
            }
        };
    }
}

