/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.enricher;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import groovy.lang.Closure;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.enricher.stock.AbstractTypeTransformingEnricher;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.groovy.GroovyJavaMethods;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Time-weighted Delta", description="Converts an absolute sensor into a delta sensor (i.e. the diff between the current and previous value), presented as a units/timeUnit based on the event timing.")
@Beta
public class TimeWeightedDeltaEnricher<T extends Number>
extends AbstractTypeTransformingEnricher<T, Double> {
    private static final Logger LOG = LoggerFactory.getLogger(TimeWeightedDeltaEnricher.class);
    Number lastValue;
    long lastTime = -1L;
    @SetFromFlag
    int unitMillis;
    @SetFromFlag
    Function<Double, Double> postProcessor;

    @Deprecated
    public static <T extends Number> TimeWeightedDeltaEnricher<T> getPerSecondDeltaEnricher(Entity producer, Sensor<T> source, Sensor<Double> target) {
        return new TimeWeightedDeltaEnricher<T>(producer, source, target, 1000);
    }

    public TimeWeightedDeltaEnricher() {
    }

    @Deprecated
    public TimeWeightedDeltaEnricher(Entity producer, Sensor<T> source, Sensor<Double> target, int unitMillis) {
        this(producer, source, target, unitMillis, (Function<Double, Double>)Functions.identity());
    }

    @Deprecated
    public TimeWeightedDeltaEnricher(Entity producer, Sensor<T> source, Sensor<Double> target, int unitMillis, Closure<Double> postProcessor) {
        this(producer, source, target, unitMillis, (Function<Double, Double>)GroovyJavaMethods.functionFromClosure(postProcessor));
    }

    @Deprecated
    public TimeWeightedDeltaEnricher(Entity producer, Sensor<T> source, Sensor<Double> target, int unitMillis, Function<Double, Double> postProcessor) {
        super(producer, source, target);
        this.unitMillis = unitMillis;
        this.postProcessor = postProcessor;
        if (source != null && target != null) {
            this.uniqueTag = JavaClassNames.simpleClassName(((Object)((Object)this)).getClass()) + ":" + source.getName() + "/" + Duration.millis((Number)unitMillis) + "->" + target.getName();
        }
    }

    public void init() {
        super.init();
        if (this.uniqueTag == null && this.source != null && this.target != null) {
            this.uniqueTag = JavaClassNames.simpleClassName(((Object)((Object)this)).getClass()) + ":" + this.source.getName() + "/" + Duration.millis((Number)this.unitMillis) + "->" + this.target.getName();
        }
    }

    public void onEvent(SensorEvent<T> event) {
        this.onEvent(event, event.getTimestamp());
    }

    public void onEvent(SensorEvent<T> event, long eventTime) {
        Number current = (Number)event.getValue();
        if (current == null) {
            double deltaPostProcessed = (Double)this.getPostProcessor().apply((Object)0.0);
            this.entity.sensors().set((AttributeSensor)this.target, (Object)deltaPostProcessed);
            if (LOG.isTraceEnabled()) {
                LOG.trace("set {} to {}, {} -> {} at {}", new Object[]{this, deltaPostProcessed, this.lastValue, current, eventTime});
            }
            return;
        }
        if (eventTime > 0L && eventTime > this.lastTime) {
            if (this.lastValue == null || this.lastTime <= 0L) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} received event but no last value so will not emit, null -> {} at {}", new Object[]{this, current, eventTime});
                }
            } else {
                double duration;
                double d = duration = this.lastTime < 0L ? (double)this.unitMillis : (double)(eventTime - this.lastTime);
                if (eventTime == this.lastTime) {
                    duration = 0.1;
                }
                double delta = (current.doubleValue() - this.lastValue.doubleValue()) / (duration / (double)this.unitMillis);
                double deltaPostProcessed = (Double)this.getPostProcessor().apply((Object)delta);
                this.entity.sensors().set((AttributeSensor)this.target, (Object)deltaPostProcessed);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("set {} to {}, {} -> {} at {}", new Object[]{this, deltaPostProcessed, this.lastValue, current, eventTime});
                }
            }
            this.lastValue = current;
            this.lastTime = eventTime;
        } else if (this.lastTime < 0L) {
            this.lastValue = current;
            this.lastTime = -1L;
        }
    }

    private Function<Double, Double> getPostProcessor() {
        return this.postProcessor != null ? this.postProcessor : Functions.identity();
    }
}

