/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.aws;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.brooklyn.location.jclouds.BasicJcloudsLocationCustomizer;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.jclouds.aws.ec2.compute.AWSEC2ComputeService;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.TemplateBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEbsVolumeCustomizer
extends BasicJcloudsLocationCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEbsVolumeCustomizer.class);
    protected String availabilityZone;
    protected String ec2DeviceName;
    protected String osDeviceName;
    protected String mountPoint;
    protected String owner;
    protected Integer permissions;

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public void setEc2DeviceName(String ec2DeviceName) {
        this.ec2DeviceName = ec2DeviceName;
    }

    public void setOsDeviceName(String osDeviceName) {
        this.osDeviceName = osDeviceName;
    }

    public void setMountPoint(String mountPoint) {
        this.mountPoint = mountPoint;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setPermissions(Integer permissions) {
        this.permissions = permissions;
    }

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, TemplateBuilder templateBuilder) {
        if (computeService instanceof AWSEC2ComputeService) {
            templateBuilder.locationId(this.availabilityZone);
        } else {
            LOG.debug("Skipping configuration of non-EC2 ComputeService {}", (Object)computeService);
        }
    }

    protected void createFilesystem(JcloudsSshMachineLocation machine, String filesystemType) {
        machine.execCommands("Creating filesystem on EBS volume", (List)ImmutableList.of((Object)("sudo mkfs." + filesystemType + " " + this.osDeviceName)));
    }

    protected void mountFilesystem(JcloudsSshMachineLocation machine) {
        ImmutableList.Builder commands = ImmutableList.builder().add((Object[])new String[]{"sudo mkdir -m 000 " + this.mountPoint, "sudo echo \"" + this.osDeviceName + " " + this.mountPoint + " auto noatime 0 0\" | sudo tee -a /etc/fstab", "sudo mount " + this.mountPoint, "sudo chown " + (this.owner == null ? machine.getUser() : this.owner) + " " + this.mountPoint});
        if (this.permissions != null) {
            commands.add((Object)("sudo chmod " + this.permissions + " " + this.mountPoint));
        }
        machine.execCommands("Mounting EBS volume", (List)commands.build());
    }
}

