/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddEffector;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.mgmt.internal.EffectorUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyEffector
extends AddEffector {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyEffector.class);
    public static final ConfigKey<Entity> TARGET_ENTITY = ConfigKeys.newConfigKey(Entity.class, "targetEntity", "The proxy target");
    public static final ConfigKey<String> TARGET_EFFECTOR_NAME = ConfigKeys.newStringConfigKey("targetEffector", "The effector to invoke on the target entity");

    public ProxyEffector(ConfigBag params) {
        super(ProxyEffector.newEffectorBuilder(params).build());
    }

    public ProxyEffector(Map<?, ?> params) {
        this(ConfigBag.newInstance(params));
    }

    public static Effectors.EffectorBuilder<Object> newEffectorBuilder(ConfigBag params) {
        Effectors.EffectorBuilder<Object> eff = AddEffector.newEffectorBuilder(Object.class, params);
        eff.impl(new Body(eff.buildAbstract(), params));
        return eff;
    }

    protected static class Body
    extends EffectorBody<Object> {
        private final Object target;
        private final String effectorName;

        public Body(Effector<?> eff, ConfigBag params) {
            this.target = Preconditions.checkNotNull((Object)params.getAllConfigRaw().get(TARGET_ENTITY.getName()), (Object)"Target entity must be supplied when defining this effector");
            this.effectorName = (String)Preconditions.checkNotNull((Object)params.get(TARGET_EFFECTOR_NAME), (Object)"Target effector name must be supplied when defining this effector");
        }

        @Override
        public Object call(ConfigBag params) {
            Entity target = (Entity)this.resolveTarget().get();
            return this.invokeEffectorNamed(target, this.effectorName, params);
        }

        private Maybe<Entity> resolveTarget() {
            return Tasks.resolving(this.target, Entity.class).context((Entity)this.entity()).getMaybe();
        }

        private Object invokeEffectorNamed(Entity target, String effectorName, ConfigBag params) {
            LOG.debug("{} forwarding effector invocation on {} to entity={}, effector={}, parameters={}", new Object[]{this, this.entity(), target, effectorName, params});
            Effector effector = (Effector)EffectorUtils.findEffectorDeclared(target, effectorName).get();
            return target.invoke(effector, params.getAllConfig()).getUnchecked();
        }
    }
}

