/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.relations;

import com.google.common.base.Objects;
import org.apache.brooklyn.api.relations.RelationshipType;

public class RelationshipTypes {
    public static <SourceType, TargetType> RelationshipType<SourceType, TargetType> newRelationshipPair(String sourceName, String sourceNamePlural, Class<SourceType> sourceType, String toTargetRelationshipTypeName, String targetName, String targetNamePlural, Class<TargetType> targetType, String toSourceRelationshipTypeName) {
        BasicRelationshipWithInverse r1 = new BasicRelationshipWithInverse(toTargetRelationshipTypeName, sourceName, sourceNamePlural, targetType);
        BasicRelationshipWithInverse r2 = new BasicRelationshipWithInverse(toSourceRelationshipTypeName, targetName, targetNamePlural, sourceType);
        r1.inverseRelationshipType = r2;
        r2.inverseRelationshipType = r1;
        return r1;
    }

    public static <SourceType, TargetType> RelationshipType<SourceType, TargetType> newRelationshipOneway(String sourceName, String sourceNamePlural, Class<SourceType> sourceType, String toTargetRelationshipTypeName, String targetName, String targetNamePlural, Class<TargetType> targetType) {
        return new BasicRelationshipOneWay(sourceName, sourceNamePlural, sourceType, toTargetRelationshipTypeName, targetName, targetNamePlural, targetType);
    }

    private static class BasicRelationshipOneWay<SourceType, TargetType>
    extends AbstractBasicRelationship<SourceType, TargetType> {
        private final String targetName;
        private final String targetNamePlural;
        private final Class<SourceType> sourceType;

        private BasicRelationshipOneWay(String sourceName, String sourceNamePlural, Class<SourceType> sourceType, String toTargetRelationshipTypeName, String targetName, String targetNamePlural, Class<TargetType> targetType) {
            super(toTargetRelationshipTypeName, sourceName, sourceNamePlural, targetType);
            this.targetName = targetName;
            this.targetNamePlural = targetNamePlural;
            this.sourceType = sourceType;
        }

        public Class<SourceType> getSourceType() {
            return this.sourceType;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public String getTargetNamePlural() {
            return this.targetNamePlural;
        }

        public RelationshipType<TargetType, SourceType> getInverseRelationshipType() {
            return null;
        }
    }

    private static class BasicRelationshipWithInverse<SourceType, TargetType>
    extends AbstractBasicRelationship<SourceType, TargetType> {
        private BasicRelationshipWithInverse<TargetType, SourceType> inverseRelationshipType;

        private BasicRelationshipWithInverse(String relationshipTypeName, String sourceName, String sourceNamePlural, Class<TargetType> targetType) {
            super(relationshipTypeName, sourceName, sourceNamePlural, targetType);
        }

        public RelationshipType<TargetType, SourceType> getInverseRelationshipType() {
            return this.inverseRelationshipType;
        }

        public Class<SourceType> getSourceType() {
            if (this.getInverseRelationshipType() == null) {
                return null;
            }
            return this.getInverseRelationshipType().getTargetType();
        }

        public String getTargetName() {
            if (this.getInverseRelationshipType() == null) {
                return null;
            }
            return this.getInverseRelationshipType().getSourceName();
        }

        public String getTargetNamePlural() {
            if (this.getInverseRelationshipType() == null) {
                return null;
            }
            return this.getInverseRelationshipType().getSourceNamePlural();
        }
    }

    private static abstract class AbstractBasicRelationship<SourceType, TargetType>
    implements RelationshipType<SourceType, TargetType> {
        private final String relationshipTypeName;
        private final String sourceName;
        private final String sourceNamePlural;
        private final Class<TargetType> targetType;

        private AbstractBasicRelationship(String relationshipTypeName, String sourceName, String sourceNamePlural, Class<TargetType> targetType) {
            this.relationshipTypeName = relationshipTypeName;
            this.sourceName = sourceName;
            this.sourceNamePlural = sourceNamePlural;
            this.targetType = targetType;
        }

        public String getRelationshipTypeName() {
            return this.relationshipTypeName;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public String getSourceNamePlural() {
            return this.sourceNamePlural;
        }

        public Class<TargetType> getTargetType() {
            return this.targetType;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AbstractBasicRelationship)) {
                return false;
            }
            AbstractBasicRelationship other = (AbstractBasicRelationship)obj;
            if (!Objects.equal((Object)this.relationshipTypeName, (Object)other.relationshipTypeName)) {
                return false;
            }
            if (!Objects.equal((Object)this.getSourceType(), (Object)other.getSourceType())) {
                return false;
            }
            if (!Objects.equal(this.targetType, other.targetType)) {
                return false;
            }
            if (this.getInverseRelationshipType() == null) {
                if (other.getInverseRelationshipType() != null) {
                    return false;
                }
            } else {
                if (other.getInverseRelationshipType() == null) {
                    return false;
                }
                if (!Objects.equal((Object)this.getInverseRelationshipType().getRelationshipTypeName(), (Object)other.getInverseRelationshipType().getRelationshipTypeName())) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.relationshipTypeName, this.getSourceType(), this.targetType, this.getInverseRelationshipType() != null ? this.getInverseRelationshipType().getRelationshipTypeName() : null});
        }

        public String toString() {
            return this.relationshipTypeName;
        }
    }
}

