/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.core.sensor.BasicSensorEvent;
import org.apache.brooklyn.util.guava.TypeTokens;

public class BasicSensor<T>
implements Sensor<T> {
    private static final long serialVersionUID = -3762018534086101323L;
    private static final Splitter dots = Splitter.on((char)'.');
    private TypeToken<T> typeToken;
    private Class<? super T> type;
    private String name;
    private String description;
    private transient List<String> nameParts;

    public BasicSensor() {
    }

    public BasicSensor(Class<T> type, String name) {
        this(type, null, name, name);
    }

    public BasicSensor(Class<T> type, String name, String description) {
        this(type, null, name, description);
    }

    public BasicSensor(TypeToken<T> typeToken, String name, String description) {
        this(TypeTokens.getRawTypeIfRaw(typeToken), TypeTokens.getTypeTokenIfNotRaw((TypeToken)((TypeToken)Preconditions.checkNotNull(typeToken, (Object)"typeToken"))), (String)Preconditions.checkNotNull((Object)name, (Object)"name"), description);
    }

    protected BasicSensor(Class<T> type, TypeToken<T> typeToken, String name, String description) {
        TypeTokens.checkCompatibleOneNonNull(type, typeToken);
        this.typeToken = typeToken;
        this.type = type;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.description = description;
    }

    public TypeToken<T> getTypeToken() {
        return TypeTokens.getTypeToken(this.typeToken, this.type);
    }

    public Class<? super T> getType() {
        return TypeTokens.getRawType(this.typeToken, this.type);
    }

    public String getTypeName() {
        return this.getType().getName();
    }

    public String getName() {
        return this.name;
    }

    public synchronized List<String> getNameParts() {
        if (this.nameParts == null) {
            this.nameParts = ImmutableList.copyOf((Iterable)dots.split((CharSequence)this.name));
        }
        return this.nameParts;
    }

    public String getDescription() {
        return this.description;
    }

    public SensorEvent<T> newEvent(Entity producer, T value) {
        return new BasicSensorEvent<T>(this, producer, value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getTypeName(), this.name, this.description});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BasicSensor)) {
            return false;
        }
        BasicSensor o = (BasicSensor)other;
        return Objects.equal((Object)this.getTypeName(), (Object)o.getTypeName()) && Objects.equal((Object)this.name, (Object)o.name) && Objects.equal((Object)this.description, (Object)o.description);
    }

    public String toString() {
        return String.format("Sensor: %s (%s)", this.name, this.getTypeName());
    }
}

