/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.internal.ssh.cli;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.internal.ssh.ShellAbstractTool;
import org.apache.brooklyn.util.core.internal.ssh.SshAbstractTool;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.core.internal.ssh.process.ProcessTool;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshCliTool
extends SshAbstractTool
implements SshTool {
    private static final Logger LOG = LoggerFactory.getLogger(SshCliTool.class);
    public static final ConfigKey<String> PROP_SSH_EXECUTABLE = ConfigKeys.newStringConfigKey("sshExecutable", "command to execute for ssh (defaults to \"ssh\", but could be overridden to sshg3 for Tectia for example)", "ssh");
    public static final ConfigKey<String> PROP_SSH_FLAGS = ConfigKeys.newStringConfigKey("sshFlags", "flags to pass to ssh, as a space separated list", "");
    public static final ConfigKey<String> PROP_SCP_EXECUTABLE = ConfigKeys.newStringConfigKey("scpExecutable", "command to execute for scp (defaults to \"scp\", but could be overridden to scpg3 for Tectia for example)", "scp");
    private final String sshExecutable;
    private final String sshFlags;
    private final String scpExecutable;

    public static Builder<SshCliTool, ?> builder() {
        return new ConcreteBuilder();
    }

    public SshCliTool(Map<String, ?> map) {
        this((Builder<?, ?>)SshCliTool.builder().from((Map)map));
    }

    private SshCliTool(Builder<?, ?> builder) {
        super(builder);
        this.sshExecutable = (String)Preconditions.checkNotNull((Object)((Builder)builder).sshExecutable);
        this.sshFlags = (String)Preconditions.checkNotNull((Object)((Builder)builder).sshFlags);
        this.scpExecutable = (String)Preconditions.checkNotNull((Object)((Builder)builder).scpExecutable);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created SshCliTool {} ({})", (Object)this, (Object)System.identityHashCode(this));
        }
    }

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Disconnecting SshCliTool {} ({}) - no-op", (Object)this, (Object)System.identityHashCode(this));
        }
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public int copyToServer(Map<String, ?> props, byte[] contents, String pathAndFileOnRemoteServer) {
        return this.copyTempFileToServer(props, this.writeTempFile(contents), pathAndFileOnRemoteServer);
    }

    @Override
    public int copyToServer(Map<String, ?> props, InputStream contents, String pathAndFileOnRemoteServer) {
        return this.copyTempFileToServer(props, this.writeTempFile(contents), pathAndFileOnRemoteServer);
    }

    @Override
    public int copyToServer(Map<String, ?> props, File f, String pathAndFileOnRemoteServer) {
        if (SshCliTool.hasVal(props, PROP_LAST_MODIFICATION_DATE).booleanValue()) {
            LOG.warn("Unsupported ssh feature, setting lastModificationDate for {}:{}", (Object)this, (Object)pathAndFileOnRemoteServer);
        }
        if (SshCliTool.hasVal(props, PROP_LAST_ACCESS_DATE).booleanValue()) {
            LOG.warn("Unsupported ssh feature, setting lastAccessDate for {}:{}", (Object)this, (Object)pathAndFileOnRemoteServer);
        }
        String permissions = (String)SshCliTool.getOptionalVal(props, PROP_PERMISSIONS);
        int uid = (Integer)SshCliTool.getOptionalVal(props, PROP_OWNER_UID);
        int result = this.scpToServer(props, f, pathAndFileOnRemoteServer);
        if (result == 0) {
            result = this.chmodOnServer(props, permissions, pathAndFileOnRemoteServer);
            if (result == 0) {
                if (uid != -1 && (result = this.chownOnServer(props, uid, pathAndFileOnRemoteServer)) != 0) {
                    LOG.warn("Error setting file owner to {}, after copying file {} to {}:{}; exit code {}", new Object[]{uid, pathAndFileOnRemoteServer, this, f, result});
                }
            } else {
                LOG.warn("Error setting file permissions to {}, after copying file {} to {}:{}; exit code {}", new Object[]{permissions, pathAndFileOnRemoteServer, this, f, result});
            }
        } else {
            LOG.warn("Error copying file {} to {}:{}; exit code {}", new Object[]{pathAndFileOnRemoteServer, this, f, result});
        }
        return result;
    }

    private int chownOnServer(Map<String, ?> props, int uid, String remote) {
        return this.sshExec(props, "chown " + uid + " " + remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyTempFileToServer(Map<String, ?> props, File f, String pathAndFileOnRemoteServer) {
        try {
            int n = this.copyToServer(props, f, pathAndFileOnRemoteServer);
            return n;
        }
        finally {
            f.delete();
        }
    }

    @Override
    public int copyFromServer(Map<String, ?> props, String pathAndFileOnRemoteServer, File localFile) {
        return this.scpFromServer(props, pathAndFileOnRemoteServer, localFile);
    }

    @Override
    public int execScript(Map<String, ?> props, final List<String> commands, final Map<String, ?> env) {
        return new ShellAbstractTool.ToolAbstractExecScript(props){

            @Override
            public int run() {
                String scriptContents = SshCliTool.this.toScript(this.props, commands, env);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Running shell command at {} as script: {}", (Object)SshCliTool.this.host, (Object)scriptContents);
                }
                SshCliTool.this.copyTempFileToServer((Map)ImmutableMap.of((Object)"permissions", (Object)"0700"), SshCliTool.this.writeTempFile(scriptContents), this.scriptPath);
                String cmd = Strings.join(this.buildRunScriptCommand(), (String)this.separator);
                return SshCliTool.asInt(SshCliTool.this.sshExec(this.props, cmd), -1);
            }
        }.run();
    }

    @Override
    public int execCommands(Map<String, ?> props, List<String> commands, Map<String, ?> env) {
        MutableMap props2 = new MutableMap();
        if (props != null) {
            props2.putAll(props);
        }
        props2.put(SshTool.PROP_NO_EXTRA_OUTPUT.getName(), true);
        return this.execScript((Map<String, ?>)props2, commands, env);
    }

    private int scpToServer(Map<String, ?> props, File local, String remote) {
        String to = (Strings.isEmpty((CharSequence)this.getUsername()) ? "" : this.getUsername() + "@") + this.getHostAddress() + ":" + remote;
        return this.scpExec(props, local.getAbsolutePath(), to);
    }

    private int scpFromServer(Map<String, ?> props, String remote, File local) {
        String from = (Strings.isEmpty((CharSequence)this.getUsername()) ? "" : this.getUsername() + "@") + this.getHostAddress() + ":" + remote;
        return this.scpExec(props, from, local.getAbsolutePath());
    }

    private int chmodOnServer(Map<String, ?> props, String permissions, String remote) {
        return this.sshExec(props, "chmod " + permissions + " " + remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int scpExec(Map<String, ?> props, String from, String to) {
        File tempFile = null;
        try {
            ArrayList cmd = Lists.newArrayList();
            cmd.add(SshCliTool.getOptionalVal(props, PROP_SCP_EXECUTABLE, this.scpExecutable));
            cmd.add("-B");
            if (this.privateKeyFile != null) {
                cmd.add("-i");
                cmd.add(this.privateKeyFile.getAbsolutePath());
            } else if (this.privateKeyData != null) {
                tempFile = this.writeTempFile(this.privateKeyData);
                cmd.add("-i");
                cmd.add(tempFile.getAbsolutePath());
            }
            if (!this.strictHostKeyChecking) {
                cmd.add("-o");
                cmd.add("StrictHostKeyChecking=no");
            }
            if (this.port != 22) {
                cmd.add("-P");
                cmd.add("" + this.port);
            }
            cmd.add(from);
            cmd.add(to);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Executing with command: {}", (Object)cmd);
            }
            int result = this.execProcess(props, cmd);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Executed command: {}; exit code {}", (Object)cmd, (Object)result);
            }
            int n = result;
            return n;
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sshExec(Map<String, ?> props, String command) {
        File tempKeyFile = null;
        try {
            ArrayList cmd = Lists.newArrayList();
            cmd.add(SshCliTool.getOptionalVal(props, PROP_SSH_EXECUTABLE, this.sshExecutable));
            String propsFlags = SshCliTool.getOptionalVal(props, PROP_SSH_FLAGS, this.sshFlags);
            cmd.add("-o");
            cmd.add("BatchMode=yes");
            if (propsFlags != null && propsFlags.trim().length() > 0) {
                cmd.addAll(Arrays.asList(propsFlags.trim().split(" ")));
            }
            if (this.privateKeyFile != null) {
                cmd.add("-i");
                cmd.add(this.privateKeyFile.getAbsolutePath());
            } else if (this.privateKeyData != null) {
                tempKeyFile = this.writeTempFile(this.privateKeyData);
                cmd.add("-i");
                cmd.add(tempKeyFile.getAbsolutePath());
            }
            if (!this.strictHostKeyChecking) {
                cmd.add("-o");
                cmd.add("StrictHostKeyChecking=no");
            }
            if (this.port != 22) {
                cmd.add("-P");
                cmd.add("" + this.port);
            }
            if (this.allocatePTY) {
                cmd.add("-tt");
            }
            cmd.add((Strings.isEmpty((CharSequence)this.getUsername()) ? "" : this.getUsername() + "@") + this.getHostAddress());
            cmd.add("bash -c " + StringEscapes.BashStringEscapes.wrapBash((String)command));
            if (LOG.isTraceEnabled()) {
                LOG.trace("Executing ssh with command: {} (with {})", (Object)command, (Object)cmd);
            }
            int result = this.execProcess(props, cmd);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Executed command: {}; exit code {}", (Object)cmd, (Object)result);
            }
            int n = result;
            return n;
        }
        finally {
            if (tempKeyFile != null) {
                tempKeyFile.delete();
            }
        }
    }

    private int execProcess(Map<String, ?> props, List<String> cmdWords) {
        OutputStream out = (OutputStream)SshCliTool.getOptionalVal(props, PROP_OUT_STREAM);
        OutputStream err = (OutputStream)SshCliTool.getOptionalVal(props, PROP_ERR_STREAM);
        return ProcessTool.execSingleProcess(cmdWords, null, null, out, err, this);
    }

    public static class Builder<T extends SshCliTool, B extends Builder<T, B>>
    extends SshAbstractTool.AbstractSshToolBuilder<T, B> {
        private String sshExecutable;
        private String sshFlags;
        private String scpExecutable;

        @Override
        public B from(Map<String, ?> props) {
            super.from(props);
            this.sshExecutable = ShellAbstractTool.getOptionalVal(props, PROP_SSH_EXECUTABLE);
            this.sshFlags = ShellAbstractTool.getOptionalVal(props, PROP_SSH_FLAGS);
            this.scpExecutable = ShellAbstractTool.getOptionalVal(props, PROP_SCP_EXECUTABLE);
            return (B)((Builder)this.self());
        }

        public B sshExecutable(String val) {
            this.sshExecutable = val;
            return (B)((Builder)this.self());
        }

        public B scpExecutable(String val) {
            this.scpExecutable = val;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new SshCliTool(this);
        }
    }

    private static class ConcreteBuilder
    extends Builder<SshCliTool, ConcreteBuilder> {
        private ConcreteBuilder() {
        }
    }
}

