/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.javax.annotation.Nullable;

public class PublicIPAddress {
    private final String id;
    private final String account;
    private final Date allocated;
    private final String associatedNetworkId;
    private final String domain;
    private final String domainId;
    private final boolean usesVirtualNetwork;
    private final String IPAddress;
    private final boolean isSourceNAT;
    private final boolean isStaticNAT;
    private final String networkId;
    private final State state;
    private final String virtualMachineDisplayName;
    private final String virtualMachineId;
    private final String virtualMachineName;
    private final String VLANId;
    private final String VLANName;
    private final String zoneId;
    private final String zoneName;
    private final String jobId;
    private final Integer jobStatus;
    private final Set<Tag> tags;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromPublicIPAddress(this);
    }

    @ConstructorProperties(value={"id", "account", "allocated", "associatednetworkid", "domain", "domainid", "forvirtualnetwork", "ipaddress", "issourcenat", "isstaticnat", "networkid", "state", "virtualmachinedisplayname", "virtualmachineid", "virtualmachinename", "VLANid", "VLANname", "zoneid", "zonename", "jobid", "jobstatus", "tags"})
    protected PublicIPAddress(String id, @Nullable String account, @Nullable Date allocated, @Nullable String associatedNetworkId, @Nullable String domain, @Nullable String domainId, boolean usesVirtualNetwork, @Nullable String IPAddress, boolean isSourceNAT, boolean isStaticNAT, @Nullable String networkId, @Nullable State state, @Nullable String virtualMachineDisplayName, @Nullable String virtualMachineId, @Nullable String virtualMachineName, @Nullable String VLANId, @Nullable String VLANName, @Nullable String zoneId, @Nullable String zoneName, @Nullable String jobId, @Nullable Integer jobStatus, @Nullable Set<Tag> tags) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.account = account;
        this.allocated = allocated;
        this.associatedNetworkId = associatedNetworkId;
        this.domain = domain;
        this.domainId = domainId;
        this.usesVirtualNetwork = usesVirtualNetwork;
        this.IPAddress = IPAddress;
        this.isSourceNAT = isSourceNAT;
        this.isStaticNAT = isStaticNAT;
        this.networkId = networkId;
        this.state = state;
        this.virtualMachineDisplayName = virtualMachineDisplayName;
        this.virtualMachineId = virtualMachineId;
        this.virtualMachineName = virtualMachineName;
        this.VLANId = VLANId;
        this.VLANName = VLANName;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.tags = tags != null ? ImmutableSet.copyOf(tags) : ImmutableSet.of();
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public Date getAllocated() {
        return this.allocated;
    }

    @Nullable
    public String getAssociatedNetworkId() {
        return this.associatedNetworkId;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    public boolean isUsesVirtualNetwork() {
        return this.usesVirtualNetwork;
    }

    @Nullable
    public String getIPAddress() {
        return this.IPAddress;
    }

    public boolean isSourceNAT() {
        return this.isSourceNAT;
    }

    public boolean isStaticNAT() {
        return this.isStaticNAT;
    }

    @Nullable
    public String getNetworkId() {
        return this.networkId;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    @Nullable
    public String getVirtualMachineDisplayName() {
        return this.virtualMachineDisplayName;
    }

    @Nullable
    public String getVirtualMachineId() {
        return this.virtualMachineId;
    }

    @Nullable
    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    @Nullable
    public String getVLANId() {
        return this.VLANId;
    }

    @Nullable
    public String getVLANName() {
        return this.VLANName;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getZoneName() {
        return this.zoneName;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    @Nullable
    public Integer getJobStatus() {
        return this.jobStatus;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.account, this.allocated, this.associatedNetworkId, this.domain, this.domainId, this.usesVirtualNetwork, this.IPAddress, this.isSourceNAT, this.isStaticNAT, this.networkId, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName, this.VLANId, this.VLANName, this.zoneId, this.zoneName, this.jobId, this.jobStatus, this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PublicIPAddress that = (PublicIPAddress)PublicIPAddress.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)this.allocated, (Object)that.allocated) && Objects.equal((Object)this.associatedNetworkId, (Object)that.associatedNetworkId) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.usesVirtualNetwork, (Object)that.usesVirtualNetwork) && Objects.equal((Object)this.IPAddress, (Object)that.IPAddress) && Objects.equal((Object)this.isSourceNAT, (Object)that.isSourceNAT) && Objects.equal((Object)this.isStaticNAT, (Object)that.isStaticNAT) && Objects.equal((Object)this.networkId, (Object)that.networkId) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal((Object)this.virtualMachineDisplayName, (Object)that.virtualMachineDisplayName) && Objects.equal((Object)this.virtualMachineId, (Object)that.virtualMachineId) && Objects.equal((Object)this.virtualMachineName, (Object)that.virtualMachineName) && Objects.equal((Object)this.VLANId, (Object)that.VLANId) && Objects.equal((Object)this.VLANName, (Object)that.VLANName) && Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.zoneName, (Object)that.zoneName) && Objects.equal((Object)this.jobId, (Object)that.jobId) && Objects.equal((Object)this.jobStatus, (Object)that.jobStatus) && Objects.equal(this.tags, that.tags);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("account", (Object)this.account).add("allocated", (Object)this.allocated).add("associatedNetworkId", (Object)this.associatedNetworkId).add("domain", (Object)this.domain).add("domainId", (Object)this.domainId).add("usesVirtualNetwork", this.usesVirtualNetwork).add("IPAddress", (Object)this.IPAddress).add("isSourceNAT", this.isSourceNAT).add("isStaticNAT", this.isStaticNAT).add("networkId", (Object)this.networkId).add("state", (Object)this.state).add("virtualMachineDisplayName", (Object)this.virtualMachineDisplayName).add("virtualMachineId", (Object)this.virtualMachineId).add("virtualMachineName", (Object)this.virtualMachineName).add("VLANId", (Object)this.VLANId).add("VLANName", (Object)this.VLANName).add("zoneId", (Object)this.zoneId).add("zoneName", (Object)this.zoneName).add("jobId", (Object)this.jobId).add("jobStatus", (Object)this.jobStatus).add("tags", this.tags);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String account;
        protected Date allocated;
        protected String associatedNetworkId;
        protected String domain;
        protected String domainId;
        protected boolean usesVirtualNetwork;
        protected String IPAddress;
        protected boolean isSourceNAT;
        protected boolean isStaticNAT;
        protected String networkId;
        protected State state;
        protected String virtualMachineDisplayName;
        protected String virtualMachineId;
        protected String virtualMachineName;
        protected String VLANId;
        protected String VLANName;
        protected String zoneId;
        protected String zoneName;
        protected String jobId;
        protected Integer jobStatus;
        protected Set<Tag> tags = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T allocated(Date allocated) {
            this.allocated = allocated;
            return this.self();
        }

        public T associatedNetworkId(String associatedNetworkId) {
            this.associatedNetworkId = associatedNetworkId;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T usesVirtualNetwork(boolean usesVirtualNetwork) {
            this.usesVirtualNetwork = usesVirtualNetwork;
            return this.self();
        }

        public T IPAddress(String IPAddress) {
            this.IPAddress = IPAddress;
            return this.self();
        }

        public T isSourceNAT(boolean isSourceNAT) {
            this.isSourceNAT = isSourceNAT;
            return this.self();
        }

        public T isStaticNAT(boolean isStaticNAT) {
            this.isStaticNAT = isStaticNAT;
            return this.self();
        }

        public T networkId(String networkId) {
            this.networkId = networkId;
            return this.self();
        }

        public T state(State state) {
            this.state = state;
            return this.self();
        }

        public T virtualMachineDisplayName(String virtualMachineDisplayName) {
            this.virtualMachineDisplayName = virtualMachineDisplayName;
            return this.self();
        }

        public T virtualMachineId(String virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this.self();
        }

        public T virtualMachineName(String virtualMachineName) {
            this.virtualMachineName = virtualMachineName;
            return this.self();
        }

        public T VLANId(String VLANId) {
            this.VLANId = VLANId;
            return this.self();
        }

        public T VLANName(String VLANName) {
            this.VLANName = VLANName;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this.self();
        }

        public T jobId(String jobId) {
            this.jobId = jobId;
            return this.self();
        }

        public T jobStatus(Integer jobStatus) {
            this.jobStatus = jobStatus;
            return this.self();
        }

        public T tags(Set<Tag> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this.self();
        }

        public T tags(Tag ... in) {
            return this.tags((Set<Tag>)ImmutableSet.copyOf((Object[])in));
        }

        public PublicIPAddress build() {
            return new PublicIPAddress(this.id, this.account, this.allocated, this.associatedNetworkId, this.domain, this.domainId, this.usesVirtualNetwork, this.IPAddress, this.isSourceNAT, this.isStaticNAT, this.networkId, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName, this.VLANId, this.VLANName, this.zoneId, this.zoneName, this.jobId, this.jobStatus, this.tags);
        }

        public T fromPublicIPAddress(PublicIPAddress in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).account(in.getAccount())).allocated(in.getAllocated())).associatedNetworkId(in.getAssociatedNetworkId())).domain(in.getDomain())).domainId(in.getDomainId())).usesVirtualNetwork(in.isUsesVirtualNetwork())).IPAddress(in.getIPAddress())).isSourceNAT(in.isSourceNAT())).isStaticNAT(in.isStaticNAT())).networkId(in.getNetworkId())).state(in.getState())).virtualMachineDisplayName(in.getVirtualMachineDisplayName())).virtualMachineId(in.getVirtualMachineId())).virtualMachineName(in.getVirtualMachineName())).VLANId(in.getVLANId())).VLANName(in.getVLANName())).zoneId(in.getZoneId())).zoneName(in.getZoneName())).jobId(in.getJobId())).jobStatus(in.getJobStatus())).tags(in.getTags());
        }
    }

    public static enum State {
        ALLOCATING,
        ALLOCATED,
        RELEASING,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

