/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain.internal;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.softlayer.domain.internal.BlockDevice;
import org.jclouds.softlayer.domain.internal.BlockDeviceTemplateGroup;
import org.jclouds.softlayer.domain.internal.Datacenter;
import org.jclouds.softlayer.domain.internal.NetworkComponent;
import org.jclouds.softlayer.domain.internal.PrimaryBackendNetworkComponent;
import org.jclouds.softlayer.domain.internal.PrimaryNetworkComponent;

public class TemplateObject {
    private final String hostname;
    private final String domain;
    private final int startCpus;
    private final int maxMemory;
    private final boolean hourlyBillingFlag;
    private final boolean localDiskFlag;
    private final boolean dedicatedAccountHostOnlyFlag;
    private final boolean privateNetworkOnlyFlag;
    private final BlockDeviceTemplateGroup blockDeviceTemplateGroup;
    private final String operatingSystemReferenceCode;
    private final Datacenter datacenter;
    private final Set<NetworkComponent> networkComponents;
    private final List<BlockDevice> blockDevices;
    private final String postInstallScriptUri;
    private final PrimaryNetworkComponent primaryNetworkComponent;
    private final PrimaryBackendNetworkComponent primaryBackendNetworkComponent;
    private final Set<Map<String, String>> userData;
    private final Set<Map<String, Integer>> sshKeys;

    private TemplateObject(String hostname, String domain, int startCpus, int maxMemory, boolean hourlyBillingFlag, boolean localDiskFlag, boolean dedicatedAccountHostOnlyFlag, boolean privateNetworkOnlyFlag, String operatingSystemReferenceCode, BlockDeviceTemplateGroup blockDeviceTemplateGroup, Datacenter datacenter, Set<NetworkComponent> networkComponents, List<BlockDevice> blockDevices, String postInstallScriptUri, PrimaryNetworkComponent primaryNetworkComponent, PrimaryBackendNetworkComponent primaryBackendNetworkComponent, Set<Map<String, String>> userData, Set<Map<String, Integer>> sshKeys) {
        this.hostname = hostname;
        this.domain = domain;
        this.startCpus = startCpus;
        this.maxMemory = maxMemory;
        this.hourlyBillingFlag = hourlyBillingFlag;
        this.localDiskFlag = localDiskFlag;
        this.dedicatedAccountHostOnlyFlag = dedicatedAccountHostOnlyFlag;
        this.privateNetworkOnlyFlag = privateNetworkOnlyFlag;
        this.operatingSystemReferenceCode = operatingSystemReferenceCode;
        this.blockDeviceTemplateGroup = blockDeviceTemplateGroup;
        this.datacenter = datacenter;
        this.networkComponents = networkComponents;
        this.blockDevices = blockDevices;
        this.postInstallScriptUri = postInstallScriptUri;
        this.primaryNetworkComponent = primaryNetworkComponent;
        this.primaryBackendNetworkComponent = primaryBackendNetworkComponent;
        this.userData = userData;
        this.sshKeys = sshKeys;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getStartCpus() {
        return this.startCpus;
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    public boolean isHourlyBillingFlag() {
        return this.hourlyBillingFlag;
    }

    public boolean isLocalDiskFlag() {
        return this.localDiskFlag;
    }

    public boolean isDedicatedAccountHostOnlyFlag() {
        return this.dedicatedAccountHostOnlyFlag;
    }

    public boolean isPrivateNetworkOnlyFlag() {
        return this.privateNetworkOnlyFlag;
    }

    public BlockDeviceTemplateGroup getBlockDeviceTemplateGroup() {
        return this.blockDeviceTemplateGroup;
    }

    public String getOperatingSystemReferenceCode() {
        return this.operatingSystemReferenceCode;
    }

    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    public Set<NetworkComponent> getNetworkComponents() {
        return this.networkComponents;
    }

    public List<BlockDevice> getBlockDevices() {
        return this.blockDevices;
    }

    public String getPostInstallScriptUri() {
        return this.postInstallScriptUri;
    }

    public PrimaryNetworkComponent getPrimaryNetworkComponent() {
        return this.primaryNetworkComponent;
    }

    public Set<Map<String, String>> getUserData() {
        return this.userData;
    }

    public Set<Map<String, Integer>> getSshKeys() {
        return this.sshKeys;
    }

    public PrimaryBackendNetworkComponent getPrimaryBackendNetworkComponent() {
        return this.primaryBackendNetworkComponent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return TemplateObject.builder().fromTemplateObject(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateObject that = (TemplateObject)o;
        return Objects.equal((Object)this.hostname, (Object)that.hostname) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.startCpus, (Object)that.startCpus) && Objects.equal((Object)this.maxMemory, (Object)that.maxMemory) && Objects.equal((Object)this.hourlyBillingFlag, (Object)that.hourlyBillingFlag) && Objects.equal((Object)this.localDiskFlag, (Object)that.localDiskFlag) && Objects.equal((Object)this.dedicatedAccountHostOnlyFlag, (Object)that.dedicatedAccountHostOnlyFlag) && Objects.equal((Object)this.privateNetworkOnlyFlag, (Object)that.privateNetworkOnlyFlag) && Objects.equal((Object)this.blockDeviceTemplateGroup, (Object)that.blockDeviceTemplateGroup) && Objects.equal((Object)this.operatingSystemReferenceCode, (Object)that.operatingSystemReferenceCode) && Objects.equal((Object)this.datacenter, (Object)that.datacenter) && Objects.equal(this.networkComponents, that.networkComponents) && Objects.equal(this.blockDevices, that.blockDevices) && Objects.equal((Object)this.postInstallScriptUri, (Object)that.postInstallScriptUri) && Objects.equal((Object)this.primaryNetworkComponent, (Object)that.primaryNetworkComponent) && Objects.equal((Object)this.primaryBackendNetworkComponent, (Object)that.primaryBackendNetworkComponent) && Objects.equal(this.userData, that.userData) && Objects.equal(this.sshKeys, that.sshKeys);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hostname, this.domain, this.startCpus, this.maxMemory, this.hourlyBillingFlag, this.localDiskFlag, this.dedicatedAccountHostOnlyFlag, this.privateNetworkOnlyFlag, this.blockDeviceTemplateGroup, this.operatingSystemReferenceCode, this.datacenter, this.networkComponents, this.blockDevices, this.postInstallScriptUri, this.primaryNetworkComponent, this.primaryBackendNetworkComponent, this.userData, this.sshKeys});
    }

    public static class Builder {
        protected String hostname;
        protected String domain;
        protected int startCpus;
        protected int maxMemory;
        protected boolean hourlyBillingFlag;
        protected boolean localDiskFlag;
        protected boolean dedicatedAccountHostOnlyFlag;
        protected boolean privateNetworkOnlyFlag;
        protected String operatingSystemReferenceCode;
        protected BlockDeviceTemplateGroup blockDeviceTemplateGroup;
        protected Datacenter datacenter;
        protected Set<NetworkComponent> networkComponents;
        protected List<BlockDevice> blockDevices;
        protected String postInstallScriptUri;
        protected PrimaryNetworkComponent primaryNetworkComponent;
        protected PrimaryBackendNetworkComponent primaryBackendNetworkComponent;
        protected Set<Map<String, String>> userData;
        protected Set<Map<String, Integer>> sshKeys;

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder startCpus(int startCpus) {
            this.startCpus = startCpus;
            return this;
        }

        public Builder maxMemory(int maxMemory) {
            this.maxMemory = maxMemory;
            return this;
        }

        public Builder hourlyBillingFlag(boolean hourlyBillingFlag) {
            this.hourlyBillingFlag = hourlyBillingFlag;
            return this;
        }

        public Builder localDiskFlag(boolean localDiskFlag) {
            this.localDiskFlag = localDiskFlag;
            return this;
        }

        public Builder dedicatedAccountHostOnlyFlag(boolean dedicatedAccountHostOnlyFlag) {
            this.dedicatedAccountHostOnlyFlag = dedicatedAccountHostOnlyFlag;
            return this;
        }

        public Builder privateNetworkOnlyFlag(boolean privateNetworkOnlyFlag) {
            this.privateNetworkOnlyFlag = privateNetworkOnlyFlag;
            return this;
        }

        public Builder operatingSystemReferenceCode(String operatingSystemReferenceCode) {
            this.operatingSystemReferenceCode = operatingSystemReferenceCode;
            return this;
        }

        public Builder blockDeviceTemplateGroup(BlockDeviceTemplateGroup blockDeviceTemplateGroup) {
            this.blockDeviceTemplateGroup = blockDeviceTemplateGroup;
            return this;
        }

        public Builder datacenter(Datacenter datacenter) {
            this.datacenter = datacenter;
            return this;
        }

        public Builder networkComponents(Set<NetworkComponent> networkComponents) {
            this.networkComponents = networkComponents;
            return this;
        }

        public Builder blockDevices(List<BlockDevice> blockDevices) {
            this.blockDevices = blockDevices;
            return this;
        }

        public Builder postInstallScriptUri(String postInstallScriptUri) {
            this.postInstallScriptUri = postInstallScriptUri;
            return this;
        }

        public Builder primaryNetworkComponent(PrimaryNetworkComponent primaryNetworkComponent) {
            this.primaryNetworkComponent = primaryNetworkComponent;
            return this;
        }

        public Builder primaryBackendNetworkComponent(PrimaryBackendNetworkComponent primaryBackendNetworkComponent) {
            this.primaryBackendNetworkComponent = primaryBackendNetworkComponent;
            return this;
        }

        public Builder userData(Set<Map<String, String>> userData) {
            this.userData = ImmutableSet.copyOf(userData);
            return this;
        }

        public Builder sshKeys(Set<Map<String, Integer>> sshKeys) {
            this.sshKeys = ImmutableSet.copyOf(sshKeys);
            return this;
        }

        public TemplateObject build() {
            return new TemplateObject(this.hostname, this.domain, this.startCpus, this.maxMemory, this.hourlyBillingFlag, this.localDiskFlag, this.dedicatedAccountHostOnlyFlag, this.privateNetworkOnlyFlag, this.operatingSystemReferenceCode, this.blockDeviceTemplateGroup, this.datacenter, this.networkComponents, this.blockDevices, this.postInstallScriptUri, this.primaryNetworkComponent, this.primaryBackendNetworkComponent, this.userData, this.sshKeys);
        }

        public Builder fromTemplateObject(TemplateObject in) {
            return this.hostname(in.getHostname()).domain(in.getDomain()).startCpus(in.getStartCpus()).maxMemory(in.getMaxMemory()).hourlyBillingFlag(in.isHourlyBillingFlag()).localDiskFlag(in.isLocalDiskFlag()).dedicatedAccountHostOnlyFlag(in.isDedicatedAccountHostOnlyFlag()).privateNetworkOnlyFlag(in.isPrivateNetworkOnlyFlag()).operatingSystemReferenceCode(in.getOperatingSystemReferenceCode()).blockDeviceTemplateGroup(in.getBlockDeviceTemplateGroup()).datacenter(in.getDatacenter()).networkComponents(in.getNetworkComponents()).blockDevices(in.getBlockDevices()).postInstallScriptUri(in.getPostInstallScriptUri()).primaryNetworkComponent(in.getPrimaryNetworkComponent()).primaryBackendNetworkComponent(in.getPrimaryBackendNetworkComponent()).userData(in.getUserData()).sshKeys(in.getSshKeys());
        }
    }
}

