/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.entity.webapp.WebAppService;
import org.apache.brooklyn.entity.webapp.WebAppServiceConstants;
import org.apache.brooklyn.policy.enricher.RollingTimeWindowMeanEnricher;
import org.apache.brooklyn.policy.enricher.TimeFractionDeltaEnricher;
import org.apache.brooklyn.policy.enricher.TimeWeightedDeltaEnricher;
import org.apache.brooklyn.util.time.Duration;

public class WebAppServiceMethods
implements WebAppServiceConstants {
    public static final Duration DEFAULT_WINDOW_DURATION = Duration.TEN_SECONDS;

    public static void connectWebAppServerPolicies(Entity entity) {
        WebAppServiceMethods.connectWebAppServerPolicies(entity, DEFAULT_WINDOW_DURATION);
    }

    public static void connectWebAppServerPolicies(Entity entity, Duration windowPeriod) {
        entity.enrichers().add((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(TimeWeightedDeltaEnricher.class).configure((CharSequence)"producer", (Object)entity)).configure((CharSequence)"source", (Object)REQUEST_COUNT)).configure((CharSequence)"target", (Object)REQUESTS_PER_SECOND_LAST)).configure((CharSequence)"unitMillis", (Object)1000));
        if (windowPeriod != null) {
            entity.enrichers().add((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(RollingTimeWindowMeanEnricher.class).configure((CharSequence)"producer", (Object)entity)).configure((CharSequence)"source", (Object)REQUESTS_PER_SECOND_LAST)).configure((CharSequence)"target", (Object)REQUESTS_PER_SECOND_IN_WINDOW)).configure((CharSequence)"timePeriod", (Object)windowPeriod));
        }
        entity.enrichers().add((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(TimeFractionDeltaEnricher.class).configure((CharSequence)"producer", (Object)entity)).configure((CharSequence)"source", (Object)TOTAL_PROCESSING_TIME)).configure((CharSequence)"target", (Object)PROCESSING_TIME_FRACTION_LAST)).configure((CharSequence)"durationPerOrigUnit", (Object)Duration.millis((Number)1)));
        if (windowPeriod != null) {
            entity.enrichers().add((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(RollingTimeWindowMeanEnricher.class).configure((CharSequence)"producer", (Object)entity)).configure((CharSequence)"source", (Object)PROCESSING_TIME_FRACTION_LAST)).configure((CharSequence)"target", (Object)PROCESSING_TIME_FRACTION_IN_WINDOW)).configure((CharSequence)"timePeriod", (Object)windowPeriod));
        }
    }

    public static Set<String> getEnabledProtocols(Entity entity) {
        return (Set)entity.getAttribute((AttributeSensor)WebAppService.ENABLED_PROTOCOLS);
    }

    public static boolean isProtocolEnabled(Entity entity, String protocol) {
        for (String contender : WebAppServiceMethods.getEnabledProtocols(entity)) {
            if (!protocol.equalsIgnoreCase(contender)) continue;
            return true;
        }
        return false;
    }

    public static String inferBrooklynAccessibleRootUrl(Entity entity) {
        if (WebAppServiceMethods.isProtocolEnabled(entity, "https")) {
            Integer rawPort = (Integer)entity.getAttribute((AttributeSensor)HTTPS_PORT);
            Preconditions.checkNotNull((Object)rawPort, (String)"HTTPS_PORT sensors not set for %s; is an acceptable port available?", (Object[])new Object[]{entity});
            HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)entity, (int)rawPort);
            return String.format("https://%s:%s/", hp.getHostText(), hp.getPort());
        }
        if (WebAppServiceMethods.isProtocolEnabled(entity, "http")) {
            Integer rawPort = (Integer)entity.getAttribute((AttributeSensor)HTTP_PORT);
            Preconditions.checkNotNull((Object)rawPort, (String)"HTTP_PORT sensors not set for %s; is an acceptable port available?", (Object[])new Object[]{entity});
            HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)entity, (int)rawPort);
            return String.format("http://%s:%s/", hp.getHostText(), hp.getPort());
        }
        throw new IllegalStateException("HTTP and HTTPS protocols not enabled for " + entity + "; enabled protocols are " + WebAppServiceMethods.getEnabledProtocols(entity));
    }
}

