/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.crate;

import com.google.common.base.Function;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.database.crate.CrateNode;
import org.apache.brooklyn.entity.database.crate.CrateNodeDriver;
import org.apache.brooklyn.entity.java.JavaAppUtils;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.apache.brooklyn.util.guava.Functionals;

public class CrateNodeImpl
extends SoftwareProcessImpl
implements CrateNode {
    private JmxFeed jmxFeed;
    private HttpFeed httpFeed;

    public Class getDriverInterface() {
        return CrateNodeDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        this.jmxFeed = JavaAppUtils.connectMXBeanSensors((Entity)this);
        this.sensors().set(DATASTORE_URL, (Object)("crate://" + (String)this.getAttribute(HOSTNAME) + ":" + this.getPort()));
        String url = "http://" + (String)this.getAttribute(HOSTNAME) + ":" + this.getHttpPort();
        this.sensors().set(MANAGEMENT_URL, (Object)url);
        this.httpFeed = HttpFeed.builder().entity((Entity)this).baseUri(url).poll((HttpPollConfig)new HttpPollConfig(SERVER_NAME).onSuccess(HttpValueFunctions.jsonContents((String)"name", String.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_STATUS).onSuccess(HttpValueFunctions.jsonContents((String)"status", Integer.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_OK).onSuccess(HttpValueFunctions.jsonContents((String)"ok", Boolean.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_BUILD_TIMESTAMP).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"version", "build_timestamp"}, String.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_BUILD_HASH).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"version", "build_hash"}, String.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_IS_BUILD_SNAPSHOT).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"version", "build_snapshot"}, Boolean.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_LUCENE_VERSION).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"version", "lucene_version"}, String.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_ES_VERSION).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"version", "es_version"}, String.class))).build();
        this.enrichers().add(((Enrichers.UpdatingMapBuilder)Enrichers.builder().updatingMap(Attributes.SERVICE_NOT_UP_INDICATORS).from(SERVER_OK).computing((Function)Functionals.ifNotEquals((Object)true).value((Object)"Crate server reports it is not ok."))).build());
    }

    protected void disconnectSensors() {
        this.disconnectServiceUpIsRunning();
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        super.disconnectSensors();
    }

    public Integer getPort() {
        return (Integer)this.getAttribute((AttributeSensor)CRATE_PORT);
    }

    public Integer getHttpPort() {
        return (Integer)this.getAttribute((AttributeSensor)CRATE_HTTP_PORT);
    }

    static {
        JavaAppUtils.init();
        RendererHints.register((AttributeSensor)MANAGEMENT_URL, (RendererHints.Hint)RendererHints.namedActionWithUrl());
    }
}

