/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.mysql;

import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.database.DatastoreMixins;
import org.apache.brooklyn.entity.database.mysql.MySqlClusterImpl;
import org.apache.brooklyn.entity.database.mysql.ReplicationSnapshot;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.util.GenericTypes;

@ImplementedBy(value=MySqlClusterImpl.class)
@Catalog(name="MySql Master-Slave cluster", description="Sets up a cluster of MySQL nodes using master-slave relation and binary logging", iconUrl="classpath:///mysql-logo-110x57.png")
public interface MySqlCluster
extends DynamicCluster,
DatastoreMixins.HasDatastoreUrl {
    public static final AttributeSensor<ReplicationSnapshot> REPLICATION_LAST_SLAVE_SNAPSHOT = Sensors.newSensor(ReplicationSnapshot.class, (String)"mysql.replication.last_slave_snapshot", (String)"Last valid state to init slaves with");
    public static final ConfigKey<String> REPLICATION_PREFERRED_SOURCE = ConfigKeys.newStringConfigKey((String)"mysql.replication.preferred_source", (String)"ID of node to get the replication snapshot from. If not set a random slave is used, falling back to master if no slaves.");
    public static final ConfigKey<String> SLAVE_USERNAME = ConfigKeys.newStringConfigKey((String)"mysql.slave.username", (String)"The user name slaves will use to connect to the master", (String)"slave");
    public static final ConfigKey<Collection<String>> SLAVE_REPLICATE_DO_DB = ConfigKeys.newConfigKey((TypeToken)GenericTypes.COLLECTION_STRING, (String)"mysql.slave.replicate_do_db", (String)"Replicate only listed DBs. Use together with 'mysql.slave.replicate_dump_db'.");
    public static final ConfigKey<Collection<String>> SLAVE_REPLICATE_IGNORE_DB = ConfigKeys.newConfigKey((TypeToken)GenericTypes.COLLECTION_STRING, (String)"mysql.slave.replicate_ignore_db", (String)"Don't replicate listed DBs. Use together with 'mysql.slave.replicate_dump_db'.");
    public static final ConfigKey<Collection<String>> SLAVE_REPLICATE_DO_TABLE = ConfigKeys.newConfigKey((TypeToken)GenericTypes.COLLECTION_STRING, (String)"mysql.slave.replicate_do_table", (String)"Replicate only listed tables. Use together with 'mysql.slave.replicate_dump_db'.");
    public static final ConfigKey<Collection<String>> SLAVE_REPLICATE_IGNORE_TABLE = ConfigKeys.newConfigKey((TypeToken)GenericTypes.COLLECTION_STRING, (String)"mysql.slave.replicate_ignore_table", (String)"Don't replicate listed tables. Use together with 'mysql.slave.replicate_dump_db'.");
    public static final ConfigKey<Collection<String>> SLAVE_REPLICATE_WILD_DO_TABLE = ConfigKeys.newConfigKey((TypeToken)GenericTypes.COLLECTION_STRING, (String)"mysql.slave.replicate_wild_do_table", (String)"Replicate only listed tables, wildcards acepted. Use together with 'mysql.slave.replicate_dump_db'.");
    public static final ConfigKey<Collection<String>> SLAVE_REPLICATE_WILD_IGNORE_TABLE = ConfigKeys.newConfigKey((TypeToken)GenericTypes.COLLECTION_STRING, (String)"mysql.slave.replicate_wild_ignore_table", (String)"Don't replicate listed tables, wildcards acepted. Use together with 'mysql.slave.replicate_dump_db'.");
    public static final ConfigKey<Collection<String>> SLAVE_REPLICATE_DUMP_DB = ConfigKeys.newConfigKey((TypeToken)GenericTypes.COLLECTION_STRING, (String)"mysql.slave.replicate_dump_db", (String)"Databases to pass to the mysqldump command, used for slave initialization");
    public static final BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey SLAVE_PASSWORD = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("mysql.slave.password", "The password slaves will use to connect to the master. Will be auto-generated by default.");
    public static final AttributeSensor<List<String>> SLAVE_DATASTORE_URL_LIST = Sensors.newSensor((TypeToken)new TypeToken<List<String>>(){}, (String)"mysql.slave.datastore.url", (String)"List of all slave's DATASTORE_URL sensors");
    public static final AttributeSensor<Double> QUERIES_PER_SECOND_FROM_MYSQL_PER_NODE = Sensors.newDoubleSensor((String)"mysql.queries.perSec.fromMysql.perNode");

    public static interface MySqlSlave {
        public static final AttributeSensor<Boolean> SLAVE_HEALTHY = Sensors.newBooleanSensor((String)"mysql.slave.healthy", (String)"Indicates that the replication state of the slave is healthy");
        public static final AttributeSensor<Integer> SLAVE_SECONDS_BEHIND_MASTER = Sensors.newIntegerSensor((String)"mysql.slave.seconds_behind_master", (String)"How many seconds behind master is the replication state on the slave");
    }

    public static interface MySqlMaster {
        public static final ConfigKey<String> MASTER_CREATION_SCRIPT_CONTENTS = ConfigKeys.newStringConfigKey((String)"datastore.master.creation.script.contents", (String)"Contents of creation script to initialize the master node after initializing replication");
        public static final ConfigKey<String> MASTER_CREATION_SCRIPT_URL = ConfigKeys.newStringConfigKey((String)"datastore.master.creation.script.url", (String)"URL of creation script to use to initialize the master node after initializing replication (ignored if creationScriptContents is specified)");
    }
}

