/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import org.jclouds.scriptbuilder.domain.AppendFile;

public class CreateOrOverwriteFile
extends AppendFile {
    public static Builder builder() {
        return new Builder();
    }

    protected CreateOrOverwriteFile(String path, Iterable<String> lines, String delimiter, boolean expandVariables) {
        super(path, lines, delimiter, expandVariables);
    }

    @Override
    protected String appendToWindowsFile() {
        return String.format("copy /y CON %s{lf}", this.path) + super.appendToWindowsFile();
    }

    @Override
    public StringBuilder startHereFile() {
        StringBuilder hereFile = new StringBuilder().append("cat > ").append(this.path);
        if (this.expandVariables) {
            return hereFile.append(" <<-").append(this.delimiter).append("\n");
        }
        return hereFile.append(" <<-'").append(this.delimiter).append("'\n");
    }

    public static class Builder
    extends AppendFile.Builder {
        @Override
        public Builder path(String path) {
            return (Builder)Builder.class.cast(super.path(path));
        }

        @Override
        public Builder lines(Iterable<String> lines) {
            return (Builder)Builder.class.cast(super.lines(lines));
        }

        @Override
        public Builder delimiter(String delimiter) {
            return (Builder)Builder.class.cast(super.delimiter(delimiter));
        }

        @Override
        public Builder expandVariables(boolean expandVariables) {
            return (Builder)Builder.class.cast(super.expandVariables(expandVariables));
        }

        @Override
        public CreateOrOverwriteFile build() {
            return new CreateOrOverwriteFile(this.path, this.lines, this.delimiter, this.expandVariables);
        }
    }
}

