/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.PersistentVolumeListFluent;
import java.util.ArrayList;
import java.util.List;

public class PersistentVolumeListFluentImpl<A extends PersistentVolumeListFluent<A>>
extends BaseFluent<A>
implements PersistentVolumeListFluent<A> {
    private String apiVersion;
    private List<VisitableBuilder<? extends PersistentVolume, ?>> items = new ArrayList();
    private String kind;
    private VisitableBuilder<? extends ListMeta, ?> metadata;

    public PersistentVolumeListFluentImpl() {
    }

    public PersistentVolumeListFluentImpl(PersistentVolumeList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToItems(PersistentVolume ... items) {
        for (PersistentVolume item : items) {
            PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(PersistentVolume ... items) {
        for (PersistentVolume item : items) {
            PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<PersistentVolume> getItems() {
        return PersistentVolumeListFluentImpl.build(this.items);
    }

    @Override
    public A withItems(List<PersistentVolume> items) {
        this._visitables.removeAll(this.items);
        this.items.clear();
        if (items != null) {
            for (PersistentVolume item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(PersistentVolume ... items) {
        this.items.clear();
        if (items != null) {
            for (PersistentVolume item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public PersistentVolumeListFluent.ItemsNested<A> addNewItemLike(PersistentVolume item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PersistentVolumeListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PersistentVolumeListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PersistentVolumeListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ListMetaBuilder().build());
    }

    @Override
    public PersistentVolumeListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentVolumeListFluentImpl that = (PersistentVolumeListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<PersistentVolumeListFluent.MetadataNested<N>>
    implements PersistentVolumeListFluent.MetadataNested<N>,
    Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends PersistentVolumeFluentImpl<PersistentVolumeListFluent.ItemsNested<N>>
    implements PersistentVolumeListFluent.ItemsNested<N>,
    Nested<N> {
        private final PersistentVolumeBuilder builder;

        ItemsNestedImpl(PersistentVolume item) {
            this.builder = new PersistentVolumeBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.builder = new PersistentVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeListFluentImpl.this.addToItems(this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

