/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.hazelcast;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.nosql.hazelcast.HazelcastCluster;
import org.apache.brooklyn.entity.nosql.hazelcast.HazelcastNode;
import org.apache.brooklyn.entity.nosql.hazelcast.HazelcastNodeDriver;
import org.apache.brooklyn.entity.nosql.hazelcast.HazelcastNodeImpl;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastNodeSshDriver
extends JavaSoftwareProcessSshDriver
implements HazelcastNodeDriver {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastNodeSshDriver.class);

    public HazelcastNodeSshDriver(HazelcastNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        ImmutableList commands = ImmutableList.builder().add((Object)BashCommands.installJavaLatestOrWarn()).addAll((Iterable)BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs)).build();
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public void customize() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Customizing {}", this.entity.getAttribute((AttributeSensor)HazelcastNode.NODE_NAME));
        }
        ImmutableList.Builder commands = new ImmutableList.Builder().add((Object)"mkdir -p lib conf log").add((Object)String.format("cp %s/%s %s/lib/", this.getInstallDir(), this.resolver.getFilename(), this.getRunDir()));
        this.newScript((String)"customizing").body.append((Collection)commands.build()).failOnNonZeroResultCode().execute();
        this.copyTemplate((String)this.entity.getConfig(HazelcastNode.CONFIG_TEMPLATE_URL), Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "conf", this.getConfigFileName()}));
    }

    public void launch() {
        this.entity.sensors().set(HazelcastNode.PID_FILE, (Object)Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "pid.txt"}));
        String maxHeapMemorySize = this.getHeapMemorySize();
        if (LOG.isInfoEnabled()) {
            LOG.info("Launching {} with heap memory of {}", (Object)this.entity, (Object)maxHeapMemorySize);
        }
        String initialHeapMemorySize = maxHeapMemorySize;
        ImmutableList commands = ImmutableList.builder().add((Object)String.format("nohup java -cp ./lib/%s", this.resolver.getFilename())).add((Object)String.format("-Xmx%s -Xms%s", maxHeapMemorySize, initialHeapMemorySize)).add((Object)String.format("-Dhazelcast.config=./conf/%s", this.getConfigFileName())).add((Object)String.format("com.hazelcast.core.server.StartServer >> %s 2>&1 </dev/null &", this.getLogFileLocation())).build();
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)true)), (String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)Joiner.on((String)" ").join((Iterable)commands)).execute();
    }

    public String getConfigFileName() {
        return (String)this.entity.getConfig(HazelcastNode.CONFIG_FILE_NAME);
    }

    public String getHeapMemorySize() {
        return (String)this.entity.getConfig(HazelcastNode.NODE_HEAP_MEMORY_SIZE);
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "stopping").execute();
    }

    public void kill() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "killing").execute();
    }

    public List<String> getHazelcastNodesList() {
        ArrayList result = Lists.newArrayList();
        if (Strings.isBlank((CharSequence)((CharSequence)this.entity.getAttribute(HazelcastNode.NODE_CLUSTER_NAME)))) {
            result.add(String.format("%s:%d", this.entity.getAttribute(HazelcastNode.SUBNET_ADDRESS), this.entity.getAttribute((AttributeSensor)HazelcastNode.NODE_PORT)));
        } else {
            HazelcastCluster cluster = (HazelcastCluster)this.entity.getParent();
            for (Entity member : cluster.getMembers()) {
                String address = (String)Entities.attributeSupplierWhenReady((Entity)member, (AttributeSensor)HazelcastNode.SUBNET_ADDRESS).get();
                Integer port = (Integer)Entities.attributeSupplierWhenReady((Entity)member, (AttributeSensor)HazelcastNode.NODE_PORT).get();
                String addressAndPort = String.format("%s:%d", address, port);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Adding {} to the members' list of {}", (Object)addressAndPort, this.entity.getAttribute((AttributeSensor)HazelcastNode.NODE_NAME));
                }
                result.add(addressAndPort);
            }
        }
        return result;
    }

    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "/log/out.log"});
    }
}

