/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.guava;

import com.google.common.base.Supplier;
import java.util.concurrent.atomic.AtomicInteger;

public class Suppliers {
    private Suppliers() {
    }

    public static Supplier<Integer> incrementing() {
        return Suppliers.incrementing(0);
    }

    public static Supplier<Integer> incrementing(int initialValue) {
        return new IncrementingSupplier(initialValue);
    }

    private static class IncrementingSupplier
    implements Supplier<Integer> {
        private final AtomicInteger value;

        private IncrementingSupplier(int initialValue) {
            this.value = new AtomicInteger(initialValue);
        }

        public Integer get() {
            return this.value.getAndIncrement();
        }
    }
}

