/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.server;

import com.google.inject.Inject;
import java.util.List;
import org.jclouds.date.DateService;
import org.jclouds.profitbricks.domain.Nic;
import org.jclouds.profitbricks.domain.Server;
import org.jclouds.profitbricks.domain.Storage;
import org.jclouds.profitbricks.http.parser.nic.NicListResponseHandler;
import org.jclouds.profitbricks.http.parser.server.BaseServerResponseHandler;
import org.jclouds.profitbricks.http.parser.storage.StorageListResponseHandler;
import org.xml.sax.SAXException;

public class ServerInfoResponseHandler
extends BaseServerResponseHandler<Server> {
    private boolean done = false;

    @Inject
    ServerInfoResponseHandler(DateService dateService, StorageListResponseHandler storageListResponseHandler, NicListResponseHandler nicListResponseHandler) {
        super(dateService, storageListResponseHandler, nicListResponseHandler);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.done) {
            return;
        }
        if (this.useStorageParser) {
            this.storageListResponseHandler.endElement(uri, localName, qName);
        } else if (this.useNicParser) {
            this.nicListResponseHandler.endElement(uri, localName, qName);
        } else {
            this.setPropertyOnEndTag(qName);
            if ("return".equals(qName)) {
                this.done = true;
                this.builder.dataCenter(this.dataCenterBuilder.build()).storages((List<Storage>)this.storageListResponseHandler.getResult()).nics((List<Nic>)this.nicListResponseHandler.getResult());
            }
            this.clearTextBuffer();
        }
        if ("connectedStorages".equals(qName)) {
            this.useStorageParser = false;
        } else if ("nics".equals(qName)) {
            this.useNicParser = false;
        }
    }

    public Server getResult() {
        return this.builder.build();
    }
}

