/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.brooklyn.util.text.Identifiers;

@Provider
@Priority(value=100)
public class RequestTaggingRsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final String ATT_REQUEST_ID = RequestTaggingRsFilter.class.getName() + ".id";
    @Context
    private HttpServletRequest req;
    private static ThreadLocal<String> tag = new ThreadLocal();

    protected static String getTag() {
        return (String)Preconditions.checkNotNull((Object)tag.get());
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String requestId = this.getRequestId();
        tag.set(requestId);
    }

    private String getRequestId() {
        Object id = this.req.getAttribute(ATT_REQUEST_ID);
        if (id != null) {
            return id.toString();
        }
        return Identifiers.makeRandomId((int)6);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        tag.remove();
    }
}

