/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityManager;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.api.mgmt.ha.ManagementPlaneSyncRecord;
import org.apache.brooklyn.api.mgmt.ha.MementoCopyMode;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.StartableApplication;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.mgmt.ShutdownHandler;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.persist.BrooklynPersistenceUtils;
import org.apache.brooklyn.core.mgmt.persist.FileBasedObjectStore;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.rest.api.ServerApi;
import org.apache.brooklyn.rest.domain.HighAvailabilitySummary;
import org.apache.brooklyn.rest.domain.VersionSummary;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.BrooklynFeatureTransformer;
import org.apache.brooklyn.rest.transform.HighAvailabilityTransformer;
import org.apache.brooklyn.rest.util.MultiSessionAttributeAdapter;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.file.ArchiveBuilder;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerResource
extends AbstractBrooklynRestResource
implements ServerApi {
    private static final int SHUTDOWN_TIMEOUT_CHECK_INTERVAL = 200;
    private static final Logger log = LoggerFactory.getLogger(ServerResource.class);
    private static final String BUILD_SHA_1_PROPERTY = "git-sha-1";
    private static final String BUILD_BRANCH_PROPERTY = "git-branch-name";
    @Context
    private ContextResolver<ShutdownHandler> shutdownHandler;
    @Context
    private HttpServletRequest request;

    public void reloadBrooklynProperties() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ALL_SERVER_INFO, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        this.brooklyn().reloadBrooklynProperties();
    }

    private boolean isMaster() {
        return ManagementNodeState.MASTER.equals((Object)this.mgmt().getHighAvailabilityManager().getNodeState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(final boolean stopAppsFirst, final boolean forceShutdownOnError, String shutdownTimeoutRaw, String requestTimeoutRaw, String delayForHttpReturnRaw, Long delayMillis) {
        Duration delayForHttpReturn;
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ALL_SERVER_INFO, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SHUTDOWN, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized for shutdown", Entitlements.getEntitlementContext().user());
        }
        log.info("REST call to shutdown server, stopAppsFirst=" + stopAppsFirst + ", delayForHttpReturn=" + shutdownTimeoutRaw);
        if (stopAppsFirst && !this.isMaster()) {
            log.warn("REST call to shutdown non-master server while stopping apps is disallowed");
            throw WebResourceUtils.forbidden("Not allowed to stop all apps when server is not master", new Object[0]);
        }
        final Duration shutdownTimeout = this.parseDuration(shutdownTimeoutRaw, Duration.of((long)20L, (TimeUnit)TimeUnit.SECONDS));
        Duration requestTimeout = this.parseDuration(requestTimeoutRaw, Duration.of((long)20L, (TimeUnit)TimeUnit.SECONDS));
        if (delayMillis == null) {
            delayForHttpReturn = this.parseDuration(delayForHttpReturnRaw, Duration.FIVE_SECONDS);
        } else {
            log.warn("'delayMillis' is deprecated, use 'delayForHttpReturn' instead.");
            delayForHttpReturn = Duration.of((long)delayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Preconditions.checkState((delayForHttpReturn.nanos() >= 0L ? 1 : 0) != 0, (Object)"Only positive or 0 delay allowed for delayForHttpReturn");
        boolean isSingleTimeout = shutdownTimeout.equals((Object)requestTimeout);
        final AtomicBoolean completed = new AtomicBoolean();
        final AtomicBoolean hasAppErrorsOrTimeout = new AtomicBoolean();
        final ShutdownHandler handler = (ShutdownHandler)this.shutdownHandler.getContext(ShutdownHandler.class);
        final ManagementContext mgmt = this.mgmt();
        new Thread("shutdown"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean terminateTried = false;
                try {
                    if (stopAppsFirst) {
                        CountdownTimer shutdownTimeoutTimer = null;
                        if (!shutdownTimeout.equals((Object)Duration.ZERO)) {
                            shutdownTimeoutTimer = shutdownTimeout.countdownTimer();
                        }
                        log.debug("Stopping applications");
                        ArrayList<Task> stoppers = new ArrayList<Task>();
                        int allStoppableApps = 0;
                        for (Application app : mgmt.getApplications()) {
                            ++allStoppableApps;
                            Lifecycle appState = (Lifecycle)app.getAttribute(Attributes.SERVICE_STATE_ACTUAL);
                            if (app instanceof StartableApplication && appState != Lifecycle.STOPPING) {
                                stoppers.add(Entities.invokeEffector((Entity)app, (Entity)app, (Effector)StartableApplication.STOP));
                                continue;
                            }
                            log.debug("App " + app + " is already stopping, will not stop second time. Will wait for original stop to complete.");
                        }
                        log.debug("Waiting for " + allStoppableApps + " apps to stop, of which " + stoppers.size() + " stopped explicitly.");
                        for (Task t : stoppers) {
                            if (this.waitAppShutdown(shutdownTimeoutTimer, t)) continue;
                            hasAppErrorsOrTimeout.set(true);
                        }
                        if (this.hasStoppableApps(mgmt)) {
                            log.debug("Apps are still stopping, wait for proper unmanage.");
                            while (this.hasStoppableApps(mgmt) && (shutdownTimeoutTimer == null || !shutdownTimeoutTimer.isExpired())) {
                                Duration wait = shutdownTimeoutTimer != null ? Duration.min((Duration)shutdownTimeoutTimer.getDurationRemaining(), (Duration)Duration.ONE_SECOND) : Duration.ONE_SECOND;
                                Time.sleep((Duration)wait);
                            }
                            if (this.hasStoppableApps(mgmt)) {
                                hasAppErrorsOrTimeout.set(true);
                            }
                        }
                    }
                    terminateTried = true;
                    ((ManagementContextInternal)mgmt).terminate();
                }
                catch (Throwable e) {
                    Throwable interesting = Exceptions.getFirstInteresting((Throwable)e);
                    if (interesting instanceof TimeoutException) {
                        log.warn("Timeout shutting down: " + Exceptions.collapseText((Throwable)e));
                        log.debug("Timeout shutting down: " + e, e);
                        hasAppErrorsOrTimeout.set(true);
                    } else {
                        log.error("Unexpected error shutting down: " + Exceptions.collapseText((Throwable)e), e);
                    }
                    hasAppErrorsOrTimeout.set(true);
                    if (!terminateTried) {
                        ServerResource.this.mgmtInternal().terminate();
                    }
                }
                finally {
                    this.complete();
                    if (!hasAppErrorsOrTimeout.get() || forceShutdownOnError) {
                        Time.sleep((Duration)delayForHttpReturn);
                        if (handler != null) {
                            handler.onShutdownRequest();
                        } else {
                            log.warn("ShutdownHandler not set, exiting process");
                            System.exit(0);
                        }
                    } else {
                        log.warn("Abandoning shutdown because there were errors and shutdown was not forced.");
                    }
                }
            }

            private boolean hasStoppableApps(ManagementContext mgmt2) {
                for (Application app : mgmt2.getApplications()) {
                    if (!(app instanceof StartableApplication)) continue;
                    Lifecycle state = (Lifecycle)app.getAttribute(Attributes.SERVICE_STATE_ACTUAL);
                    if (state != Lifecycle.STOPPING && state != Lifecycle.STOPPED) {
                        log.warn("Shutting down, expecting all apps to be in stopping state, but found application " + app + " to be in state " + state + ". Just started?");
                    }
                    return true;
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void complete() {
                AtomicBoolean atomicBoolean = completed;
                synchronized (atomicBoolean) {
                    completed.set(true);
                    completed.notifyAll();
                }
            }

            private boolean waitAppShutdown(CountdownTimer shutdownTimeoutTimer, Task<?> t) throws TimeoutException {
                Duration waitInterval = null;
                if (shutdownTimeoutTimer != null) {
                    waitInterval = Duration.of((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                while (!t.blockUntilEnded(waitInterval)) {
                    if (!shutdownTimeoutTimer.isExpired()) continue;
                    log.warn("Timeout while waiting for applications to stop at " + t + ".\n" + t.getStatusDetail(true));
                    throw new TimeoutException();
                }
                if (t.isError()) {
                    log.warn("Error stopping application " + t + " during shutdown (ignoring)\n" + t.getStatusDetail(true));
                    return false;
                }
                return true;
            }
        }.start();
        AtomicBoolean atomicBoolean = completed;
        synchronized (atomicBoolean) {
            if (!completed.get()) {
                try {
                    long waitTimeout = 0L;
                    if (!isSingleTimeout) {
                        waitTimeout = requestTimeout.toMilliseconds();
                    }
                    completed.wait(waitTimeout);
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
        if (hasAppErrorsOrTimeout.get()) {
            WebResourceUtils.badRequest("Error or timeout while stopping applications. See log for details.", new Object[0]);
        }
    }

    private Duration parseDuration(String str, Duration defaultValue) {
        if (Strings.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        return Duration.parse((String)str);
    }

    public VersionSummary getVersion() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SERVER_STATUS, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        InputStream input = ResourceUtils.create((Object)this).getResourceFromUrl("classpath://build-metadata.properties");
        Properties properties = new Properties();
        String gitSha1 = null;
        String gitBranch = null;
        try {
            properties.load(input);
            gitSha1 = properties.getProperty(BUILD_SHA_1_PROPERTY);
            gitBranch = properties.getProperty(BUILD_BRANCH_PROPERTY);
        }
        catch (IOException e) {
            log.error("Failed to load build-metadata.properties", (Throwable)e);
        }
        gitSha1 = BrooklynVersion.INSTANCE.getSha1FromOsgiManifest();
        FluentIterable features = FluentIterable.from((Iterable)BrooklynVersion.getFeatures((ManagementContext)this.mgmt())).transform(BrooklynFeatureTransformer.FROM_FEATURE);
        return new VersionSummary(BrooklynVersion.get(), gitSha1, gitBranch, (List)features.toList());
    }

    public String getPlaneId() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SERVER_STATUS, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        Maybe<ManagementContext> mm = this.mgmtMaybe();
        Maybe result = mm.isPresent() ? ((ManagementContext)mm.get()).getManagementPlaneIdMaybe() : Maybe.absent();
        return result.isPresent() ? (String)result.get() : "";
    }

    public boolean isUp() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SERVER_STATUS, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        Maybe<ManagementContext> mm = this.mgmtMaybe();
        return !mm.isAbsent() && ((ManagementContext)mm.get()).isStartupComplete() && ((ManagementContext)mm.get()).isRunning();
    }

    public boolean isShuttingDown() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SERVER_STATUS, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        Maybe<ManagementContext> mm = this.mgmtMaybe();
        return !mm.isAbsent() && ((ManagementContext)mm.get()).isStartupComplete() && !((ManagementContext)mm.get()).isRunning();
    }

    public boolean isHealthy() {
        return this.isUp() && this.mgmtInternal().errors().isEmpty();
    }

    public Map<String, Object> getUpExtended() {
        MultiSessionAttributeAdapter.of(this.request);
        return MutableMap.of((Object)"up", (Object)this.isUp(), (Object)"shuttingDown", (Object)this.isShuttingDown(), (Object)"healthy", (Object)this.isHealthy(), (Object)"ha", (Object)this.getHighAvailabilityPlaneStates());
    }

    public String getConfig(String configKey) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ALL_SERVER_INFO, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        ConfigKey config = ConfigKeys.newStringConfigKey((String)configKey);
        return (String)WebResourceUtils.getValueForDisplay(this.mapper(), this.mgmt().getConfig().getConfig(config), true, true);
    }

    public ManagementNodeState getHighAvailabilityNodeState() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SERVER_STATUS, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        Maybe<ManagementContext> mm = this.mgmtMaybe();
        if (mm.isAbsent()) {
            return ManagementNodeState.INITIALIZING;
        }
        return ((ManagementContext)mm.get()).getHighAvailabilityManager().getNodeState();
    }

    public ManagementNodeState setHighAvailabilityNodeState(HighAvailabilityMode mode) {
        if (mode == null) {
            throw new IllegalStateException("Missing parameter: mode");
        }
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.HA_ADMIN, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        HighAvailabilityManager haMgr = this.mgmt().getHighAvailabilityManager();
        ManagementNodeState existingState = haMgr.getNodeState();
        haMgr.changeMode(mode);
        return existingState;
    }

    public Map<String, Object> getHighAvailabilityMetrics() {
        if (Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.HA_STATS, null)) {
            return this.mgmt().getHighAvailabilityManager().getMetrics();
        }
        throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
    }

    public long getHighAvailabitlityPriority() {
        if (Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.HA_STATS, null)) {
            return this.mgmt().getHighAvailabilityManager().getPriority();
        }
        throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
    }

    public long setHighAvailabilityPriority(long priority) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.HA_ADMIN, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        HighAvailabilityManager haMgr = this.mgmt().getHighAvailabilityManager();
        long oldPrio = haMgr.getPriority();
        haMgr.setPriority(priority);
        return oldPrio;
    }

    public HighAvailabilitySummary getHighAvailabilityPlaneStates() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SERVER_STATUS, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        ManagementPlaneSyncRecord memento = this.mgmt().getHighAvailabilityManager().getLastManagementPlaneSyncRecord();
        if (memento == null) {
            memento = this.mgmt().getHighAvailabilityManager().loadManagementPlaneSyncRecord(true);
        }
        if (memento == null) {
            return null;
        }
        if (memento.getMasterNodeId() == null) {
            memento = this.mgmt().getHighAvailabilityManager().loadManagementPlaneSyncRecord(true);
        }
        return HighAvailabilityTransformer.highAvailabilitySummary(this.mgmt().getManagementNodeId(), memento);
    }

    public Response clearHighAvailabilityPlaneStates() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SYSTEM_ADMIN, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        this.mgmt().getHighAvailabilityManager().publishClearNonMaster();
        return Response.ok().build();
    }

    public String getUser() {
        MultiSessionAttributeAdapter.of(this.request);
        EntitlementContext entitlementContext = Entitlements.getEntitlementContext();
        if (entitlementContext != null && entitlementContext.user() != null) {
            return (String)WebResourceUtils.getValueForDisplay(this.mapper(), entitlementContext.user(), true, true);
        }
        return null;
    }

    public Response exportPersistenceData(String preferredOrigin) {
        return this.exportPersistenceData((MementoCopyMode)TypeCoercions.coerce((Object)preferredOrigin, MementoCopyMode.class));
    }

    protected Response exportPersistenceData(MementoCopyMode preferredOrigin) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ALL_SERVER_INFO, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        File dir = null;
        try {
            String label = this.mgmt().getManagementNodeId() + "-" + Time.makeDateSimpleStampString();
            PersistenceObjectStore targetStore = BrooklynPersistenceUtils.newPersistenceObjectStore((ManagementContext)this.mgmt(), null, (String)("tmp/web-persistence-" + label + "-" + Identifiers.makeRandomId((int)4)));
            dir = ((FileBasedObjectStore)targetStore).getBaseDir();
            Os.deleteOnExitEmptyParentsUpTo((File)dir.getParentFile(), (File)dir.getParentFile());
            BrooklynPersistenceUtils.writeMemento((ManagementContext)this.mgmt(), (PersistenceObjectStore)targetStore, (MementoCopyMode)preferredOrigin);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ArchiveBuilder.zip().addDirContentsAt(((FileBasedObjectStore)targetStore).getBaseDir(), ((FileBasedObjectStore)targetStore).getBaseDir().getName()).stream((OutputStream)baos);
            Os.deleteRecursively((File)dir);
            String filename = "brooklyn-state-" + label + ".zip";
            return Response.ok((Object)baos.toByteArray(), (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE).header("Content-Disposition", (Object)("attachment; filename = " + filename)).build();
        }
        catch (Exception e) {
            log.warn("Unable to serve persistence data (rethrowing): " + e, (Throwable)e);
            if (dir != null) {
                try {
                    Os.deleteRecursively(dir);
                }
                catch (Exception e2) {
                    log.warn("Ignoring error deleting '" + dir + "' after another error, throwing original error (" + e + "); ignored error deleting is: " + e2);
                }
            }
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

