/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.jclouds.googlecomputeengine.compute.functions.Resources;
import org.jclouds.googlecomputeengine.domain.Operation;

public final class AtomicOperationDone
implements Predicate<AtomicReference<Operation>> {
    private final Resources resources;

    @Inject
    AtomicOperationDone(Resources resources) {
        this.resources = resources;
    }

    public boolean apply(AtomicReference<Operation> input) {
        Preconditions.checkNotNull((Object)input.get(), (Object)"operation");
        Operation current = this.resources.operation(input.get().selfLink());
        input.set(current);
        Preconditions.checkState((boolean)current.error().errors().isEmpty(), (String)"Task ended in error %s", (Object[])new Object[]{current});
        switch (current.status()) {
            case DONE: {
                return true;
            }
        }
        return false;
    }
}

