/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist;

import com.google.common.base.Preconditions;
import java.util.ConcurrentModificationException;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoPersister;
import org.apache.brooklyn.core.mgmt.persist.MementoSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingMementoSerializer<T>
implements MementoSerializer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RetryingMementoSerializer.class);
    private final MementoSerializer<T> delegate;
    private final int maxAttempts;

    public RetryingMementoSerializer(MementoSerializer<T> delegate, int maxAttempts) {
        this.delegate = (MementoSerializer)Preconditions.checkNotNull(delegate, (Object)"delegate");
        this.maxAttempts = maxAttempts;
        if (maxAttempts < 1) {
            throw new IllegalArgumentException("Max attempts must be at least 1, but was " + maxAttempts);
        }
    }

    @Override
    public String toString(T memento) {
        RuntimeException lastException = null;
        int attempt = 0;
        while (true) {
            ++attempt;
            try {
                String result = this.delegate.toString(memento);
                if (attempt > 1) {
                    LOG.info("Success following previous serialization error");
                }
                return result;
            }
            catch (RuntimeException e) {
                if (e.toString().contains(ConcurrentModificationException.class.getSimpleName())) {
                    LOG.warn("Error serializing memento (attempt " + attempt + " of " + this.maxAttempts + ") for " + memento + "; appears to be concurrent modification which is not unusual if other values are changing, and should be fixed after retry");
                } else {
                    LOG.warn("Error serializing memento (attempt " + attempt + " of " + this.maxAttempts + ") for " + memento + "; expected sometimes if attribute value modified", (Throwable)e);
                }
                lastException = e;
                if (attempt < this.maxAttempts) continue;
                throw lastException;
            }
            break;
        }
    }

    @Override
    public T fromString(String string) {
        if (string == null) {
            return null;
        }
        RuntimeException lastException = null;
        int attempt = 0;
        while (true) {
            ++attempt;
            try {
                T result = this.delegate.fromString(string);
                if (attempt > 1) {
                    LOG.info("Success following previous deserialization error, got: " + result);
                }
                return result;
            }
            catch (RuntimeException e) {
                LOG.warn("Error deserializing memento (attempt " + attempt + " of " + this.maxAttempts + "): " + e, (Throwable)e);
                if (attempt == 1) {
                    LOG.debug("Memento which was not deserialized is:\n" + string);
                }
                lastException = e;
                if (attempt < this.maxAttempts) continue;
                throw lastException;
            }
            break;
        }
    }

    @Override
    public void setLookupContext(BrooklynMementoPersister.LookupContext lookupContext) {
        this.delegate.setLookupContext(lookupContext);
    }

    @Override
    public void unsetLookupContext() {
        this.delegate.unsetLookupContext();
    }
}

