/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity.lifecycle;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.text.StringFunctions;

public enum Lifecycle {
    CREATED,
    STARTING,
    RUNNING,
    STOPPING,
    STOPPED,
    DESTROYED,
    ON_FIRE;


    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
    }

    public String toString() {
        return this.value();
    }

    public static Lifecycle fromValue(String v) {
        try {
            return Lifecycle.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, v));
        }
        catch (IllegalArgumentException iae) {
            return ON_FIRE;
        }
    }

    static {
        TypeCoercions.registerAdapter(String.class, Transition.class, new TransitionCoalesceFunction());
        RendererHints.register(Transition.class, RendererHints.displayValue(StringFunctions.toStringFunction()));
    }

    protected static class TransitionCoalesceFunction
    implements Function<String, Transition> {
        private static final Pattern TRANSITION_PATTERN = Pattern.compile("^([\\w-]+)\\s+@\\s+(\\d+).*");

        protected TransitionCoalesceFunction() {
        }

        public Transition apply(String input) {
            if (input != null) {
                Matcher m = TRANSITION_PATTERN.matcher(input);
                if (m.matches()) {
                    Lifecycle state = Lifecycle.valueOf(m.group(1).toUpperCase().replace('-', '_'));
                    long time = Long.parseLong(m.group(2));
                    return new Transition(state, new Date(time));
                }
                throw new IllegalStateException("Serialized Lifecycle.Transition can't be parsed: " + input);
            }
            return null;
        }
    }

    public static class Transition
    implements Serializable {
        private static final long serialVersionUID = 603419184398753502L;
        final Lifecycle state;
        final long timestampUtc;

        public Transition(Lifecycle state, Date timestamp) {
            this.state = (Lifecycle)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
            this.timestampUtc = ((Date)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp")).getTime();
        }

        public Lifecycle getState() {
            return this.state;
        }

        public Date getTimestamp() {
            return new Date(this.timestampUtc);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.state, this.timestampUtc});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Transition)) {
                return false;
            }
            if (!this.state.equals((Object)((Transition)obj).getState())) {
                return false;
            }
            return this.timestampUtc == ((Transition)obj).timestampUtc;
        }

        public String toString() {
            return (Object)((Object)this.state) + " @ " + this.timestampUtc + " / " + new Date(this.timestampUtc);
        }
    }
}

