/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.ProvisioningLocation;
import org.apache.brooklyn.api.mgmt.AccessController;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.core.BrooklynLogging;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.internal.storage.BrooklynStorage;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.internal.BrooklynObjectManagementMode;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.internal.LocationManagerInternal;
import org.apache.brooklyn.core.mgmt.internal.ManagementTransitionMode;
import org.apache.brooklyn.core.objs.proxy.InternalLocationFactory;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalLocationManager
implements LocationManagerInternal {
    private static final Logger log = LoggerFactory.getLogger(LocalLocationManager.class);
    private final LocalManagementContext managementContext;
    private final InternalLocationFactory locationFactory;
    protected final Map<String, Location> locationsById = Maps.newLinkedHashMap();
    private final Map<String, Location> preRegisteredLocationsById = Maps.newLinkedHashMap();
    protected final Map<String, ManagementTransitionMode> locationModesById = Maps.newLinkedHashMap();
    private final BrooklynStorage storage;
    private Map<String, String> locationTypes;
    private static AtomicLong LOCATION_CNT = new AtomicLong(0L);

    public LocalLocationManager(LocalManagementContext managementContext) {
        this.managementContext = (LocalManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
        this.locationFactory = new InternalLocationFactory(managementContext);
        this.storage = managementContext.getStorage();
        this.locationTypes = this.storage.getMap("locations");
    }

    public InternalLocationFactory getLocationFactory() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        return this.locationFactory;
    }

    public <T extends Location> T createLocation(LocationSpec<T> spec) {
        try {
            boolean createUnmanaged = (Boolean)ConfigBag.coerceFirstNonNullKeyValue(CREATE_UNMANAGED, spec.getConfig().get(CREATE_UNMANAGED), spec.getFlags().get(CREATE_UNMANAGED.getName()));
            if (createUnmanaged) {
                spec.removeConfig(CREATE_UNMANAGED);
            }
            T loc = this.locationFactory.createLocation(spec);
            if (!createUnmanaged) {
                this.manage((Location)loc);
            } else {
                Location parent = loc.getParent();
                if (parent != null) {
                    ((AbstractLocation)parent).removeChild((Location)loc);
                }
                this.preRegisteredLocationsById.remove(loc.getId());
            }
            return loc;
        }
        catch (Throwable e) {
            log.warn("Failed to create location using spec " + spec + " (rethrowing)", e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public <T extends Location> T createLocation(Map<?, ?> config, Class<T> type) {
        return this.createLocation(LocationSpec.create(config, type));
    }

    public synchronized Collection<Location> getLocations() {
        return ImmutableList.copyOf(this.locationsById.values());
    }

    public Collection<String> getLocationIds() {
        return ImmutableList.copyOf(this.locationsById.keySet());
    }

    public synchronized Location getLocation(String id) {
        return this.locationsById.get(id);
    }

    public synchronized Location getLocationEvenIfPreManaged(String id) {
        Location result = this.locationsById.get(id);
        if (result == null) {
            result = this.preRegisteredLocationsById.get(id);
        }
        return result;
    }

    public boolean isManaged(Location loc) {
        return this.isRunning() && loc != null && this.getLocation(loc.getId()) != null;
    }

    synchronized boolean isPreRegistered(Location loc) {
        return this.preRegisteredLocationsById.containsKey(loc.getId());
    }

    public boolean isKnownLocationId(String id) {
        return this.preRegisteredLocationsById.containsKey(id) || this.locationsById.containsKey(id);
    }

    synchronized void prePreManage(Location loc) {
        if (this.isPreRegistered(loc)) {
            if (log.isTraceEnabled()) {
                log.trace("" + this + " redundant call to pre-pre-manage location " + loc + "; skipping", (Throwable)new Exception("source of duplicate pre-pre-manage of " + loc));
            }
            return;
        }
        this.preRegisteredLocationsById.put(loc.getId(), loc);
    }

    @Override
    public ManagementTransitionMode getLastManagementTransitionMode(String itemId) {
        return this.locationModesById.get(itemId);
    }

    @Override
    public void setManagementTransitionMode(Location item, ManagementTransitionMode mode) {
        this.locationModesById.put(item.getId(), mode);
    }

    public Location manage(Location loc) {
        if (this.isManaged(loc)) {
            return loc;
        }
        Location parent = loc.getParent();
        if (parent != null && !this.managementContext.getLocationManager().isManaged(parent)) {
            log.warn("Parent location " + parent + " of " + loc + " is not managed; attempting to manage it (in future this may be disallowed)");
            return this.manage(parent);
        }
        return this.manageRecursive(loc, ManagementTransitionMode.guessing(BrooklynObjectManagementMode.NONEXISTENT, BrooklynObjectManagementMode.MANAGED_PRIMARY));
    }

    @Override
    public void manageRebindedRoot(Location item) {
        ManagementTransitionMode mode = this.getLastManagementTransitionMode(item.getId());
        Preconditions.checkNotNull((Object)mode, (String)"Mode not set for rebinding %s", (Object)item);
        this.manageRecursive(item, mode);
    }

    protected void checkManagementAllowed(Location item) {
        AccessController.Response access = this.managementContext.getAccessController().canManageLocation(item);
        if (!access.isAllowed()) {
            throw new IllegalStateException("Access controller forbids management of " + item + ": " + access.getMsg());
        }
    }

    protected Location manageRecursive(Location loc, final ManagementTransitionMode initialMode) {
        AccessController.Response access = this.managementContext.getAccessController().canManageLocation(loc);
        if (!access.isAllowed()) {
            throw new IllegalStateException("Access controller forbids management of " + loc + ": " + access.getMsg());
        }
        long count = LOCATION_CNT.incrementAndGet();
        if (log.isDebugEnabled()) {
            BrooklynLogging.LoggingLevel level;
            String msg = "Managing location " + loc + " (" + initialMode + "), from " + Tasks.current() + " / " + Entitlements.getEntitlementContext();
            BrooklynLogging.LoggingLevel loggingLevel = level = !initialMode.wasNotLoaded() || initialMode.isReadOnly() ? BrooklynLogging.LoggingLevel.TRACE : BrooklynLogging.LoggingLevel.DEBUG;
            if (count % 100L == 0L) {
                BrooklynLogging.log(log, level, msg, new Exception("Informational stack trace of call to manage location " + loc + " (" + count + " calls; " + this.getLocations().size() + " currently managed)"));
            } else {
                BrooklynLogging.log(log, level, msg, new Object[0]);
            }
        }
        this.recursively(loc, new Predicate<AbstractLocation>(){

            public boolean apply(AbstractLocation it) {
                ManagementTransitionMode mode = LocalLocationManager.this.getLastManagementTransitionMode(it.getId());
                if (mode == null) {
                    mode = initialMode;
                    LocalLocationManager.this.setManagementTransitionMode(it, mode);
                }
                if (it.isManaged() && mode.wasNotLoaded()) {
                    return false;
                }
                boolean result = LocalLocationManager.this.manageNonRecursive(it, mode);
                if (result) {
                    it.setManagementContext(LocalLocationManager.this.managementContext);
                    if (mode.isPrimary()) {
                        it.onManagementStarted();
                        if (mode.isCreating()) {
                            LocalLocationManager.this.recordLocationEvent(it, Lifecycle.CREATED);
                        }
                    }
                    LocalLocationManager.this.managementContext.getRebindManager().getChangeListener().onManaged((BrooklynObject)it);
                }
                return result;
            }
        });
        return loc;
    }

    public void unmanage(Location loc) {
        this.unmanage(loc, ManagementTransitionMode.guessing(BrooklynObjectManagementMode.MANAGED_PRIMARY, BrooklynObjectManagementMode.NONEXISTENT));
    }

    @Override
    public void unmanage(Location loc, ManagementTransitionMode mode) {
        this.unmanage(loc, mode, false);
    }

    private void unmanage(final Location loc, final ManagementTransitionMode mode, boolean hasBeenReplaced) {
        if (this.shouldSkipUnmanagement(loc)) {
            return;
        }
        if (hasBeenReplaced) {
            if (!mode.wasReadOnly()) {
                if (!mode.wasPrimary()) {
                    log.warn("Unexpected mode " + mode + " for unmanage-replace " + loc + " (applying anyway)");
                }
                this.managementContext.getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)loc);
                if (this.managementContext.gc != null) {
                    this.managementContext.gc.onUnmanaged(loc);
                }
            }
            return;
        }
        if (mode.wasPrimary() && mode.isReadOnly() || mode.wasReadOnly() && mode.isNoLongerLoaded()) {
            if (mode.isReadOnly() && mode.wasPrimary()) {
                log.debug("Unmanaging on demotion: " + loc + " (" + mode + ")");
            }
            this.unmanageNonRecursiveRemoveFromRecords(loc, mode);
            this.managementContext.getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)loc);
            if (this.managementContext.gc != null) {
                this.managementContext.gc.onUnmanaged(loc);
            }
            this.unmanageNonRecursiveClearItsFields(loc, mode);
        } else if (mode.isNoLongerLoaded()) {
            this.recursively(loc, new Predicate<AbstractLocation>(){

                public boolean apply(AbstractLocation it) {
                    if (LocalLocationManager.this.shouldSkipUnmanagement(it)) {
                        return false;
                    }
                    boolean unmanaged = LocalLocationManager.this.unmanageNonRecursiveRemoveFromRecords(it, mode);
                    if (unmanaged) {
                        if (mode.wasPrimary()) {
                            it.onManagementStopped();
                        }
                        LocalLocationManager.this.managementContext.getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)it);
                        if (mode.isDestroying()) {
                            LocalLocationManager.this.recordLocationEvent(it, Lifecycle.DESTROYED);
                        }
                        if (((LocalLocationManager)LocalLocationManager.this).managementContext.gc != null) {
                            ((LocalLocationManager)LocalLocationManager.this).managementContext.gc.onUnmanaged(it);
                        }
                    }
                    LocalLocationManager.this.unmanageNonRecursiveClearItsFields(loc, mode);
                    return unmanaged;
                }
            });
        } else {
            log.warn("Invalid mode for unmanage: " + mode + " on " + loc + " (ignoring)");
        }
        if (loc instanceof Closeable) {
            Streams.closeQuietly((Closeable)((Closeable)loc));
        }
        this.locationsById.remove(loc.getId());
        this.preRegisteredLocationsById.remove(loc.getId());
        this.locationModesById.remove(loc.getId());
        this.locationTypes.remove(loc.getId());
    }

    private void recordLocationEvent(LocationInternal loc, Lifecycle state) {
        try {
            this.managementContext.getUsageManager().recordLocationEvent(loc, state);
        }
        catch (RuntimeInterruptedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            log.warn("Failed to store location lifecycle event for " + loc + " (ignoring)", (Throwable)e);
        }
    }

    private void recursively(Location e, Predicate<AbstractLocation> action) {
        boolean success = action.apply((Object)((AbstractLocation)e));
        if (!success) {
            return;
        }
        for (Location child : e.getChildren()) {
            this.recursively(child, action);
        }
    }

    private synchronized boolean manageNonRecursive(Location loc, ManagementTransitionMode mode) {
        Location old = this.locationsById.put(loc.getId(), loc);
        this.preRegisteredLocationsById.remove(loc.getId());
        this.locationTypes.put(loc.getId(), loc.getClass().getName());
        if (old != null && mode.wasNotLoaded()) {
            if (!old.equals(loc)) {
                throw new IllegalStateException("call to manage location " + loc + " but different location " + old + " already known under that id at " + this);
            }
            log.warn("{} redundant call to start management of location {}", (Object)this, (Object)loc);
            return false;
        }
        if (old != null && old != loc) {
            this.unmanage(old, mode, true);
        }
        return true;
    }

    private synchronized void unmanageNonRecursiveClearItsFields(Location loc, ManagementTransitionMode mode) {
        if (mode.isDestroying()) {
            ((AbstractLocation)loc).setParent(null, true);
            Location parent = ((AbstractLocation)loc).getParent();
            if (parent instanceof ProvisioningLocation) {
                try {
                    ((ProvisioningLocation)parent).release(loc);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    log.debug("Error releasing " + loc + " in its parent " + parent + ": " + e);
                }
            }
        } else {
            ((AbstractLocation)loc).setParent(null, false);
        }
        ((AbstractLocation)loc).config().removeAllLocalConfig();
    }

    private synchronized boolean unmanageNonRecursiveRemoveFromRecords(Location loc, ManagementTransitionMode mode) {
        Location old = this.locationsById.remove(loc.getId());
        this.locationTypes.remove(loc.getId());
        this.locationModesById.remove(loc.getId());
        if (old == null) {
            log.warn("{} call to stop management of unknown location (already unmanaged?) {} ({}), mode {}; ignoring", new Object[]{this, loc, loc.getId(), mode});
            return false;
        }
        if (!old.equals(loc)) {
            log.error("{} call to stop management of location {} removed different location {}; ignoring", new Object[]{this, loc, old});
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("{} stopped management of location {} ({}), mode {}", new Object[]{this, loc, loc.getId(), mode});
        }
        return true;
    }

    private boolean shouldSkipUnmanagement(Location loc) {
        if (loc == null) {
            log.warn("" + this + " call to unmanage null location; skipping", (Throwable)new IllegalStateException("source of null unmanagement call to " + this));
            return true;
        }
        if (!this.isManaged(loc)) {
            log.warn("{} call to stop management of unknown location (already unmanaged?) {}; skipping, and all descendants", (Object)this, (Object)loc);
            return true;
        }
        return false;
    }

    private boolean isRunning() {
        return this.managementContext.isRunning();
    }
}

