/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.network;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.net.HostAndPort;
import com.google.common.reflect.TypeToken;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.access.PortForwardManager;
import org.apache.brooklyn.core.network.AbstractOnNetworkEnricher;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Public Network Advertiser", description="Advertises entity's public mapped ports. This can be used with sensors of type URI, HostAndPort or plain integer port values")
@Beta
public class OnPublicNetworkEnricher
extends AbstractOnNetworkEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(OnPublicNetworkEnricher.class);
    public static ConfigKey<Function<? super String, String>> SENSOR_NAME_CONVERTER = ConfigKeys.newConfigKeyWithDefault(AbstractOnNetworkEnricher.SENSOR_NAME_CONVERTER, new AbstractOnNetworkEnricher.SensorNameConverter("public"));
    public static final ConfigKey<PortForwardManager> PORT_FORWARD_MANAGER = ConfigKeys.newConfigKey(PortForwardManager.class, "portForwardManager", "The PortForwardManager storing the port-mappings; if null, the global instance will be used");
    public static final ConfigKey<AttributeSensor<String>> ADDRESS_SENSOR = ConfigKeys.newConfigKey(new TypeToken<AttributeSensor<String>>(){}, "addressSensor", "The sensor to use to retrieve the entity's public address; if null (default), then use the PortForwardManager instead");
    protected PortForwardManager.AssociationListener pfmListener;

    @Override
    public void setEntity(final EntityLocal entity) {
        super.setEntity(entity);
        this.pfmListener = new PortForwardManager.AssociationListener(){

            @Override
            public void onAssociationCreated(PortForwardManager.AssociationMetadata metadata) {
                Maybe<MachineLocation> machine = OnPublicNetworkEnricher.this.getMachine();
                if (!machine.isPresent() || !((MachineLocation)machine.get()).equals(metadata.getLocation())) {
                    return;
                }
                LOG.debug("{} attempting transformations, triggered by port-association {}, with machine {} of entity {}", new Object[]{OnPublicNetworkEnricher.this, metadata, machine.get(), entity});
                OnPublicNetworkEnricher.this.tryTransformAll();
            }

            @Override
            public void onAssociationDeleted(PortForwardManager.AssociationMetadata metadata) {
            }
        };
        this.getPortForwardManager().addAssociationListener(this.pfmListener, (Predicate<? super PortForwardManager.AssociationMetadata>)Predicates.alwaysTrue());
    }

    @Override
    public void destroy() {
        try {
            if (this.pfmListener != null) {
                this.getPortForwardManager().removeAssociationListener(this.pfmListener);
            }
        }
        finally {
            super.destroy();
        }
    }

    @Override
    protected Optional<HostAndPort> getMappedEndpoint(Entity source, MachineLocation machine, int port) {
        AttributeSensor sensor = (AttributeSensor)this.config().get(ADDRESS_SENSOR);
        if (sensor == null) {
            HostAndPort publicTarget = this.getPortForwardManager().lookup((Location)machine, port);
            return Optional.fromNullable((Object)publicTarget);
        }
        String address = (String)source.sensors().get(sensor);
        if (Strings.isNonBlank((CharSequence)address)) {
            return Optional.of((Object)HostAndPort.fromParts((String)address, (int)port));
        }
        return Optional.absent();
    }

    protected PortForwardManager getPortForwardManager() {
        PortForwardManager portForwardManager = (PortForwardManager)this.config().get(PORT_FORWARD_MANAGER);
        if (portForwardManager == null) {
            portForwardManager = (PortForwardManager)this.getManagementContext().getLocationRegistry().getLocationManaged("portForwardManager(scope=global)");
        }
        return portForwardManager;
    }
}

