/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor.ssh;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.sensor.AbstractAddTriggerableSensor;
import org.apache.brooklyn.feed.AbstractCommandFeed;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshFeed;
import org.apache.brooklyn.feed.ssh.SshValueFunctions;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.StringFunctions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.yaml.Yamls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class SshCommandSensor<T>
extends AbstractAddTriggerableSensor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SshCommandSensor.class);
    public static final ConfigKey<String> SENSOR_COMMAND = ConfigKeys.newStringConfigKey("command", "SSH command to execute for sensor");
    public static final ConfigKey<String> SENSOR_COMMAND_URL = ConfigKeys.newStringConfigKey("commandUrl", "Remote SSH command to execute for sensor (takes precedence over command)");
    public static final ConfigKey<String> SENSOR_EXECUTION_DIR = ConfigKeys.newStringConfigKey("executionDir", "Directory where the command should run; if not supplied, executes in the entity's run dir (or home dir if no run dir is defined); use '~' to always execute in the home dir, or 'custom-feed/' to execute in a custom-feed dir relative to the run dir; not compatible with commandUrl");
    public static final ConfigKey<Object> VALUE_ON_ERROR = ConfigKeys.newConfigKey(Object.class, "value.on.error", "Value to be used if an error occurs whilst executing the ssh command", null);
    public static final MapConfigKey<Object> SENSOR_SHELL_ENVIRONMENT = BrooklynConfigKeys.SHELL_ENVIRONMENT;
    public static final ConfigKey<String> FORMAT = ConfigKeys.newStringConfigKey("format", "Format to expect for the output; default to auto which will attempt a yaml/json parse for complex types, falling back to string, then coerce; other options are just 'string' (previous default) or 'yaml'", "auto");
    public static final ConfigKey<Boolean> LAST_YAML_DOCUMENT = ConfigKeys.newBooleanConfigKey("useLastYaml", "Whether to trim the output ignoring everything up to and before the last `---` line if present when expecting yaml; useful if the script has quite a lot of output which should be ignored prior, with the value to be used for the sensor output last; default true (ignored if format is 'string')", true);
    private final AtomicBoolean commandUrlInstalled = new AtomicBoolean(false);
    private String command;
    private String executionDir;
    private Map<String, Object> sensorEnv;

    public SshCommandSensor() {
    }

    public SshCommandSensor(ConfigBag params) {
        super(params);
    }

    @Override
    public void apply(EntityLocal entity) {
        ConfigBag params = this.initParams();
        this.apply(entity, params);
    }

    private void apply(final EntityLocal entity, ConfigBag params) {
        final AttributeSensor sensor = this.addSensor(entity);
        String name = (String)this.initParam(SENSOR_NAME);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding SSH sensor {} to {}", (Object)name, (Object)entity);
        }
        EnvSupplier envSupplier = new EnvSupplier((Entity)entity, params);
        CommandSupplier commandSupplier = new CommandSupplier((Entity)entity, params);
        CommandPollConfig pollConfig = (CommandPollConfig)((CommandPollConfig)((CommandPollConfig)new CommandPollConfig(sensor).env(envSupplier).command(commandSupplier).checkSuccess(SshValueFunctions.exitStatusEquals(0))).onFailureOrException(Functions.constant((Object)params.get(VALUE_ON_ERROR)))).onSuccess(Functionals.chain(SshValueFunctions.stdout(), new CoerceOutputFunction(sensor.getTypeToken(), this.initParam(FORMAT), this.initParam(LAST_YAML_DOCUMENT))));
        this.standardPollConfig((Entity)entity, this.initParams(), pollConfig);
        AbstractCommandFeed.Builder feedBuilder = ((SshFeed.Builder)((SshFeed.Builder)((SshFeed.Builder)SshFeed.builder().name("SSH Sensor Feed: " + (String)this.initParam(SENSOR_NAME))).entity((Entity)entity)).onlyIfServiceUp((Boolean)Maybe.ofDisallowingNull(EntityInitializers.resolve(params, ONLY_IF_SERVICE_UP)).or((Object)true))).poll(pollConfig);
        String commandUrl = EntityInitializers.resolve(this.initParams(), SENSOR_COMMAND_URL);
        if (commandUrl != null) {
            feedBuilder.commandUrlToInstallAndRun(commandUrl);
            if (commandSupplier.rawSensorCommand != null || commandSupplier.rawSensorExecDir != null) {
                throw new IllegalArgumentException("commandUrl is not compatible with command or executionDir");
            }
        }
        SshFeed feed = (SshFeed)feedBuilder.build();
        entity.addFeed((Feed)feed);
        new Supplier<Map<String, String>>(){

            public Map<String, String> get() {
                if (entity == null) {
                    return ImmutableMap.of();
                }
                Object env = MutableMap.copyOf((Map)((Map)entity.getConfig(BrooklynConfigKeys.SHELL_ENVIRONMENT)));
                Map sensorEnv = (Map)SshCommandSensor.this.initParams().get(SENSOR_SHELL_ENVIRONMENT);
                if (sensorEnv != null) {
                    env.putAll(sensorEnv);
                }
                try {
                    env = (Map)Tasks.resolveDeepValueWithoutCoercion(env, ((EntityInternal)entity).getExecutionContext());
                }
                catch (InterruptedException | ExecutionException e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                }
                ShellEnvironmentSerializer serializer = new ShellEnvironmentSerializer(((EntityInternal)entity).getManagementContext());
                return serializer.serialize((Map<?, ?>)env);
            }
        };
        new Supplier<String>(){

            public String get() {
                String command = (String)Preconditions.checkNotNull((Object)EntityInitializers.resolve(SshCommandSensor.this.initParams(), SENSOR_COMMAND));
                String dir = EntityInitializers.resolve(SshCommandSensor.this.initParams(), SENSOR_EXECUTION_DIR);
                return SshCommandSensor.makeCommandExecutingInDirectory(command, dir, (Entity)entity);
            }
        };
        new Function<String, T>(){

            public T apply(String input) {
                return TypeCoercions.coerce((Object)Strings.trimEnd((String)input), sensor.getType());
            }
        };
    }

    @Beta
    public static String makeCommandExecutingInDirectory(String command, String executionDir, Entity entity) {
        String finalCommand = command;
        String execDir = executionDir;
        if (Strings.isBlank((CharSequence)execDir)) {
            String string = execDir = entity != null ? (String)entity.getAttribute(BrooklynConfigKeys.RUN_DIR) : null;
            if (Strings.isBlank((CharSequence)execDir)) {
                execDir = "~";
            }
        } else if (!Os.isAbsolutish((String)execDir)) {
            String runDir;
            String string = runDir = entity != null ? (String)entity.getAttribute(BrooklynConfigKeys.RUN_DIR) : null;
            if (!Strings.isBlank((CharSequence)runDir)) {
                execDir = Os.mergePaths((String[])new String[]{runDir, execDir});
            }
        }
        if (!"~".equals(execDir)) {
            finalCommand = "mkdir -p '" + execDir + "' && cd '" + execDir + "' && " + finalCommand;
        }
        return finalCommand;
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.initFromConfigBag(ConfigBag.newInstance().putIfAbsentAndNotNull(SENSOR_COMMAND, this.command).putIfAbsentAndNotNull(SENSOR_EXECUTION_DIR, this.executionDir).putIfAbsentAndNotNull(SENSOR_SHELL_ENVIRONMENT, this.sensorEnv));
        this.command = null;
        this.executionDir = null;
        this.sensorEnv = null;
        return this;
    }

    private static class CommandSupplier
    implements Supplier<String> {
        private final Entity entity;
        private final Object rawSensorCommand;
        private final Object rawSensorExecDir;

        CommandSupplier(Entity entity, ConfigBag params) {
            this.entity = entity;
            this.rawSensorCommand = params.getAllConfigRaw().get(SENSOR_COMMAND.getName());
            this.rawSensorExecDir = params.getAllConfigRaw().get(SENSOR_EXECUTION_DIR.getName());
        }

        public String get() {
            ConfigBag params = ConfigBag.newInstance();
            if (this.rawSensorCommand != null) {
                params.putStringKey(SENSOR_COMMAND.getName(), this.rawSensorCommand);
            }
            if (this.rawSensorExecDir != null) {
                params.putStringKey(SENSOR_EXECUTION_DIR.getName(), this.rawSensorExecDir);
            }
            String command = (String)Preconditions.checkNotNull((Object)EntityInitializers.resolve(params, SENSOR_COMMAND));
            String dir = EntityInitializers.resolve(params, SENSOR_EXECUTION_DIR);
            return SshCommandSensor.makeCommandExecutingInDirectory(command, dir, this.entity);
        }
    }

    private static class EnvSupplier
    implements Supplier<Map<String, String>> {
        private final Entity entity;
        private final Object rawSensorShellEnv;

        EnvSupplier(Entity entity, ConfigBag params) {
            this.entity = entity;
            this.rawSensorShellEnv = params.getAllConfigRaw().getOrDefault(SENSOR_SHELL_ENVIRONMENT.getName(), SENSOR_SHELL_ENVIRONMENT.getDefaultValue());
        }

        public Map<String, String> get() {
            if (this.entity == null) {
                return ImmutableMap.of();
            }
            Object env = MutableMap.copyOf((Map)((Map)this.entity.getConfig(BrooklynConfigKeys.SHELL_ENVIRONMENT)));
            if (this.rawSensorShellEnv != null) {
                env.putAll(TypeCoercions.coerce(this.rawSensorShellEnv, new TypeToken<Map<String, Object>>(){}));
            }
            try {
                env = (Map)Tasks.resolveDeepValueWithoutCoercion(env, ((EntityInternal)this.entity).getExecutionContext());
            }
            catch (InterruptedException | ExecutionException e) {
                Exceptions.propagateIfFatal((Throwable)e);
            }
            ShellEnvironmentSerializer serializer = new ShellEnvironmentSerializer(((EntityInternal)this.entity).getManagementContext());
            return serializer.serialize((Map<?, ?>)env);
        }
    }

    @Beta
    public static class CoerceOutputFunction<T>
    implements Function<String, T> {
        final TypeToken<T> typeToken;
        final String format;
        final Boolean useLastYamlDocument;

        public CoerceOutputFunction(TypeToken<T> typeToken, String format, Boolean useLastYamlDocument) {
            this.typeToken = typeToken;
            this.format = format;
            this.useLastYamlDocument = useLastYamlDocument;
        }

        public T apply(String input) {
            Maybe<T> result1;
            block14: {
                boolean doString;
                block13: {
                    boolean doYaml = !"string".equalsIgnoreCase(this.format);
                    boolean bl = doString = !"yaml".equalsIgnoreCase(this.format);
                    if ("auto".equalsIgnoreCase(this.format)) {
                        if (String.class.equals((Object)this.typeToken.getRawType())) {
                            doYaml = false;
                        } else if (Boxing.isPrimitiveOrBoxedClass((Class)this.typeToken.getRawType()) && (Boolean.FALSE.equals(this.useLastYamlDocument) || input == null || !input.contains("---"))) {
                            doYaml = false;
                        }
                    }
                    result1 = null;
                    if (doYaml) {
                        try {
                            Object yamlInO;
                            String yamlInS = input;
                            if (!Boolean.FALSE.equals(this.useLastYamlDocument)) {
                                yamlInS = (String)Yamls.lastDocumentFunction().apply((Object)yamlInS);
                            }
                            if ((result1 = TypeCoercions.tryCoerce(yamlInO = Iterables.getOnlyElement((Iterable)Yamls.parseAll((String)yamlInS)), this.typeToken)).isPresent()) {
                                doString = false;
                            }
                        }
                        catch (Exception e) {
                            if (result1 != null) break block13;
                            result1 = Maybe.absent((Throwable)e);
                        }
                    }
                }
                if (doString) {
                    try {
                        return (T)Functionals.chain((Function)StringFunctions.trimEnd(), TypeCoercions.function(this.typeToken.getRawType())).apply((Object)input);
                    }
                    catch (Exception e) {
                        if (result1 != null) break block14;
                        result1 = Maybe.absent((Throwable)e);
                    }
                }
            }
            if (result1.isAbsent() && Strings.isNonBlank((CharSequence)input)) {
                LOG.warn("Unable to convert to " + this.typeToken + ": " + Maybe.Absent.getException(result1) + "\n" + input);
            }
            return (T)result1.get();
        }
    }
}

