/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.appmodel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Optional;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.mgmt.EntityManagementUtils;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.appmodel.HasBlueprintWorkflowStep;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployApplicationWorkflowStep
extends WorkflowStepDefinition
implements HasBlueprintWorkflowStep {
    private static final Logger LOG = LoggerFactory.getLogger(DeployApplicationWorkflowStep.class);
    public static final String SHORTHAND = "[ ${type} ]";
    public static final ConfigKey<String> FORMAT = ConfigKeys.newStringConfigKey("format");
    public static final ConfigKey<StartMode> START = ConfigKeys.newConfigKey(StartMode.class, "start", "Default 'async'");

    @Override
    public Logger logger() {
        return LOG;
    }

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        super.validateStep(mgmt, workflow);
        this.validateStepBlueprint(mgmt, workflow);
    }

    @Override
    protected String getStepState(WorkflowStepInstanceExecutionContext context) {
        return (String)super.getStepState(context);
    }

    void setStepState(WorkflowStepInstanceExecutionContext context, String entityId) {
        context.setStepState(entityId, true);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        Object blueprint = this.resolveBlueprint(context, () -> "services: [ { type: " + StringEscapes.JavaStringEscapes.wrapJavaString((String)((String)context.getInput(TYPE))) + " } ]", null, null);
        String createdAppId = this.getStepState(context);
        Application app = null;
        if (Strings.isNonBlank((CharSequence)createdAppId)) {
            app = (Application)context.getManagementContext().getEntityManager().getEntity(createdAppId);
            if (app != null) {
                context.setOutput(MutableMap.of((Object)"app", (Object)app));
            }
        } else {
            createdAppId = Identifiers.makeRandomLowercaseId((int)10);
            this.setStepState(context, createdAppId);
        }
        if (app == null) {
            EntitySpec<? extends Application> spec;
            try {
                spec = EntityManagementUtils.createEntitySpecForApplication(context.getManagementContext(), context.getInput(FORMAT), blueprint instanceof String ? (String)blueprint : BeanWithTypeUtils.newYamlMapper(context.getManagementContext(), false, null, false).writeValueAsString(blueprint));
            }
            catch (JsonProcessingException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            app = EntityManagementUtils.createUnstarted(context.getManagementContext(), spec, (Optional<String>)Optional.of((Object)createdAppId));
            context.setOutput(MutableMap.of((Object)"app", (Object)app));
            StartMode start = context.getInput(START);
            if (start == null) {
                start = StartMode.ASYNC;
            }
            if (start != StartMode.DISABLED) {
                EntityManagementUtils.CreationResult<Application, Void> startTask = EntityManagementUtils.start(app);
                if (start == StartMode.SYNC) {
                    startTask.task().getUnchecked();
                }
            }
        }
        return context.getOutput();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }

    static enum StartMode {
        SYNC,
        ASYNC,
        DISABLED;

    }
}

