/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.kafka;

import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.entity.messaging.MessageBroker;
import org.apache.brooklyn.entity.messaging.kafka.KafkaBroker;
import org.apache.brooklyn.entity.messaging.kafka.KafkaBrokerDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperNode;
import org.apache.brooklyn.feed.jmx.JmxAttributePollConfig;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.apache.brooklyn.feed.jmx.JmxHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBrokerImpl
extends SoftwareProcessImpl
implements MessageBroker,
KafkaBroker {
    private static final Logger log = LoggerFactory.getLogger(KafkaBrokerImpl.class);
    private static final ObjectName SOCKET_SERVER_STATS_MBEAN = JmxHelper.createObjectName((String)"kafka:type=kafka.SocketServerStats");
    private volatile JmxFeed jmxFeed;

    public void init() {
        super.init();
        this.sensors().set(BROKER_ID, (Object)Math.abs(this.hashCode()));
    }

    @Override
    public Integer getKafkaPort() {
        return (Integer)this.getAttribute((AttributeSensor)KAFKA_PORT);
    }

    @Override
    public Integer getBrokerId() {
        return (Integer)this.getAttribute(BROKER_ID);
    }

    @Override
    public ZooKeeperNode getZookeeper() {
        return (ZooKeeperNode)this.getConfig(ZOOKEEPER);
    }

    public Class<?> getDriverInterface() {
        return KafkaBrokerDriver.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForServiceUp(long duration, TimeUnit units) {
        super.waitForServiceUp(duration, units);
        if (((KafkaBrokerDriver)this.getDriver()).isJmxEnabled()) {
            JmxHelper helper = new JmxHelper((Entity)this);
            try {
                helper.assertMBeanExistsEventually(SOCKET_SERVER_STATS_MBEAN, units.toMillis(duration));
            }
            finally {
                helper.terminate();
            }
        }
    }

    protected void connectSensors() {
        this.connectServiceUpIsRunning();
        boolean retrieveUsageMetrics = (Boolean)this.getConfig(RETRIEVE_USAGE_METRICS);
        if (((KafkaBrokerDriver)this.getDriver()).isJmxEnabled()) {
            this.jmxFeed = JmxFeed.builder().entity((Entity)this).period(500L, TimeUnit.MILLISECONDS).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(FETCH_REQUEST_COUNT).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("NumFetchRequests").onException(Functions.constant((Object)-1L))).enabled(retrieveUsageMetrics)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(TOTAL_FETCH_TIME).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("TotalFetchRequestMs").onException(Functions.constant((Object)-1L))).enabled(retrieveUsageMetrics)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(MAX_FETCH_TIME).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("MaxFetchRequestMs").onException(Functions.constant((Object)-1.0))).enabled(retrieveUsageMetrics)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(PRODUCE_REQUEST_COUNT).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("NumProduceRequests").onException(Functions.constant((Object)-1L))).enabled(retrieveUsageMetrics)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(TOTAL_PRODUCE_TIME).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("TotalProduceRequestMs").onException(Functions.constant((Object)-1L))).enabled(retrieveUsageMetrics)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(MAX_PRODUCE_TIME).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("MaxProduceRequestMs").onException(Functions.constant((Object)-1.0))).enabled(retrieveUsageMetrics)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(BYTES_RECEIVED).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("TotalBytesRead").onException(Functions.constant((Object)-1L))).enabled(retrieveUsageMetrics)).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(BYTES_SENT).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("TotalBytesWritten").onException(Functions.constant((Object)-1L))).enabled(retrieveUsageMetrics)).build();
        }
        this.setBrokerUrl();
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("kafkaPort", (Object)this.getKafkaPort());
    }

    @Override
    public void setBrokerUrl() {
        ZooKeeperNode zookeeper = this.getZookeeper();
        if (zookeeper != null) {
            this.sensors().set(BROKER_URL, (Object)String.format("zookeeper://%s:%d", zookeeper.getAttribute(HOSTNAME), zookeeper.getZookeeperPort()));
        } else {
            this.sensors().set(BROKER_URL, (Object)String.format("kafka://%s:%d", this.getAttribute(HOSTNAME), this.getKafkaPort()));
        }
    }
}

