/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.azure.storage.config.AuthType;
import org.jclouds.azure.storage.filters.SharedKeyLiteAuthentication;
import org.jclouds.azure.storage.util.storageurl.StorageUrlSupplier;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.http.options.GetOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Provider;

@Singleton
public class AzureBlobRequestSigner
implements BlobRequestSigner {
    private static final int DEFAULT_EXPIRY_SECONDS = 900;
    private static final String API_VERSION = "2017-11-09";
    private final String identity;
    private final URI storageUrl;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final com.google.inject.Provider<String> timeStampProvider;
    private final DateService dateService;
    private final SharedKeyLiteAuthentication auth;
    private final String credential;
    private final boolean isSAS;
    private final AuthType authType;

    @Inject
    public AzureBlobRequestSigner(BlobToHttpGetOptions blob2HttpGetOptions, @TimeStamp com.google.inject.Provider<String> timeStampProvider, DateService dateService, SharedKeyLiteAuthentication auth, @Provider Supplier<Credentials> creds, @Named(value="sasAuth") boolean sasAuthentication, StorageUrlSupplier storageUriSupplier, AuthType authType) throws SecurityException, NoSuchMethodException {
        this.identity = ((Credentials)creds.get()).identity;
        this.credential = ((Credentials)creds.get()).credential;
        this.storageUrl = (URI)storageUriSupplier.get();
        this.blob2HttpGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2HttpGetOptions, (Object)"blob2HttpGetOptions");
        this.timeStampProvider = (com.google.inject.Provider)Preconditions.checkNotNull(timeStampProvider, (Object)"timeStampProvider");
        this.dateService = (DateService)Preconditions.checkNotNull((Object)dateService, (Object)"dateService");
        this.auth = auth;
        this.isSAS = sasAuthentication;
        this.authType = authType;
    }

    public HttpRequest signGetBlob(String container, String name) {
        return this.signGetBlob(container, name, 900L);
    }

    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return this.sign("GET", container, name, null, timeInSeconds, null, null);
    }

    public HttpRequest signPutBlob(String container, Blob blob) {
        return this.signPutBlob(container, blob, 900L);
    }

    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)blob, (Object)"blob");
        return this.sign("PUT", container, blob.getMetadata().getName(), null, timeInSeconds, blob.getMetadata().getContentMetadata().getContentLength(), blob.getMetadata().getContentMetadata().getContentType());
    }

    public HttpRequest signRemoveBlob(String container, String name) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return this.sign("DELETE", container, name, null, 900L, null, null);
    }

    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return this.sign("GET", container, name, this.blob2HttpGetOptions.apply((org.jclouds.blobstore.options.GetOptions)Preconditions.checkNotNull((Object)options, (Object)"options")), 900L, null, null);
    }

    private HttpRequest signKey(String method, String container, String name, @Nullable GetOptions options, long expires, @Nullable Long contentLength, @Nullable String contentType) {
        Preconditions.checkNotNull((Object)method, (Object)"method");
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        String nowString = (String)this.timeStampProvider.get();
        Date now = this.dateService.rfc1123DateParse(nowString);
        Date expiration = new Date(now.getTime() + TimeUnit.SECONDS.toMillis(expires));
        String iso8601 = this.dateService.iso8601SecondsDateFormat(expiration);
        String signedPermission = method.equals("PUT") ? "w" : (method.equals("DELETE") ? "d" : "r");
        HttpRequest.Builder request = ((HttpRequest.Builder)HttpRequest.builder().method(method).endpoint(Uris.uriBuilder((URI)this.storageUrl).appendPath(container).appendPath(name).build()).replaceHeader("Date", new String[]{nowString})).addQueryParam("sv", new String[]{API_VERSION}).addQueryParam("se", new String[]{iso8601}).addQueryParam("sr", new String[]{"b"}).addQueryParam("sp", new String[]{signedPermission});
        request = this.setHeaders(request, method, options, contentLength, contentType);
        String stringToSign = signedPermission + "\n\n" + iso8601 + "\n/blob/" + this.identity + "/" + container + "/" + name + "\n\n\n\n" + API_VERSION + "\n\n\n\n\n";
        String signature = this.auth.calculateSignature(stringToSign);
        request.addQueryParam("sig", new String[]{signature});
        return request.build();
    }

    private HttpRequest.Builder setHeaders(HttpRequest.Builder request, String method, @Nullable GetOptions options, @Nullable Long contentLength, @Nullable String contentType) {
        if (contentLength != null) {
            request.replaceHeader("Content-Length", new String[]{contentLength.toString()});
        }
        if (contentType != null) {
            request.replaceHeader("x-ms-blob-content-type", new String[]{contentType});
        }
        if (options != null) {
            request.headers(options.buildRequestHeaders());
        }
        if (method.equals("PUT")) {
            request.replaceHeader("x-ms-blob-type", new String[]{"BlockBlob"});
        }
        return request;
    }

    private HttpRequest signSAS(String method, String container, String name, @Nullable GetOptions options, long expires, @Nullable Long contentLength, @Nullable String contentType) {
        Preconditions.checkNotNull((Object)method, (Object)"method");
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        String nowString = (String)this.timeStampProvider.get();
        HttpRequest.Builder request = (HttpRequest.Builder)HttpRequest.builder().method(method).endpoint(Uris.uriBuilder((URI)this.storageUrl).appendPath(container).appendPath(name).query(this.credential).build()).replaceHeader("Date", new String[]{nowString});
        request = this.setHeaders(request, method, options, contentLength, contentType);
        return request.build();
    }

    private HttpRequest signAD(String method, String container, String name, @Nullable GetOptions options, long expires, @Nullable Long contentLength, @Nullable String contentType) {
        Preconditions.checkNotNull((Object)method, (Object)"method");
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        String nowString = (String)this.timeStampProvider.get();
        HttpRequest.Builder request = (HttpRequest.Builder)HttpRequest.builder().method(method).endpoint(Uris.uriBuilder((URI)this.storageUrl).appendPath(container).appendPath(name).build()).replaceHeader("Date", new String[]{nowString});
        request = this.setHeaders(request, method, options, contentLength, contentType);
        return request.build();
    }

    public HttpRequest sign(String method, String container, String name, @Nullable GetOptions options, long expires, @Nullable Long contentLength, @Nullable String contentType) {
        if (this.authType == AuthType.AZURE_AD) {
            return this.signAD(method, container, name, options, expires, contentLength, contentType);
        }
        if (this.isSAS) {
            return this.signSAS(method, container, name, options, expires, contentLength, contentType);
        }
        return this.signKey(method, container, name, options, expires, contentLength, contentType);
    }
}

