/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client;

import io.cloudsoft.winrm4j.client.PayloadEncryptionMode;
import io.cloudsoft.winrm4j.client.RetryingProxyHandler;
import io.cloudsoft.winrm4j.client.ShellCommand;
import io.cloudsoft.winrm4j.client.StripShellResponseHandler;
import io.cloudsoft.winrm4j.client.WinRm;
import io.cloudsoft.winrm4j.client.WinRmClientBuilder;
import io.cloudsoft.winrm4j.client.WinRmClientContext;
import io.cloudsoft.winrm4j.client.WinRmFactory;
import io.cloudsoft.winrm4j.client.encryption.AsyncHttpEncryptionAwareConduitFactory;
import io.cloudsoft.winrm4j.client.ntlm.NTCredentialsWithEncryption;
import io.cloudsoft.winrm4j.client.ntlm.NtlmMasqAsSpnegoSchemeFactory;
import io.cloudsoft.winrm4j.client.shell.EnvironmentVariable;
import io.cloudsoft.winrm4j.client.shell.EnvironmentVariableList;
import io.cloudsoft.winrm4j.client.shell.Shell;
import io.cloudsoft.winrm4j.client.spnego.WsmanViaSpnegoSchemeFactory;
import io.cloudsoft.winrm4j.client.transfer.ResourceCreated;
import io.cloudsoft.winrm4j.client.wsman.Locale;
import io.cloudsoft.winrm4j.client.wsman.OptionSetType;
import io.cloudsoft.winrm4j.client.wsman.OptionType;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.security.NamePasswordCallbackHandler;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.policy.MetadataConstants;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.PrimitiveAssertion;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class WinRmClient
implements AutoCloseable {
    static final int MAX_ENVELOPER_SIZE = 153600;
    static final String RESOURCE_URI = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/cmd";
    private final String workingDirectory;
    private final Locale locale;
    private final Map<String, String> environment;
    private final PayloadEncryptionMode payloadEncryptionMode;
    private final WinRm service;
    private AsyncHttpEncryptionAwareConduitFactory factoryToCleanup;
    private String operationTimeout;
    private Predicate<String> retryReceiveAfterOperationTimeout;
    private final WinRmClientContext context;
    private final boolean cleanupContext;
    private final WinRm winrm;
    private final RetryingProxyHandler retryingHandler;
    private ShellCommand shellCommand;
    private static final Logger LOG = LoggerFactory.getLogger((String)WinRmClient.class.getName());
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private static final Configuration JAAS_KERB_LOGIN_CONF = new KerberosJaasConfiguration();

    public static WinRmClientBuilder builder(URL endpoint) {
        return new WinRmClientBuilder(endpoint);
    }

    public static WinRmClientBuilder builder(String endpoint) {
        return new WinRmClientBuilder(endpoint);
    }

    @Deprecated
    public static Builder builder(URL endpoint, String authenticationScheme) {
        return new Builder(endpoint, authenticationScheme);
    }

    @Deprecated
    public static Builder builder(String endpoint, String authenticationScheme) {
        return new Builder(endpoint, authenticationScheme);
    }

    WinRmClient(WinRmClientBuilder builder) {
        boolean cleanupFactory = builder.endpointConduitFactory == null;
        this.workingDirectory = builder.workingDirectory;
        this.locale = builder.locale;
        this.operationTimeout = WinRmClient.toDuration(builder.operationTimeout);
        this.retryReceiveAfterOperationTimeout = builder.retryReceiveAfterOperationTimeout;
        this.environment = builder.environment;
        if (builder.context != null) {
            this.context = builder.context;
            this.cleanupContext = false;
        } else {
            this.context = WinRmClientContext.newInstance();
            this.cleanupContext = true;
        }
        this.service = this.getService(builder);
        this.retryingHandler = new RetryingProxyHandler(this.service, builder.failureRetryPolicy);
        this.winrm = (WinRm)Proxy.newProxyInstance(WinRm.class.getClassLoader(), new Class[]{WinRm.class, BindingProvider.class}, (InvocationHandler)this.retryingHandler);
        this.payloadEncryptionMode = builder.payloadEncryptionMode();
        if (cleanupFactory) {
            this.factoryToCleanup = builder.endpointConduitFactory;
        }
    }

    @Deprecated
    public void setOperationTimeout(long timeout) {
        this.operationTimeout = WinRmClient.toDuration(timeout);
    }

    private WinRm getService(WinRmClientBuilder builder) {
        WinRm service = WinRmFactory.newInstance(this.context.getBus(), builder);
        WinRmClient.initializeClientAndService(service, builder);
        return service;
    }

    @Deprecated
    public int command(String cmd, Writer out, Writer err) {
        return this.initInstanceShell().execute(cmd, out, err);
    }

    @Deprecated
    public int getNumberOfReceiveCalls() {
        if (this.shellCommand == null) {
            return 0;
        }
        return this.shellCommand.getNumberOfReceiveCalls();
    }

    private static void initializeClientAndService(WinRm winrm, WinRmClientBuilder builder) {
        String endpoint = builder.endpoint.toExternalForm();
        String authenticationScheme = builder.authenticationScheme;
        String username = builder.username;
        String password = builder.password;
        String domain = builder.domain;
        boolean disableCertificateChecks = builder.disableCertificateChecks;
        HostnameVerifier hostnameVerifier = builder.hostnameVerifier;
        SSLSocketFactory sslSocketFactory = builder.sslSocketFactory;
        SSLContext sslContext = builder.sslContext;
        long connectionTimeout = builder.connectionTimeout;
        long connectionRequestTimeout = builder.connectionRequestTimeout;
        long receiveTimeout = builder.receiveTimeout != null ? builder.receiveTimeout : WinRmClient.operationToReceiveTimeout(builder.operationTimeout);
        Client client = ClientProxy.getClient((Object)winrm);
        if (builder.endpointConduitFactory != null) {
            client.getEndpoint().getEndpointInfo().setProperty(HTTPConduitFactory.class.getName(), (Object)builder.endpointConduitFactory);
        }
        ServiceInfo si = client.getEndpoint().getEndpointInfo().getService();
        si.setProperty("soap.force.doclit.bare", (Object)true);
        BindingProvider bp = (BindingProvider)winrm;
        List<Handler> handlerChain = Arrays.asList(new StripShellResponseHandler());
        bp.getBinding().setHandlerChain(handlerChain);
        Policy policy = new Policy();
        policy.addAssertion((Assertion)new PrimitiveAssertion(MetadataConstants.USING_ADDRESSING_2004_QNAME));
        bp.getRequestContext().put("org.apache.cxf.ws.policy.override", policy);
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint);
        boolean advancedHttpConfigNeeded = false;
        Supplier<Credentials> creds = () -> new NTCredentialsWithEncryption(username, password, null, domain);
        LinkedHashMap<String, Object> authSchemeRegistry = null;
        Set<String> authSchemes = null;
        switch (authenticationScheme) {
            case "Basic": {
                if (builder.payloadEncryptionMode().isRequired()) {
                    throw new IllegalStateException("Encryption is required, which is not compatible with auth");
                }
                bp.getRequestContext().put("javax.xml.ws.security.auth.username", username);
                bp.getRequestContext().put("javax.xml.ws.security.auth.password", password);
                authSchemes = Collections.singleton("Basic");
                break;
            }
            case "NTLM": {
                authSchemeRegistry = new LinkedHashMap<String, Object>();
                authSchemeRegistry.put("NTLM", new NTLMSchemeFactory());
                authSchemeRegistry.put("Negotiate", (Object)new NtlmMasqAsSpnegoSchemeFactory(builder.payloadEncryptionMode()));
                advancedHttpConfigNeeded = true;
                break;
            }
            case "Kerberos": {
                if (builder.payloadEncryptionMode().isRequired()) {
                    throw new IllegalStateException("Encryption is required, but not implemented here for Kerberos");
                }
                if (builder.requestNewKerberosTicket) {
                    KerberosCredentials newCreds = WinRmClient.getKerberosCreds(username, password);
                    creds = () -> newCreds;
                }
                authSchemeRegistry = new LinkedHashMap();
                authSchemeRegistry.put("Kerberos", new KerberosSchemeFactory());
                advancedHttpConfigNeeded = true;
                break;
            }
            case "Negotiate": {
                authSchemeRegistry = new LinkedHashMap();
                authSchemeRegistry.put("Negotiate", (Object)new WsmanViaSpnegoSchemeFactory());
                advancedHttpConfigNeeded = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException("No such authentication scheme " + authenticationScheme + "; options are " + Arrays.asList("Basic", "NTLM", "Negotiate", "Kerberos"));
            }
        }
        if (authSchemeRegistry != null) {
            if (authSchemes == null) {
                authSchemes = authSchemeRegistry.keySet();
            }
            RegistryBuilder rb = RegistryBuilder.create();
            authSchemeRegistry.forEach((arg_0, arg_1) -> ((RegistryBuilder)rb).register(arg_0, arg_1));
            bp.getRequestContext().put(AuthSchemeProvider.class.getName(), rb.build());
        }
        if (authSchemes != null) {
            if (builder.endpointConduitFactory == null) {
                builder.endpointConduitFactory = new AsyncHttpEncryptionAwareConduitFactory(builder.payloadEncryptionMode(), builder.targetAuthSchemes(), null);
            } else {
                builder.endpointConduitFactory.targetAuthSchemes(authSchemes);
            }
        }
        if (advancedHttpConfigNeeded) {
            bp.getRequestContext().put(Credentials.class.getName(), creds.get());
            bp.getRequestContext().put("http.autoredirect", true);
            AsyncHTTPConduit httpClient = (AsyncHTTPConduit)client.getConduit();
            if (disableCertificateChecks) {
                TLSClientParameters tlsClientParameters = new TLSClientParameters();
                tlsClientParameters.setDisableCNCheck(true);
                tlsClientParameters.setTrustManagers(new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }});
                httpClient.setTlsClientParameters(tlsClientParameters);
            }
            if (hostnameVerifier != null || sslSocketFactory != null || sslContext != null) {
                TLSClientParameters tlsClientParameters = new TLSClientParameters();
                tlsClientParameters.setHostnameVerifier(hostnameVerifier);
                tlsClientParameters.setSSLSocketFactory(sslSocketFactory);
                tlsClientParameters.setSslContext(sslContext);
                httpClient.setTlsClientParameters(tlsClientParameters);
            }
            HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
            httpClientPolicy.setAllowChunking(false);
            httpClientPolicy.setConnectionTimeout(connectionTimeout);
            httpClientPolicy.setConnectionRequestTimeout(connectionRequestTimeout);
            httpClientPolicy.setReceiveTimeout(receiveTimeout);
            httpClient.setClient(httpClientPolicy);
            httpClient.getClient().setAutoRedirect(true);
        }
    }

    private static KerberosCredentials getKerberosCreds(final String username, String password) {
        final String canonizedUsername = username.trim().toUpperCase();
        Subject subject = WinRmClient.kerberosLogin(canonizedUsername, password);
        GSSCredential userCred = Subject.doAs(subject, new PrivilegedAction<GSSCredential>(){

            @Override
            public GSSCredential run() {
                try {
                    GSSManager manager = GSSManager.getInstance();
                    GSSName principal = manager.createName(canonizedUsername, null);
                    Oid mechOid = new Oid(WinRmClient.KERBEROS_OID);
                    return manager.createCredential(principal, 0, mechOid, 1);
                }
                catch (GSSException e) {
                    throw new RuntimeException("Unable to create credential for user \"" + username + "\" after login", e);
                }
            }
        });
        return new KerberosCredentials(userCred);
    }

    private static Subject kerberosLogin(String username, String password) {
        Subject subject;
        NamePasswordCallbackHandler callbackHandler = new NamePasswordCallbackHandler(username, password);
        try {
            LoginContext lc = new LoginContext("", null, (CallbackHandler)callbackHandler, JAAS_KERB_LOGIN_CONF);
            lc.login();
            subject = lc.getSubject();
        }
        catch (LoginException e) {
            throw new RuntimeException("Exception occured while authenticate the user \"" + username + "\" on the KDC", e);
        }
        LOG.debug("After kerberos login: subject=" + subject);
        return subject;
    }

    public ShellCommand createShell() {
        Shell shell = new Shell();
        shell.getInputStreams().add("stdin");
        shell.getOutputStreams().add("stdout");
        shell.getOutputStreams().add("stderr");
        if (this.workingDirectory != null) {
            shell.setWorkingDirectory(this.workingDirectory);
        }
        if (this.environment != null && !this.environment.isEmpty()) {
            EnvironmentVariableList env = new EnvironmentVariableList();
            List<EnvironmentVariable> vars = env.getVariable();
            for (Map.Entry<String, String> entry : this.environment.entrySet()) {
                EnvironmentVariable var = new EnvironmentVariable();
                var.setName(entry.getKey());
                var.setValue(entry.getValue());
                vars.add(var);
            }
            shell.setEnvironment(env);
        }
        OptionSetType optSetCreate = new OptionSetType();
        OptionType optNoProfile = new OptionType();
        optNoProfile.setName("WINRS_NOPROFILE");
        optNoProfile.setValue("FALSE");
        optSetCreate.getOption().add(optNoProfile);
        OptionType optCodepage = new OptionType();
        optCodepage.setName("WINRS_CODEPAGE");
        optCodepage.setValue("437");
        optSetCreate.getOption().add(optCodepage);
        ResourceCreated resourceCreated = null;
        try {
            resourceCreated = this.winrm.create(shell, RESOURCE_URI, 153600, this.operationTimeout, this.locale, optSetCreate);
        }
        catch (RuntimeException e) {
            RetryingProxyHandler.checkForRootErrorAuthorizationLoopAndPropagateAnnotated(e);
            throw e;
        }
        String shellId = WinRmClient.getShellId(resourceCreated);
        return new ShellCommand(this.winrm, shellId, this.operationTimeout, this.retryReceiveAfterOperationTimeout, this.locale);
    }

    private static String getShellId(ResourceCreated resourceCreated) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        for (Element el : resourceCreated.getAny()) {
            String shellId;
            try {
                shellId = xpath.evaluate("//*[local-name()='Selector' and @Name='ShellId']", el);
            }
            catch (XPathExpressionException e) {
                throw new IllegalStateException(e);
            }
            if (shellId == null || shellId.isEmpty()) continue;
            return shellId;
        }
        throw new IllegalStateException("Shell ID not fount in " + resourceCreated);
    }

    @Deprecated
    public void disconnect() {
        boolean isBusRunning;
        if (this.context == null) {
            return;
        }
        boolean bl = isBusRunning = this.context.getBus().getState() != Bus.BusState.SHUTDOWN;
        if (!isBusRunning) {
            return;
        }
        try {
            ShellCommand oldShellCmd = this.cleanupInstanceShell();
            if (oldShellCmd != null) {
                oldShellCmd.close();
            }
        }
        finally {
            if (this.cleanupContext) {
                this.context.getBus().shutdown(true);
            }
        }
    }

    @Override
    public void close() {
        if (this.factoryToCleanup != null && !this.factoryToCleanup.isShutdown()) {
            this.factoryToCleanup.shutdown();
            this.factoryToCleanup = null;
        }
        if (this.context != null && this.cleanupContext) {
            boolean isBusRunning;
            boolean bl = isBusRunning = this.context.getBus().getState() != Bus.BusState.SHUTDOWN;
            if (isBusRunning) {
                this.context.getBus().shutdown(true);
            }
        }
    }

    private synchronized ShellCommand initInstanceShell() {
        if (this.shellCommand == null) {
            this.shellCommand = this.createShell();
        }
        return this.shellCommand;
    }

    private synchronized ShellCommand cleanupInstanceShell() {
        ShellCommand cmd = this.shellCommand;
        this.shellCommand = null;
        return cmd;
    }

    private static long operationToReceiveTimeout(long operationTimeout) {
        return operationTimeout + 60000L;
    }

    private static String toDuration(long operationTimeout) {
        BigDecimal bdMs = BigDecimal.valueOf(operationTimeout);
        BigDecimal bdSec = bdMs.divide(BigDecimal.valueOf(1000L));
        DecimalFormat df = new DecimalFormat("PT#.###S", new DecimalFormatSymbols(java.util.Locale.ROOT));
        return df.format(bdSec);
    }

    public static <T> T checkNotNull(T check, String msg) {
        if (check == null) {
            throw new NullPointerException(msg);
        }
        return check;
    }

    private static class KerberosJaasConfiguration
    extends Configuration {
        private final AppConfigurationEntry[] appConfigurationEntries;

        KerberosJaasConfiguration() {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("doNoPrompt", "true");
            options.put("client", "true");
            options.put("isInitiator", "true");
            options.put("useTicketCache", "false");
            this.appConfigurationEntries = new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return this.appConfigurationEntries;
        }
    }

    @Deprecated
    public static class Builder
    extends WinRmClientBuilder {
        @Deprecated
        public static final Long DEFAULT_OPERATION_TIMEOUT = 60000L;

        @Deprecated
        public Builder(URL endpoint, String authenticationScheme) {
            this(endpoint);
            this.authenticationScheme(authenticationScheme);
        }

        public Builder(String endpoint, String authenticationScheme) {
            this(WinRmClientBuilder.toUrlUnchecked(WinRmClient.checkNotNull(endpoint, "endpoint")), WinRmClient.checkNotNull(authenticationScheme, "authenticationScheme"));
        }

        Builder(String endpoint) {
            super(endpoint);
        }

        Builder(URL endpoint) {
            super(endpoint);
        }
    }
}

