/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilestatus.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationprofilestatus.traits.Builder;
import org.apache.camel.v1.integrationprofilestatus.traits.builder.Configuration;
import org.apache.camel.v1.integrationprofilestatus.traits.builder.ConfigurationBuilder;
import org.apache.camel.v1.integrationprofilestatus.traits.builder.ConfigurationFluent;

public class BuilderFluent<A extends BuilderFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private String baseImage;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private Boolean incrementalImageBuild;
    private String limitCPU;
    private String limitMemory;
    private List<String> mavenProfiles;
    private Map<String, String> nodeSelector;
    private Builder.OrderStrategy orderStrategy;
    private List<String> platforms;
    private List<String> properties;
    private String requestCPU;
    private String requestMemory;
    private Builder.Strategy strategy;
    private List<String> tasks;
    private String tasksFilter;
    private List<String> tasksLimitCPU;
    private List<String> tasksLimitMemory;
    private List<String> tasksRequestCPU;
    private List<String> tasksRequestMemory;
    private Boolean verbose;

    public BuilderFluent() {
    }

    public BuilderFluent(Builder instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Builder instance) {
        Builder builder = instance = instance != null ? instance : new Builder();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withBaseImage(instance.getBaseImage());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withIncrementalImageBuild(instance.getIncrementalImageBuild());
            this.withLimitCPU(instance.getLimitCPU());
            this.withLimitMemory(instance.getLimitMemory());
            this.withMavenProfiles(instance.getMavenProfiles());
            this.withNodeSelector(instance.getNodeSelector());
            this.withOrderStrategy(instance.getOrderStrategy());
            this.withPlatforms(instance.getPlatforms());
            this.withProperties(instance.getProperties());
            this.withRequestCPU(instance.getRequestCPU());
            this.withRequestMemory(instance.getRequestMemory());
            this.withStrategy(instance.getStrategy());
            this.withTasks(instance.getTasks());
            this.withTasksFilter(instance.getTasksFilter());
            this.withTasksLimitCPU(instance.getTasksLimitCPU());
            this.withTasksLimitMemory(instance.getTasksLimitMemory());
            this.withTasksRequestCPU(instance.getTasksRequestCPU());
            this.withTasksRequestMemory(instance.getTasksRequestMemory());
            this.withVerbose(instance.getVerbose());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)((Object)this);
    }

    public boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Boolean getIncrementalImageBuild() {
        return this.incrementalImageBuild;
    }

    public A withIncrementalImageBuild(Boolean incrementalImageBuild) {
        this.incrementalImageBuild = incrementalImageBuild;
        return (A)((Object)this);
    }

    public boolean hasIncrementalImageBuild() {
        return this.incrementalImageBuild != null;
    }

    public String getLimitCPU() {
        return this.limitCPU;
    }

    public A withLimitCPU(String limitCPU) {
        this.limitCPU = limitCPU;
        return (A)((Object)this);
    }

    public boolean hasLimitCPU() {
        return this.limitCPU != null;
    }

    public String getLimitMemory() {
        return this.limitMemory;
    }

    public A withLimitMemory(String limitMemory) {
        this.limitMemory = limitMemory;
        return (A)((Object)this);
    }

    public boolean hasLimitMemory() {
        return this.limitMemory != null;
    }

    public A addToMavenProfiles(int index, String item) {
        if (this.mavenProfiles == null) {
            this.mavenProfiles = new ArrayList<String>();
        }
        this.mavenProfiles.add(index, item);
        return (A)((Object)this);
    }

    public A setToMavenProfiles(int index, String item) {
        if (this.mavenProfiles == null) {
            this.mavenProfiles = new ArrayList<String>();
        }
        this.mavenProfiles.set(index, item);
        return (A)((Object)this);
    }

    public A addToMavenProfiles(String ... items) {
        if (this.mavenProfiles == null) {
            this.mavenProfiles = new ArrayList<String>();
        }
        for (String item : items) {
            this.mavenProfiles.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToMavenProfiles(Collection<String> items) {
        if (this.mavenProfiles == null) {
            this.mavenProfiles = new ArrayList<String>();
        }
        for (String item : items) {
            this.mavenProfiles.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromMavenProfiles(String ... items) {
        if (this.mavenProfiles == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.mavenProfiles.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMavenProfiles(Collection<String> items) {
        if (this.mavenProfiles == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.mavenProfiles.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getMavenProfiles() {
        return this.mavenProfiles;
    }

    public String getMavenProfile(int index) {
        return this.mavenProfiles.get(index);
    }

    public String getFirstMavenProfile() {
        return this.mavenProfiles.get(0);
    }

    public String getLastMavenProfile() {
        return this.mavenProfiles.get(this.mavenProfiles.size() - 1);
    }

    public String getMatchingMavenProfile(Predicate<String> predicate) {
        for (String item : this.mavenProfiles) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMavenProfile(Predicate<String> predicate) {
        for (String item : this.mavenProfiles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMavenProfiles(List<String> mavenProfiles) {
        if (mavenProfiles != null) {
            this.mavenProfiles = new ArrayList<String>();
            for (String item : mavenProfiles) {
                this.addToMavenProfiles(item);
            }
        } else {
            this.mavenProfiles = null;
        }
        return (A)((Object)this);
    }

    public A withMavenProfiles(String ... mavenProfiles) {
        if (this.mavenProfiles != null) {
            this.mavenProfiles.clear();
            this._visitables.remove((Object)"mavenProfiles");
        }
        if (mavenProfiles != null) {
            for (String item : mavenProfiles) {
                this.addToMavenProfiles(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMavenProfiles() {
        return this.mavenProfiles != null && !this.mavenProfiles.isEmpty();
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public Builder.OrderStrategy getOrderStrategy() {
        return this.orderStrategy;
    }

    public A withOrderStrategy(Builder.OrderStrategy orderStrategy) {
        this.orderStrategy = orderStrategy;
        return (A)((Object)this);
    }

    public boolean hasOrderStrategy() {
        return this.orderStrategy != null;
    }

    public A addToPlatforms(int index, String item) {
        if (this.platforms == null) {
            this.platforms = new ArrayList<String>();
        }
        this.platforms.add(index, item);
        return (A)((Object)this);
    }

    public A setToPlatforms(int index, String item) {
        if (this.platforms == null) {
            this.platforms = new ArrayList<String>();
        }
        this.platforms.set(index, item);
        return (A)((Object)this);
    }

    public A addToPlatforms(String ... items) {
        if (this.platforms == null) {
            this.platforms = new ArrayList<String>();
        }
        for (String item : items) {
            this.platforms.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPlatforms(Collection<String> items) {
        if (this.platforms == null) {
            this.platforms = new ArrayList<String>();
        }
        for (String item : items) {
            this.platforms.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPlatforms(String ... items) {
        if (this.platforms == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.platforms.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPlatforms(Collection<String> items) {
        if (this.platforms == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.platforms.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPlatforms() {
        return this.platforms;
    }

    public String getPlatform(int index) {
        return this.platforms.get(index);
    }

    public String getFirstPlatform() {
        return this.platforms.get(0);
    }

    public String getLastPlatform() {
        return this.platforms.get(this.platforms.size() - 1);
    }

    public String getMatchingPlatform(Predicate<String> predicate) {
        for (String item : this.platforms) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPlatform(Predicate<String> predicate) {
        for (String item : this.platforms) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPlatforms(List<String> platforms) {
        if (platforms != null) {
            this.platforms = new ArrayList<String>();
            for (String item : platforms) {
                this.addToPlatforms(item);
            }
        } else {
            this.platforms = null;
        }
        return (A)((Object)this);
    }

    public A withPlatforms(String ... platforms) {
        if (this.platforms != null) {
            this.platforms.clear();
            this._visitables.remove((Object)"platforms");
        }
        if (platforms != null) {
            for (String item : platforms) {
                this.addToPlatforms(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPlatforms() {
        return this.platforms != null && !this.platforms.isEmpty();
    }

    public A addToProperties(int index, String item) {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        this.properties.add(index, item);
        return (A)((Object)this);
    }

    public A setToProperties(int index, String item) {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        this.properties.set(index, item);
        return (A)((Object)this);
    }

    public A addToProperties(String ... items) {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        for (String item : items) {
            this.properties.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToProperties(Collection<String> items) {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        for (String item : items) {
            this.properties.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromProperties(String ... items) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.properties.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProperties(Collection<String> items) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.properties.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public String getProperty(int index) {
        return this.properties.get(index);
    }

    public String getFirstProperty() {
        return this.properties.get(0);
    }

    public String getLastProperty() {
        return this.properties.get(this.properties.size() - 1);
    }

    public String getMatchingProperty(Predicate<String> predicate) {
        for (String item : this.properties) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingProperty(Predicate<String> predicate) {
        for (String item : this.properties) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProperties(List<String> properties) {
        if (properties != null) {
            this.properties = new ArrayList<String>();
            for (String item : properties) {
                this.addToProperties(item);
            }
        } else {
            this.properties = null;
        }
        return (A)((Object)this);
    }

    public A withProperties(String ... properties) {
        if (this.properties != null) {
            this.properties.clear();
            this._visitables.remove((Object)"properties");
        }
        if (properties != null) {
            for (String item : properties) {
                this.addToProperties(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public String getRequestCPU() {
        return this.requestCPU;
    }

    public A withRequestCPU(String requestCPU) {
        this.requestCPU = requestCPU;
        return (A)((Object)this);
    }

    public boolean hasRequestCPU() {
        return this.requestCPU != null;
    }

    public String getRequestMemory() {
        return this.requestMemory;
    }

    public A withRequestMemory(String requestMemory) {
        this.requestMemory = requestMemory;
        return (A)((Object)this);
    }

    public boolean hasRequestMemory() {
        return this.requestMemory != null;
    }

    public Builder.Strategy getStrategy() {
        return this.strategy;
    }

    public A withStrategy(Builder.Strategy strategy) {
        this.strategy = strategy;
        return (A)((Object)this);
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public A addToTasks(int index, String item) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<String>();
        }
        this.tasks.add(index, item);
        return (A)((Object)this);
    }

    public A setToTasks(int index, String item) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<String>();
        }
        this.tasks.set(index, item);
        return (A)((Object)this);
    }

    public A addToTasks(String ... items) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<String>();
        }
        for (String item : items) {
            this.tasks.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTasks(Collection<String> items) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<String>();
        }
        for (String item : items) {
            this.tasks.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTasks(String ... items) {
        if (this.tasks == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tasks.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTasks(Collection<String> items) {
        if (this.tasks == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tasks.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTasks() {
        return this.tasks;
    }

    public String getTask(int index) {
        return this.tasks.get(index);
    }

    public String getFirstTask() {
        return this.tasks.get(0);
    }

    public String getLastTask() {
        return this.tasks.get(this.tasks.size() - 1);
    }

    public String getMatchingTask(Predicate<String> predicate) {
        for (String item : this.tasks) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTask(Predicate<String> predicate) {
        for (String item : this.tasks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTasks(List<String> tasks) {
        if (tasks != null) {
            this.tasks = new ArrayList<String>();
            for (String item : tasks) {
                this.addToTasks(item);
            }
        } else {
            this.tasks = null;
        }
        return (A)((Object)this);
    }

    public A withTasks(String ... tasks) {
        if (this.tasks != null) {
            this.tasks.clear();
            this._visitables.remove((Object)"tasks");
        }
        if (tasks != null) {
            for (String item : tasks) {
                this.addToTasks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTasks() {
        return this.tasks != null && !this.tasks.isEmpty();
    }

    public String getTasksFilter() {
        return this.tasksFilter;
    }

    public A withTasksFilter(String tasksFilter) {
        this.tasksFilter = tasksFilter;
        return (A)((Object)this);
    }

    public boolean hasTasksFilter() {
        return this.tasksFilter != null;
    }

    public A addToTasksLimitCPU(int index, String item) {
        if (this.tasksLimitCPU == null) {
            this.tasksLimitCPU = new ArrayList<String>();
        }
        this.tasksLimitCPU.add(index, item);
        return (A)((Object)this);
    }

    public A setToTasksLimitCPU(int index, String item) {
        if (this.tasksLimitCPU == null) {
            this.tasksLimitCPU = new ArrayList<String>();
        }
        this.tasksLimitCPU.set(index, item);
        return (A)((Object)this);
    }

    public A addToTasksLimitCPU(String ... items) {
        if (this.tasksLimitCPU == null) {
            this.tasksLimitCPU = new ArrayList<String>();
        }
        for (String item : items) {
            this.tasksLimitCPU.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTasksLimitCPU(Collection<String> items) {
        if (this.tasksLimitCPU == null) {
            this.tasksLimitCPU = new ArrayList<String>();
        }
        for (String item : items) {
            this.tasksLimitCPU.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTasksLimitCPU(String ... items) {
        if (this.tasksLimitCPU == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tasksLimitCPU.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTasksLimitCPU(Collection<String> items) {
        if (this.tasksLimitCPU == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tasksLimitCPU.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTasksLimitCPU() {
        return this.tasksLimitCPU;
    }

    public String getTasksLimitCPU(int index) {
        return this.tasksLimitCPU.get(index);
    }

    public String getFirstTasksLimitCPU() {
        return this.tasksLimitCPU.get(0);
    }

    public String getLastTasksLimitCPU() {
        return this.tasksLimitCPU.get(this.tasksLimitCPU.size() - 1);
    }

    public String getMatchingTasksLimitCPU(Predicate<String> predicate) {
        for (String item : this.tasksLimitCPU) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTasksLimitCPU(Predicate<String> predicate) {
        for (String item : this.tasksLimitCPU) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTasksLimitCPU(List<String> tasksLimitCPU) {
        if (tasksLimitCPU != null) {
            this.tasksLimitCPU = new ArrayList<String>();
            for (String item : tasksLimitCPU) {
                this.addToTasksLimitCPU(item);
            }
        } else {
            this.tasksLimitCPU = null;
        }
        return (A)((Object)this);
    }

    public A withTasksLimitCPU(String ... tasksLimitCPU) {
        if (this.tasksLimitCPU != null) {
            this.tasksLimitCPU.clear();
            this._visitables.remove((Object)"tasksLimitCPU");
        }
        if (tasksLimitCPU != null) {
            for (String item : tasksLimitCPU) {
                this.addToTasksLimitCPU(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTasksLimitCPU() {
        return this.tasksLimitCPU != null && !this.tasksLimitCPU.isEmpty();
    }

    public A addToTasksLimitMemory(int index, String item) {
        if (this.tasksLimitMemory == null) {
            this.tasksLimitMemory = new ArrayList<String>();
        }
        this.tasksLimitMemory.add(index, item);
        return (A)((Object)this);
    }

    public A setToTasksLimitMemory(int index, String item) {
        if (this.tasksLimitMemory == null) {
            this.tasksLimitMemory = new ArrayList<String>();
        }
        this.tasksLimitMemory.set(index, item);
        return (A)((Object)this);
    }

    public A addToTasksLimitMemory(String ... items) {
        if (this.tasksLimitMemory == null) {
            this.tasksLimitMemory = new ArrayList<String>();
        }
        for (String item : items) {
            this.tasksLimitMemory.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTasksLimitMemory(Collection<String> items) {
        if (this.tasksLimitMemory == null) {
            this.tasksLimitMemory = new ArrayList<String>();
        }
        for (String item : items) {
            this.tasksLimitMemory.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTasksLimitMemory(String ... items) {
        if (this.tasksLimitMemory == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tasksLimitMemory.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTasksLimitMemory(Collection<String> items) {
        if (this.tasksLimitMemory == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tasksLimitMemory.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTasksLimitMemory() {
        return this.tasksLimitMemory;
    }

    public String getTasksLimitMemory(int index) {
        return this.tasksLimitMemory.get(index);
    }

    public String getFirstTasksLimitMemory() {
        return this.tasksLimitMemory.get(0);
    }

    public String getLastTasksLimitMemory() {
        return this.tasksLimitMemory.get(this.tasksLimitMemory.size() - 1);
    }

    public String getMatchingTasksLimitMemory(Predicate<String> predicate) {
        for (String item : this.tasksLimitMemory) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTasksLimitMemory(Predicate<String> predicate) {
        for (String item : this.tasksLimitMemory) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTasksLimitMemory(List<String> tasksLimitMemory) {
        if (tasksLimitMemory != null) {
            this.tasksLimitMemory = new ArrayList<String>();
            for (String item : tasksLimitMemory) {
                this.addToTasksLimitMemory(item);
            }
        } else {
            this.tasksLimitMemory = null;
        }
        return (A)((Object)this);
    }

    public A withTasksLimitMemory(String ... tasksLimitMemory) {
        if (this.tasksLimitMemory != null) {
            this.tasksLimitMemory.clear();
            this._visitables.remove((Object)"tasksLimitMemory");
        }
        if (tasksLimitMemory != null) {
            for (String item : tasksLimitMemory) {
                this.addToTasksLimitMemory(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTasksLimitMemory() {
        return this.tasksLimitMemory != null && !this.tasksLimitMemory.isEmpty();
    }

    public A addToTasksRequestCPU(int index, String item) {
        if (this.tasksRequestCPU == null) {
            this.tasksRequestCPU = new ArrayList<String>();
        }
        this.tasksRequestCPU.add(index, item);
        return (A)((Object)this);
    }

    public A setToTasksRequestCPU(int index, String item) {
        if (this.tasksRequestCPU == null) {
            this.tasksRequestCPU = new ArrayList<String>();
        }
        this.tasksRequestCPU.set(index, item);
        return (A)((Object)this);
    }

    public A addToTasksRequestCPU(String ... items) {
        if (this.tasksRequestCPU == null) {
            this.tasksRequestCPU = new ArrayList<String>();
        }
        for (String item : items) {
            this.tasksRequestCPU.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTasksRequestCPU(Collection<String> items) {
        if (this.tasksRequestCPU == null) {
            this.tasksRequestCPU = new ArrayList<String>();
        }
        for (String item : items) {
            this.tasksRequestCPU.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTasksRequestCPU(String ... items) {
        if (this.tasksRequestCPU == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tasksRequestCPU.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTasksRequestCPU(Collection<String> items) {
        if (this.tasksRequestCPU == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tasksRequestCPU.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTasksRequestCPU() {
        return this.tasksRequestCPU;
    }

    public String getTasksRequestCPU(int index) {
        return this.tasksRequestCPU.get(index);
    }

    public String getFirstTasksRequestCPU() {
        return this.tasksRequestCPU.get(0);
    }

    public String getLastTasksRequestCPU() {
        return this.tasksRequestCPU.get(this.tasksRequestCPU.size() - 1);
    }

    public String getMatchingTasksRequestCPU(Predicate<String> predicate) {
        for (String item : this.tasksRequestCPU) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTasksRequestCPU(Predicate<String> predicate) {
        for (String item : this.tasksRequestCPU) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTasksRequestCPU(List<String> tasksRequestCPU) {
        if (tasksRequestCPU != null) {
            this.tasksRequestCPU = new ArrayList<String>();
            for (String item : tasksRequestCPU) {
                this.addToTasksRequestCPU(item);
            }
        } else {
            this.tasksRequestCPU = null;
        }
        return (A)((Object)this);
    }

    public A withTasksRequestCPU(String ... tasksRequestCPU) {
        if (this.tasksRequestCPU != null) {
            this.tasksRequestCPU.clear();
            this._visitables.remove((Object)"tasksRequestCPU");
        }
        if (tasksRequestCPU != null) {
            for (String item : tasksRequestCPU) {
                this.addToTasksRequestCPU(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTasksRequestCPU() {
        return this.tasksRequestCPU != null && !this.tasksRequestCPU.isEmpty();
    }

    public A addToTasksRequestMemory(int index, String item) {
        if (this.tasksRequestMemory == null) {
            this.tasksRequestMemory = new ArrayList<String>();
        }
        this.tasksRequestMemory.add(index, item);
        return (A)((Object)this);
    }

    public A setToTasksRequestMemory(int index, String item) {
        if (this.tasksRequestMemory == null) {
            this.tasksRequestMemory = new ArrayList<String>();
        }
        this.tasksRequestMemory.set(index, item);
        return (A)((Object)this);
    }

    public A addToTasksRequestMemory(String ... items) {
        if (this.tasksRequestMemory == null) {
            this.tasksRequestMemory = new ArrayList<String>();
        }
        for (String item : items) {
            this.tasksRequestMemory.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTasksRequestMemory(Collection<String> items) {
        if (this.tasksRequestMemory == null) {
            this.tasksRequestMemory = new ArrayList<String>();
        }
        for (String item : items) {
            this.tasksRequestMemory.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTasksRequestMemory(String ... items) {
        if (this.tasksRequestMemory == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tasksRequestMemory.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTasksRequestMemory(Collection<String> items) {
        if (this.tasksRequestMemory == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tasksRequestMemory.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTasksRequestMemory() {
        return this.tasksRequestMemory;
    }

    public String getTasksRequestMemory(int index) {
        return this.tasksRequestMemory.get(index);
    }

    public String getFirstTasksRequestMemory() {
        return this.tasksRequestMemory.get(0);
    }

    public String getLastTasksRequestMemory() {
        return this.tasksRequestMemory.get(this.tasksRequestMemory.size() - 1);
    }

    public String getMatchingTasksRequestMemory(Predicate<String> predicate) {
        for (String item : this.tasksRequestMemory) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTasksRequestMemory(Predicate<String> predicate) {
        for (String item : this.tasksRequestMemory) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTasksRequestMemory(List<String> tasksRequestMemory) {
        if (tasksRequestMemory != null) {
            this.tasksRequestMemory = new ArrayList<String>();
            for (String item : tasksRequestMemory) {
                this.addToTasksRequestMemory(item);
            }
        } else {
            this.tasksRequestMemory = null;
        }
        return (A)((Object)this);
    }

    public A withTasksRequestMemory(String ... tasksRequestMemory) {
        if (this.tasksRequestMemory != null) {
            this.tasksRequestMemory.clear();
            this._visitables.remove((Object)"tasksRequestMemory");
        }
        if (tasksRequestMemory != null) {
            for (String item : tasksRequestMemory) {
                this.addToTasksRequestMemory(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTasksRequestMemory() {
        return this.tasksRequestMemory != null && !this.tasksRequestMemory.isEmpty();
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public A withVerbose(Boolean verbose) {
        this.verbose = verbose;
        return (A)((Object)this);
    }

    public boolean hasVerbose() {
        return this.verbose != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuilderFluent that = (BuilderFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.baseImage, that.baseImage)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.incrementalImageBuild, that.incrementalImageBuild)) {
            return false;
        }
        if (!Objects.equals(this.limitCPU, that.limitCPU)) {
            return false;
        }
        if (!Objects.equals(this.limitMemory, that.limitMemory)) {
            return false;
        }
        if (!Objects.equals(this.mavenProfiles, that.mavenProfiles)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals((Object)this.orderStrategy, (Object)that.orderStrategy)) {
            return false;
        }
        if (!Objects.equals(this.platforms, that.platforms)) {
            return false;
        }
        if (!Objects.equals(this.properties, that.properties)) {
            return false;
        }
        if (!Objects.equals(this.requestCPU, that.requestCPU)) {
            return false;
        }
        if (!Objects.equals(this.requestMemory, that.requestMemory)) {
            return false;
        }
        if (!Objects.equals((Object)this.strategy, (Object)that.strategy)) {
            return false;
        }
        if (!Objects.equals(this.tasks, that.tasks)) {
            return false;
        }
        if (!Objects.equals(this.tasksFilter, that.tasksFilter)) {
            return false;
        }
        if (!Objects.equals(this.tasksLimitCPU, that.tasksLimitCPU)) {
            return false;
        }
        if (!Objects.equals(this.tasksLimitMemory, that.tasksLimitMemory)) {
            return false;
        }
        if (!Objects.equals(this.tasksRequestCPU, that.tasksRequestCPU)) {
            return false;
        }
        if (!Objects.equals(this.tasksRequestMemory, that.tasksRequestMemory)) {
            return false;
        }
        return Objects.equals(this.verbose, that.verbose);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotations, this.baseImage, this.configuration, this.enabled, this.incrementalImageBuild, this.limitCPU, this.limitMemory, this.mavenProfiles, this.nodeSelector, this.orderStrategy, this.platforms, this.properties, this.requestCPU, this.requestMemory, this.strategy, this.tasks, this.tasksFilter, this.tasksLimitCPU, this.tasksLimitMemory, this.tasksRequestCPU, this.tasksRequestMemory, this.verbose, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.baseImage != null) {
            sb.append("baseImage:");
            sb.append(this.baseImage + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.incrementalImageBuild != null) {
            sb.append("incrementalImageBuild:");
            sb.append(this.incrementalImageBuild + ",");
        }
        if (this.limitCPU != null) {
            sb.append("limitCPU:");
            sb.append(this.limitCPU + ",");
        }
        if (this.limitMemory != null) {
            sb.append("limitMemory:");
            sb.append(this.limitMemory + ",");
        }
        if (this.mavenProfiles != null && !this.mavenProfiles.isEmpty()) {
            sb.append("mavenProfiles:");
            sb.append(this.mavenProfiles + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.orderStrategy != null) {
            sb.append("orderStrategy:");
            sb.append(this.orderStrategy + ",");
        }
        if (this.platforms != null && !this.platforms.isEmpty()) {
            sb.append("platforms:");
            sb.append(this.platforms + ",");
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("properties:");
            sb.append(this.properties + ",");
        }
        if (this.requestCPU != null) {
            sb.append("requestCPU:");
            sb.append(this.requestCPU + ",");
        }
        if (this.requestMemory != null) {
            sb.append("requestMemory:");
            sb.append(this.requestMemory + ",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy + ",");
        }
        if (this.tasks != null && !this.tasks.isEmpty()) {
            sb.append("tasks:");
            sb.append(this.tasks + ",");
        }
        if (this.tasksFilter != null) {
            sb.append("tasksFilter:");
            sb.append(this.tasksFilter + ",");
        }
        if (this.tasksLimitCPU != null && !this.tasksLimitCPU.isEmpty()) {
            sb.append("tasksLimitCPU:");
            sb.append(this.tasksLimitCPU + ",");
        }
        if (this.tasksLimitMemory != null && !this.tasksLimitMemory.isEmpty()) {
            sb.append("tasksLimitMemory:");
            sb.append(this.tasksLimitMemory + ",");
        }
        if (this.tasksRequestCPU != null && !this.tasksRequestCPU.isEmpty()) {
            sb.append("tasksRequestCPU:");
            sb.append(this.tasksRequestCPU + ",");
        }
        if (this.tasksRequestMemory != null && !this.tasksRequestMemory.isEmpty()) {
            sb.append("tasksRequestMemory:");
            sb.append(this.tasksRequestMemory + ",");
        }
        if (this.verbose != null) {
            sb.append("verbose:");
            sb.append(this.verbose);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withIncrementalImageBuild() {
        return this.withIncrementalImageBuild(true);
    }

    public A withVerbose() {
        return this.withVerbose(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)BuilderFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

