/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilestatus.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.integrationprofilestatus.traits.Cron;
import org.apache.camel.v1.integrationprofilestatus.traits.cron.Configuration;
import org.apache.camel.v1.integrationprofilestatus.traits.cron.ConfigurationBuilder;
import org.apache.camel.v1.integrationprofilestatus.traits.cron.ConfigurationFluent;

public class CronFluent<A extends CronFluent<A>>
extends BaseFluent<A> {
    private Long activeDeadlineSeconds;
    private Boolean auto;
    private Integer backoffLimit;
    private String components;
    private Cron.ConcurrencyPolicy concurrencyPolicy;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private Boolean fallback;
    private String schedule;
    private Long startingDeadlineSeconds;

    public CronFluent() {
    }

    public CronFluent(Cron instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Cron instance) {
        Cron cron = instance = instance != null ? instance : new Cron();
        if (instance != null) {
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
            this.withAuto(instance.getAuto());
            this.withBackoffLimit(instance.getBackoffLimit());
            this.withComponents(instance.getComponents());
            this.withConcurrencyPolicy(instance.getConcurrencyPolicy());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withFallback(instance.getFallback());
            this.withSchedule(instance.getSchedule());
            this.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());
        }
    }

    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)((Object)this);
    }

    public boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public A withAuto(Boolean auto) {
        this.auto = auto;
        return (A)((Object)this);
    }

    public boolean hasAuto() {
        return this.auto != null;
    }

    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    public A withBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
        return (A)((Object)this);
    }

    public boolean hasBackoffLimit() {
        return this.backoffLimit != null;
    }

    public String getComponents() {
        return this.components;
    }

    public A withComponents(String components) {
        this.components = components;
        return (A)((Object)this);
    }

    public boolean hasComponents() {
        return this.components != null;
    }

    public Cron.ConcurrencyPolicy getConcurrencyPolicy() {
        return this.concurrencyPolicy;
    }

    public A withConcurrencyPolicy(Cron.ConcurrencyPolicy concurrencyPolicy) {
        this.concurrencyPolicy = concurrencyPolicy;
        return (A)((Object)this);
    }

    public boolean hasConcurrencyPolicy() {
        return this.concurrencyPolicy != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Boolean getFallback() {
        return this.fallback;
    }

    public A withFallback(Boolean fallback) {
        this.fallback = fallback;
        return (A)((Object)this);
    }

    public boolean hasFallback() {
        return this.fallback != null;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public A withSchedule(String schedule) {
        this.schedule = schedule;
        return (A)((Object)this);
    }

    public boolean hasSchedule() {
        return this.schedule != null;
    }

    public Long getStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds;
    }

    public A withStartingDeadlineSeconds(Long startingDeadlineSeconds) {
        this.startingDeadlineSeconds = startingDeadlineSeconds;
        return (A)((Object)this);
    }

    public boolean hasStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CronFluent that = (CronFluent)((Object)o);
        if (!Objects.equals(this.activeDeadlineSeconds, that.activeDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.auto, that.auto)) {
            return false;
        }
        if (!Objects.equals(this.backoffLimit, that.backoffLimit)) {
            return false;
        }
        if (!Objects.equals(this.components, that.components)) {
            return false;
        }
        if (!Objects.equals((Object)this.concurrencyPolicy, (Object)that.concurrencyPolicy)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.fallback, that.fallback)) {
            return false;
        }
        if (!Objects.equals(this.schedule, that.schedule)) {
            return false;
        }
        return Objects.equals(this.startingDeadlineSeconds, that.startingDeadlineSeconds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activeDeadlineSeconds, this.auto, this.backoffLimit, this.components, this.concurrencyPolicy, this.configuration, this.enabled, this.fallback, this.schedule, this.startingDeadlineSeconds, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activeDeadlineSeconds != null) {
            sb.append("activeDeadlineSeconds:");
            sb.append(this.activeDeadlineSeconds + ",");
        }
        if (this.auto != null) {
            sb.append("auto:");
            sb.append(this.auto + ",");
        }
        if (this.backoffLimit != null) {
            sb.append("backoffLimit:");
            sb.append(this.backoffLimit + ",");
        }
        if (this.components != null) {
            sb.append("components:");
            sb.append(this.components + ",");
        }
        if (this.concurrencyPolicy != null) {
            sb.append("concurrencyPolicy:");
            sb.append(this.concurrencyPolicy + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.fallback != null) {
            sb.append("fallback:");
            sb.append(this.fallback + ",");
        }
        if (this.schedule != null) {
            sb.append("schedule:");
            sb.append(this.schedule + ",");
        }
        if (this.startingDeadlineSeconds != null) {
            sb.append("startingDeadlineSeconds:");
            sb.append(this.startingDeadlineSeconds);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAuto() {
        return this.withAuto(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withFallback() {
        return this.withFallback(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)CronFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

