/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipestatus;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.v1.pipestatus.Conditions;
import org.apache.camel.v1.pipestatus.conditions.Pods;
import org.apache.camel.v1.pipestatus.conditions.PodsBuilder;
import org.apache.camel.v1.pipestatus.conditions.PodsFluent;

public class ConditionsFluent<A extends ConditionsFluent<A>>
extends BaseFluent<A> {
    private ZonedDateTime lastTransitionTime;
    private ZonedDateTime lastUpdateTime;
    private String message;
    private ArrayList<PodsBuilder> pods;
    private String reason;
    private String status;
    private String type;

    public ConditionsFluent() {
    }

    public ConditionsFluent(Conditions instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Conditions instance) {
        Conditions conditions = instance = instance != null ? instance : new Conditions();
        if (instance != null) {
            this.withLastTransitionTime(instance.getLastTransitionTime());
            this.withLastUpdateTime(instance.getLastUpdateTime());
            this.withMessage(instance.getMessage());
            this.withPods(instance.getPods());
            this.withReason(instance.getReason());
            this.withStatus(instance.getStatus());
            this.withType(instance.getType());
        }
    }

    public ZonedDateTime getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public A withLastTransitionTime(ZonedDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return (A)((Object)this);
    }

    public boolean hasLastTransitionTime() {
        return this.lastTransitionTime != null;
    }

    public ZonedDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public A withLastUpdateTime(ZonedDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return (A)((Object)this);
    }

    public boolean hasLastUpdateTime() {
        return this.lastUpdateTime != null;
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)((Object)this);
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public A addToPods(int index, Pods item) {
        if (this.pods == null) {
            this.pods = new ArrayList();
        }
        PodsBuilder builder = new PodsBuilder(item);
        if (index < 0 || index >= this.pods.size()) {
            this._visitables.get((Object)"pods").add(builder);
            this.pods.add(builder);
        } else {
            this._visitables.get((Object)"pods").add(index, builder);
            this.pods.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPods(int index, Pods item) {
        if (this.pods == null) {
            this.pods = new ArrayList();
        }
        PodsBuilder builder = new PodsBuilder(item);
        if (index < 0 || index >= this.pods.size()) {
            this._visitables.get((Object)"pods").add(builder);
            this.pods.add(builder);
        } else {
            this._visitables.get((Object)"pods").set(index, builder);
            this.pods.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPods(Pods ... items) {
        if (this.pods == null) {
            this.pods = new ArrayList();
        }
        for (Pods item : items) {
            PodsBuilder builder = new PodsBuilder(item);
            this._visitables.get((Object)"pods").add(builder);
            this.pods.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPipestatusPods(Collection<Pods> items) {
        if (this.pods == null) {
            this.pods = new ArrayList();
        }
        for (Pods item : items) {
            PodsBuilder builder = new PodsBuilder(item);
            this._visitables.get((Object)"pods").add(builder);
            this.pods.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPods(Pods ... items) {
        if (this.pods == null) {
            return (A)((Object)this);
        }
        for (Pods item : items) {
            PodsBuilder builder = new PodsBuilder(item);
            this._visitables.get((Object)"pods").remove((Object)builder);
            this.pods.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPipestatusPods(Collection<Pods> items) {
        if (this.pods == null) {
            return (A)((Object)this);
        }
        for (Pods item : items) {
            PodsBuilder builder = new PodsBuilder(item);
            this._visitables.get((Object)"pods").remove((Object)builder);
            this.pods.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPipestatusPods(Predicate<PodsBuilder> predicate) {
        if (this.pods == null) {
            return (A)((Object)this);
        }
        Iterator<PodsBuilder> each = this.pods.iterator();
        List visitables = this._visitables.get((Object)"pods");
        while (each.hasNext()) {
            PodsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Pods> buildPods() {
        return this.pods != null ? ConditionsFluent.build(this.pods) : null;
    }

    public Pods buildPod(int index) {
        return this.pods.get(index).build();
    }

    public Pods buildFirstPod() {
        return this.pods.get(0).build();
    }

    public Pods buildLastPod() {
        return this.pods.get(this.pods.size() - 1).build();
    }

    public Pods buildMatchingPod(Predicate<PodsBuilder> predicate) {
        for (PodsBuilder item : this.pods) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPod(Predicate<PodsBuilder> predicate) {
        for (PodsBuilder item : this.pods) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPods(List<Pods> pods) {
        if (this.pods != null) {
            this._visitables.get((Object)"pods").clear();
        }
        if (pods != null) {
            this.pods = new ArrayList();
            for (Pods item : pods) {
                this.addToPods(item);
            }
        } else {
            this.pods = null;
        }
        return (A)((Object)this);
    }

    public A withPods(Pods ... pods) {
        if (this.pods != null) {
            this.pods.clear();
            this._visitables.remove((Object)"pods");
        }
        if (pods != null) {
            for (Pods item : pods) {
                this.addToPods(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPods() {
        return this.pods != null && !this.pods.isEmpty();
    }

    public PodsNested<A> addNewPod() {
        return new PodsNested(-1, null);
    }

    public PodsNested<A> addNewPodLike(Pods item) {
        return new PodsNested(-1, item);
    }

    public PodsNested<A> setNewPodLike(int index, Pods item) {
        return new PodsNested(index, item);
    }

    public PodsNested<A> editPod(int index) {
        if (this.pods.size() <= index) {
            throw new RuntimeException("Can't edit pods. Index exceeds size.");
        }
        return this.setNewPodLike(index, this.buildPod(index));
    }

    public PodsNested<A> editFirstPod() {
        if (this.pods.size() == 0) {
            throw new RuntimeException("Can't edit first pods. The list is empty.");
        }
        return this.setNewPodLike(0, this.buildPod(0));
    }

    public PodsNested<A> editLastPod() {
        int index = this.pods.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last pods. The list is empty.");
        }
        return this.setNewPodLike(index, this.buildPod(index));
    }

    public PodsNested<A> editMatchingPod(Predicate<PodsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pods.size(); ++i) {
            if (!predicate.test(this.pods.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching pods. No match found.");
        }
        return this.setNewPodLike(index, this.buildPod(index));
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)((Object)this);
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getStatus() {
        return this.status;
    }

    public A withStatus(String status) {
        this.status = status;
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionsFluent that = (ConditionsFluent)((Object)o);
        if (!Objects.equals(this.lastTransitionTime, that.lastTransitionTime)) {
            return false;
        }
        if (!Objects.equals(this.lastUpdateTime, that.lastUpdateTime)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.pods, that.pods)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.lastTransitionTime, this.lastUpdateTime, this.message, this.pods, this.reason, this.status, this.type, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.lastTransitionTime != null) {
            sb.append("lastTransitionTime:");
            sb.append(this.lastTransitionTime + ",");
        }
        if (this.lastUpdateTime != null) {
            sb.append("lastUpdateTime:");
            sb.append(this.lastUpdateTime + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.pods != null && !this.pods.isEmpty()) {
            sb.append("pods:");
            sb.append(this.pods + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PodsNested<N>
    extends PodsFluent<PodsNested<N>>
    implements Nested<N> {
        PodsBuilder builder;
        int index;

        PodsNested(int index, Pods item) {
            this.index = index;
            this.builder = new PodsBuilder(this, item);
        }

        public N and() {
            return (N)ConditionsFluent.this.setToPods(this.index, this.builder.build());
        }

        public N endPipestatusPod() {
            return this.and();
        }
    }
}

