/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformspec.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationplatformspec.traits.Openapi;
import org.apache.camel.v1.integrationplatformspec.traits.openapi.Configuration;
import org.apache.camel.v1.integrationplatformspec.traits.openapi.ConfigurationBuilder;
import org.apache.camel.v1.integrationplatformspec.traits.openapi.ConfigurationFluent;

public class OpenapiFluent<A extends OpenapiFluent<A>>
extends BaseFluent<A> {
    private List<String> configmaps;
    private ConfigurationBuilder configuration;
    private Boolean enabled;

    public OpenapiFluent() {
    }

    public OpenapiFluent(Openapi instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Openapi instance) {
        Openapi openapi = instance = instance != null ? instance : new Openapi();
        if (instance != null) {
            this.withConfigmaps(instance.getConfigmaps());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
        }
    }

    public A addToConfigmaps(int index, String item) {
        if (this.configmaps == null) {
            this.configmaps = new ArrayList<String>();
        }
        this.configmaps.add(index, item);
        return (A)((Object)this);
    }

    public A setToConfigmaps(int index, String item) {
        if (this.configmaps == null) {
            this.configmaps = new ArrayList<String>();
        }
        this.configmaps.set(index, item);
        return (A)((Object)this);
    }

    public A addToConfigmaps(String ... items) {
        if (this.configmaps == null) {
            this.configmaps = new ArrayList<String>();
        }
        for (String item : items) {
            this.configmaps.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConfigmaps(Collection<String> items) {
        if (this.configmaps == null) {
            this.configmaps = new ArrayList<String>();
        }
        for (String item : items) {
            this.configmaps.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConfigmaps(String ... items) {
        if (this.configmaps == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.configmaps.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConfigmaps(Collection<String> items) {
        if (this.configmaps == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.configmaps.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getConfigmaps() {
        return this.configmaps;
    }

    public String getConfigmap(int index) {
        return this.configmaps.get(index);
    }

    public String getFirstConfigmap() {
        return this.configmaps.get(0);
    }

    public String getLastConfigmap() {
        return this.configmaps.get(this.configmaps.size() - 1);
    }

    public String getMatchingConfigmap(Predicate<String> predicate) {
        for (String item : this.configmaps) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingConfigmap(Predicate<String> predicate) {
        for (String item : this.configmaps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConfigmaps(List<String> configmaps) {
        if (configmaps != null) {
            this.configmaps = new ArrayList<String>();
            for (String item : configmaps) {
                this.addToConfigmaps(item);
            }
        } else {
            this.configmaps = null;
        }
        return (A)((Object)this);
    }

    public A withConfigmaps(String ... configmaps) {
        if (this.configmaps != null) {
            this.configmaps.clear();
            this._visitables.remove((Object)"configmaps");
        }
        if (configmaps != null) {
            for (String item : configmaps) {
                this.addToConfigmaps(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConfigmaps() {
        return this.configmaps != null && !this.configmaps.isEmpty();
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenapiFluent that = (OpenapiFluent)((Object)o);
        if (!Objects.equals(this.configmaps, that.configmaps)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        return Objects.equals(this.enabled, that.enabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configmaps, this.configuration, this.enabled, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configmaps != null && !this.configmaps.isEmpty()) {
            sb.append("configmaps:");
            sb.append(this.configmaps + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)OpenapiFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

