/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.reflect.Converter;
import org.apache.cayenne.reflect.EnumConverter;
import org.apache.cayenne.reflect.ToAnyConverter;

public class ConverterFactory {
    static final ConverterFactory factory = new ConverterFactory();
    private final Map<Class<?>, Converter<?>> converters;
    private final EnumConverter<?> enumConverter = new EnumConverter();
    private final Converter<Object> toAnyConverter = new ToAnyConverter<Object>();

    private ConverterFactory() {
        Converter<String> toStringConverter = (object, type) -> object != null ? object.toString() : null;
        Converter<Boolean> toBooleanConverter = (object, type) -> {
            if (object == null) {
                return type.isPrimitive() ? Boolean.FALSE : null;
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof Integer || object instanceof Long || object instanceof Short || object instanceof Byte) {
                if (((Number)object).longValue() == 0L) {
                    return Boolean.FALSE;
                }
                if (((Number)object).longValue() == 1L) {
                    return Boolean.TRUE;
                }
            }
            return "true".equalsIgnoreCase(object.toString()) ? Boolean.TRUE : Boolean.FALSE;
        };
        Converter<Long> toLongConverter = (object, type) -> {
            if (object == null) {
                return type.isPrimitive() ? Long.valueOf(0L) : null;
            }
            if (object instanceof Long) {
                return (Long)object;
            }
            return Long.valueOf(object.toString());
        };
        Converter<Integer> toIntConverter = (object, type) -> {
            if (object == null) {
                return type.isPrimitive() ? Integer.valueOf(0) : null;
            }
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return Integer.valueOf(object.toString());
        };
        Converter<Byte> toByteConverter = (object, type) -> {
            if (object == null) {
                return type.isPrimitive() ? Byte.valueOf((byte)0) : null;
            }
            if (object instanceof Byte) {
                return (Byte)object;
            }
            return Byte.valueOf(object.toString());
        };
        Converter<Short> toShortConverter = (object, type) -> {
            if (object == null) {
                return type.isPrimitive() ? Short.valueOf((short)0) : null;
            }
            if (object instanceof Short) {
                return (Short)object;
            }
            return Short.valueOf(object.toString());
        };
        Converter<Character> toCharConverter = (object, type) -> {
            if (object == null) {
                return type.isPrimitive() ? Character.valueOf('\u0000') : null;
            }
            if (object instanceof Character) {
                return (Character)object;
            }
            String string = object.toString();
            return Character.valueOf(string.length() > 0 ? string.charAt(0) : (char)'\u0000');
        };
        Converter<Double> toDoubleConverter = (object, type) -> {
            if (object == null) {
                return type.isPrimitive() ? Double.valueOf(0.0) : null;
            }
            if (object instanceof Double) {
                return (Double)object;
            }
            return Double.valueOf(object.toString());
        };
        Converter<Float> toFloatConverter = (object, type) -> {
            if (object == null) {
                return type.isPrimitive() ? Float.valueOf(0.0f) : null;
            }
            if (object instanceof Float) {
                return (Float)object;
            }
            return Float.valueOf(object.toString());
        };
        Converter<BigDecimal> toBigDecimalConverter = (object, type) -> {
            if (object == null) {
                return null;
            }
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
            return new BigDecimal(object.toString());
        };
        Converter<BigInteger> toBigIntegerConverter = (object, type) -> {
            if (object == null) {
                return null;
            }
            if (object instanceof BigInteger) {
                return (BigInteger)object;
            }
            return new BigInteger(object.toString());
        };
        Converter<Date> toDateConverter = (value, type) -> {
            if (value == null) {
                return null;
            }
            if (value instanceof Date) {
                return (Date)value;
            }
            if (value instanceof Number) {
                return new Date(((Number)value).longValue());
            }
            return new Date(value.toString());
        };
        Converter<Timestamp> toTimestampConverter = (value, type) -> {
            if (value == null) {
                return null;
            }
            if (value instanceof Timestamp) {
                return (Timestamp)value;
            }
            if (value instanceof Number) {
                return new Timestamp(((Number)value).longValue());
            }
            return new Timestamp(Date.parse(value.toString()));
        };
        this.converters = new HashMap();
        this._addConverter(Boolean.class, toBooleanConverter);
        this._addConverter(Boolean.TYPE, toBooleanConverter);
        this._addConverter(Short.class, toShortConverter);
        this._addConverter(Short.TYPE, toShortConverter);
        this._addConverter(Byte.class, toByteConverter);
        this._addConverter(Byte.TYPE, toByteConverter);
        this._addConverter(Integer.class, toIntConverter);
        this._addConverter(Integer.TYPE, toIntConverter);
        this._addConverter(Long.class, toLongConverter);
        this._addConverter(Long.TYPE, toLongConverter);
        this._addConverter(Double.class, toDoubleConverter);
        this._addConverter(Double.TYPE, toDoubleConverter);
        this._addConverter(Float.class, toFloatConverter);
        this._addConverter(Float.TYPE, toFloatConverter);
        this._addConverter(Character.class, toCharConverter);
        this._addConverter(Character.TYPE, toCharConverter);
        this._addConverter(BigDecimal.class, toBigDecimalConverter);
        this._addConverter(BigInteger.class, toBigIntegerConverter);
        this._addConverter(Number.class, toBigDecimalConverter);
        this._addConverter(String.class, toStringConverter);
        this._addConverter(Date.class, toDateConverter);
        this._addConverter(Timestamp.class, toTimestampConverter);
    }

    public static <T> void addConverter(Class<? super T> type, Converter<T> converter) {
        factory._addConverter(type, converter);
    }

    private <T> void _addConverter(Class<? super T> type, Converter<T> converter) {
        this.converters.put(type, converter);
    }

    <T> Converter<T> getConverter(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (type.isEnum()) {
            return this.enumConverter;
        }
        Converter<?> c = this.converters.get(type);
        return c != null ? c : this.toAnyConverter;
    }
}

