/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.Fault;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.reflect.PropertyUtils;

public class HybridPersistentObject
extends PersistentObject {
    private static final long serialVersionUID = 1945209973678806566L;
    protected Map<String, Object> values;

    @Override
    Object readSimpleProperty(String property) {
        Object object = this.readProperty(property);
        if (object == null && this.values != null && !this.values.containsKey(property)) {
            object = PropertyUtils.getProperty((Object)this, property);
        }
        return object;
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if (this.values == null) {
            return null;
        }
        return this.values.get(propName);
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
        }
        this.values.put(propName, val);
    }

    @Override
    protected void appendProperties(StringBuffer buffer) {
        buffer.append('[');
        if (this.values == null) {
            buffer.append(']');
            return;
        }
        Iterator<Map.Entry<String, Object>> it = this.values.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            buffer.append(entry.getKey()).append("=>");
            Object value = entry.getValue();
            if (value instanceof Persistent) {
                buffer.append('{').append(((Persistent)value).getObjectId()).append('}');
            } else if (value instanceof Collection) {
                buffer.append("(..)");
            } else if (value instanceof Fault) {
                buffer.append('?');
            } else {
                buffer.append(value);
            }
            if (!it.hasNext()) continue;
            buffer.append("; ");
        }
        buffer.append(']');
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.values = (Map)in.readObject();
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.values);
    }
}

