/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.apache.cayenne.modeler.editor.cgen.CgenConfigPanel;
import org.apache.cayenne.modeler.util.ModelerUtil;

public class CgenPane
extends JPanel {
    private JButton generateButton;
    private JComboBox<String> configurationsComboBox;
    private JButton addConfigBtn;
    private JButton editConfigBtn;
    private JButton removeConfigBtn;
    private JSplitPane splitPane;

    public CgenPane(Component generatorPanel, Component entitySelectorPanel) {
        this.setLayout(new BorderLayout());
        this.initSplitPanel(generatorPanel, entitySelectorPanel);
        this.buildView();
    }

    private void buildView() {
        this.add((Component)this.getTopPanel(), "North");
        this.add((Component)this.splitPane, "Center");
    }

    private void initSplitPanel(Component generatorPanel, Component entitySelectorPanel) {
        this.splitPane = new JSplitPane(1);
        JScrollPane scrollPane = new JScrollPane(generatorPanel, 20, 30);
        scrollPane.setPreferredSize(new Dimension(150, 400));
        this.splitPane.setRightComponent(scrollPane);
        this.splitPane.setLeftComponent(entitySelectorPanel);
    }

    private JPanel getTopPanel() {
        JPanel configPanel = new JPanel();
        configPanel.setLayout(new BorderLayout());
        configPanel.add((Component)this.getConfigurationsPanel(), "West");
        configPanel.add((Component)this.getGeneratePanel(), "East");
        configPanel.setBorder(CgenConfigPanel.CGEN_PANEL_BORDER);
        return configPanel;
    }

    private JPanel getConfigurationsPanel() {
        FormLayout configCroupLayout = new FormLayout("109dlu,3dlu,pref,3dlu,pref,3dlu,pref", "p");
        PanelBuilder configCroupBuilder = new PanelBuilder(configCroupLayout);
        CellConstraints cc = new CellConstraints();
        this.configurationsComboBox = new JComboBox();
        this.addConfigBtn = new JButton(ModelerUtil.buildIcon("icon-new.png"));
        this.addConfigBtn.setToolTipText("New configuration");
        this.editConfigBtn = new JButton(ModelerUtil.buildIcon("icon-edit.png"));
        this.editConfigBtn.setToolTipText("Rename configuration");
        this.removeConfigBtn = new JButton(ModelerUtil.buildIcon("icon-trash.png"));
        this.removeConfigBtn.setToolTipText("Remove configuration");
        configCroupBuilder.add(this.configurationsComboBox, cc.xy(1, 1));
        configCroupBuilder.add((Component)this.addConfigBtn, cc.xy(3, 1));
        configCroupBuilder.add((Component)this.editConfigBtn, cc.xy(5, 1));
        configCroupBuilder.add((Component)this.removeConfigBtn, cc.xy(7, 1));
        return configCroupBuilder.getPanel();
    }

    private JPanel getGeneratePanel() {
        this.generateButton = new JButton("Generate");
        this.generateButton.setIcon(ModelerUtil.buildIcon("icon-gen_java.png"));
        this.generateButton.setEnabled(false);
        FormLayout generateCroupLayout = new FormLayout("60dlu", "p");
        PanelBuilder generateCroupBuilder = new PanelBuilder(generateCroupLayout);
        CellConstraints cc = new CellConstraints();
        generateCroupBuilder.add((Component)this.generateButton, cc.xy(1, 1));
        return generateCroupBuilder.getPanel();
    }

    public JButton getGenerateButton() {
        return this.generateButton;
    }

    public JComboBox<String> getConfigurationsComboBox() {
        return this.configurationsComboBox;
    }

    public JButton getAddConfigBtn() {
        return this.addConfigBtn;
    }

    public JButton getEditConfigBtn() {
        return this.editConfigBtn;
    }

    public JButton getRemoveConfigBtn() {
        return this.removeConfigBtn;
    }
}

